#pragma once

#include "Error.h"
#include "TransportSerial.h"


enum ERF_CMD
{
	RF_VERSION	= 0,
	RF_READ_EEPROM,
	RF_SET_PROTOCOL,
	RF_ABORT_CONT_READ,
	RF_GET_SEL_CARD,
	RF_AUTH_14443A,
	RF_READ,
	RF_WRITE,

	RF_UNKNOWN
};

typedef struct _READ_WRITE_INFO
{
	BYTE	bCardIdLen;
	BYTE	pCardId[0x20];
	BOOL	bKeyB;
	BYTE	pKey[0x06];
	ULONG	ulStartSect;
	ULONG	ulNrSect;
}READ_WRITE_INFO, *PREAD_WRITE_INFO;

class CHIDProtocol
{
private:
	CTransportSerial	m_clsTransport;
	READ_WRITE_INFO		m_stReadWriteInfo;
	BYTE				m_bSelProt;

private:
	EERROR SendCmd(ERF_CMD eCmd, BYTE* pData, DWORD dwData);
	EERROR RecvCmd(BYTE* pData, DWORD& dwData);

public:
	CHIDProtocol();
	virtual ~CHIDProtocol();

	virtual EERROR Open();
	virtual EERROR GetVersion(BYTE* pData, DWORD& dwSize);
	virtual EERROR GetStationID(BYTE* pData, DWORD& dwSize);
	virtual EERROR SetProtocol(BYTE bProt);
	virtual EERROR GetCard(BYTE* pData, DWORD dwSize, DWORD& dwNrCards);
	virtual EERROR AboartContRead();
	virtual EERROR AuthIso14443A(UINT nSect);
	virtual EERROR SelectCard();
	virtual void SetReadWriteInfo(READ_WRITE_INFO* pReadWrite);
	virtual EERROR Read(BYTE* pData, DWORD& dwData);
	virtual EERROR Write(BYTE* pData, DWORD dwData);
	virtual EERROR Close();
};