#include "stdafx.h"
#include "DataTransfer.h"

CDataTransfer::CDataTransfer()
{
	m_bStopThread	= FALSE;
	CallBackRead	= NULL;
	m_pCustomData	= NULL;
	m_dwMaskAntena	= 0x00;
	m_hThreadEvent	= CreateEvent(NULL, TRUE, TRUE, NULL);
	m_hDataEvent	= CreateEvent(NULL, FALSE, TRUE, NULL);
	m_strLastCard	= "";
	m_dwTimeIns		= 0x00;
}

CDataTransfer::~CDataTransfer()
{
	if(m_hThreadEvent != INVALID_HANDLE_VALUE)
	{
		CloseHandle(m_hThreadEvent);
	}
}

void CDataTransfer::StopThread(BOOL bStop)
{
	m_bStopThread = bStop;
	if(bStop == FALSE)
	{
		ResetEvent(m_hThreadEvent);
	}
}

BOOL CDataTransfer::IsThreadStoped()
{
	return m_bStopThread;
}

void CDataTransfer::SetThreadEvent()
{
	SetEvent(m_hThreadEvent);
}

void CDataTransfer::WaitForThread()
{
	WaitForSingleObject(m_hThreadEvent, INFINITE);
}

void CDataTransfer::InsertData(std::string strCard)
{
	WaitForSingleObject(m_hDataEvent, INFINITE);
	m_strLastCard	= strCard;
	m_dwTimeIns		= GetTickCount();
	SetEvent(m_hDataEvent);
}

std::string CDataTransfer::GetData()
{
	WaitForSingleObject(m_hDataEvent, INFINITE);
	std::string strCard = m_strLastCard;

	// if card was seen it about 300 ms then it's a new card
	if((GetTickCount() - m_dwTimeIns) > 300)
	{
		strCard = "";
	}
	SetEvent(m_hDataEvent);
	return strCard;
}
