#pragma once

#include "Def.h"

// this class it's implemented because some serial to USB
// chipsets has problem using overlap flag - Silicon Labs CP210X
class CTransportSerial 
{
private:
	UINT	m_nCom;
	UINT	m_nSpeed;
	UINT	m_nDataBits;
	UINT	m_nParity;
	UINT	m_nStopBits;
	HANDLE	m_hDevFile;

public:
	CTransportSerial();
	CTransportSerial(UINT nCom, UINT nSpeed = 57600, UINT nDataBits = 8, UINT nParity = 0, UINT nStopBits = 1);
	virtual ~CTransportSerial();

	virtual EERROR Open();
	virtual EERROR Close();
	virtual EERROR Write(BYTE* pData, DWORD dwSize);
	virtual EERROR Read(BYTE* pData, DWORD& dwSize);
	virtual void SetOption(UINT nCom, UINT nSpeed = 38400, UINT nDataBits = 8, UINT nParity = 0, UINT nStopBits = 1);
};