#pragma once

#include "Def.h"
#include "TransportSerial.h"
#include "DataTransfer.h"

typedef struct _READ_WRITE_INFO
{
	BYTE	nCardIdLen;
	BYTE	pCardId[0x20];
	BYTE	pPass[0x04];
	BYTE	bBank;
	ULONG	ulStartAddress;
}READ_WRITE_INFO;

typedef struct _KILL_TAG_INFO
{
	BYTE	nCardIdLen;
	BYTE	pCardId[0x20];
	BYTE	pPass[0x04];
}KILL_TAG_INFO;

typedef struct _LOCK_TYPE_INFO
{
	BYTE	nCardIdLen;
	BYTE	pCardId[0x20];
	BYTE	pPass[0x04];
	BYTE	bBank;
	BYTE	bLockType;
}LOCK_TYPE_INFO;

enum ERF_CMD
{
	RF_GET_SERIAL	= 0,
	RF_READER_TYPE,
	RF_HARDWARE_REV,
	RF_SOFTWARE_REV,
	RF_BOOTLOADER_REV,
	RF_CURRENT_STATE,
	RF_GET_ATTENUATION,
	RF_GET_FREQ,
	RF_GET_SENSIVITY,
	RF_REBOOT,
	RF_SET_ANTENA,
	RF_SET_ATTENUATION,
	RF_SET_FREQ,
	RF_SET_SENSIVITY,
	RF_RESET_SETTINGS,
	RF_SAVE_SETTINGS,
	RF_INVENTORY_SINGLE,
	RF_INVENTORY_CYCLIC,
	RF_READ_FROM_TAG,
	RF_WRITE_TO_TAG,
	RF_LOCK_TAG,
	RF_KILL_TAG,
	RF_INVENTORY_CYCLIC_INT,
	RF_STATE_CHANGE_INT,
	RF_UNKNOWN
};

class CRFEmbProtocol
{
private:
	CTransportSerial	m_clsTransport;
	READ_WRITE_INFO		m_stReadWriteInfo;
	BOOL m_bUseTab;
	BOOL m_bUseReturn;

private:
	DWORD IdentifyCmd(BYTE* pData);

public:
	EERROR SendCmd(ERF_CMD eCmd, BYTE* pData, DWORD dwData);
	EERROR GetData(ERF_CMD eCmd, BYTE** pData, DWORD& dwData);
	EERROR GetData(DWORD& eCmd, BYTE** pData, DWORD& dwData);
	EERROR GetFirmware(char* szData, DWORD dwSize);
	EERROR GetFirmwareRaw(BYTE* pData, DWORD& dwSize);
	EERROR GetReaderType(char* szData, DWORD dwSize);
	EERROR GetReaderTypeRaw(BYTE* pData, DWORD& dwSize);
	EERROR GetHardwareRev(BYTE* pData, DWORD& dwSize);
	EERROR GetSoftwareRev(BYTE* pData, DWORD& dwSize);
	EERROR GetBootLoaderRev(BYTE* pData, DWORD& dwSize);
	EERROR GetCurrentState(BYTE* pData, DWORD& dwSize);
	EERROR GetAttenuation(BYTE* pData, DWORD& dwSize);
	EERROR GetSensivity(BYTE* pData, DWORD& dwSize);
	EERROR GetFreq(BYTE* pData, DWORD& dwSize);
	EERROR SetAttenuation(DWORD dwCurrent);
	EERROR SetSensivity(short shCurrent);
	EERROR SetFreq(BYTE* pData, UINT nDataSize);
	EERROR Reboot();
	EERROR ResetSettings();
	EERROR SaveSettings();
	EERROR GetCard(BYTE* pData, DWORD& dwData);
	EERROR Read(BYTE* pData, DWORD& dwData);
	EERROR Write(BYTE* pData, DWORD dwData);
	EERROR KillTag(KILL_TAG_INFO* pKillTagInfo);
	EERROR LockTag(LOCK_TYPE_INFO* pLockTypeInfo);

public:
	CDataTransfer	m_clsDataTranfer;

public:
	CRFEmbProtocol();
	virtual ~CRFEmbProtocol();
	virtual EERROR Open();
	virtual void SetCom(UINT nCom);
	virtual void SetTabAndReturn(BOOL bUseTab, BOOL bUseReturn);
	virtual BOOL IsReturnUsed();
	virtual BOOL IsTabUsed();
	virtual void SetReadWriteInfo(READ_WRITE_INFO* pReadWrite);
	virtual EERROR StartReading();
	virtual EERROR StopReading();
	virtual EERROR Close();
};