#pragma once

#include "TransportSerial.h"
typedef struct _TLVS
{
	BYTE bTag;
	BYTE bLen;
	BYTE pData[0x01];
}TLVS, *PTLVS;

#define CARD_ID_LEN		0x0A
#define ATS_LEN			0x05
#define HISTORIC_LEN	0x0A
typedef struct _CARD_INFO
{
	BYTE bCardType;
	BYTE bCardSubType;
	BYTE bLenCardId;
	BYTE pCardId[CARD_ID_LEN];
	BYTE bLenATS;
	BYTE pCardATS[ATS_LEN];
	BYTE bLenHistoricByte;
	BYTE pHistoricByte[HISTORIC_LEN];
	BYTE bLegicMCC;
}CARD_INFO, *PCARD_INFO;

class CLegicProtocol// : public ILegicProtocol
{
private:
	CTransportSerial	m_clsTransport;

private:
#ifdef _LEGIC_EXT
	void ScanTLVS(BYTE* pData, DWORD& dwSize, CARD_INFO* pCardInfo);
#endif
	EERROR SendData(ECMDLEGIC eCmd, BYTE* pData, DWORD dwSize);
	EERROR RecvData(ECMDLEGIC eCmd, BYTE** pData, DWORD& dwSize);
	EERROR ExecCmd(ECMDLEGIC eCmd, BYTE* pDataIn, DWORD dwSizeIn, BYTE** pDataOut, DWORD& dwSizeOut);

public:
	CLegicProtocol();
	virtual ~CLegicProtocol();

	virtual EERROR Open();
	virtual void SetCom(UINT nCom);
	virtual EERROR GetState(BYTE& bState);
	virtual EERROR SetState(ESTATE eState);
	virtual EERROR GetCards(ECARDTYPE eCardType, DWORD& dwCards, BYTE** pCards, DWORD& dwSize);
#ifdef _LEGIC_EXT
	virtual EERROR GetCardsExt(ECARDTYPE eCardType, DWORD& dwCards, BYTE** pCards, DWORD& dwSize);
#endif
	virtual EERROR SelectCard(ECARDTYPE eCardType, DWORD dwCard, DWORD dwSpeed);
	virtual EERROR SelectFile(UINT nSeg, EFILETYPE eFileType, BYTE* pStamp, DWORD dwStamp, DWORD& dwFileSize);
	virtual EERROR ReadFile(DWORD dwAddress, BYTE* pData, DWORD& dwSize);
	virtual EERROR WriteFile(DWORD dwAddress, BYTE* pData, DWORD dwSize);
#ifdef _LEGIC_EXT
	virtual EERROR Envelope(BYTE* pBufIn, DWORD dwSizeIn, BYTE** pBufOut, DWORD& dwSizeOut);
#endif
	virtual EERROR GetIDB(DWORD dwTag, BYTE** pData, DWORD& dwSize);
	virtual EERROR SetLeds(BOOL bOn);
	virtual EERROR SetBuzzer(BOOL bOn);
	virtual EERROR Close();
};