#pragma once

#include "TransportSerial.h"


class CLegicProtocol// : public ILegicProtocol
{
private:
	CTransportSerial	m_clsTransport;

private:
	EERROR SendData(ECMDLEGIC eCmd, BYTE* pData, DWORD dwSize);
	EERROR RecvData(ECMDLEGIC eCmd, BYTE** pData, DWORD& dwSize);
	EERROR ExecCmd(ECMDLEGIC eCmd, BYTE* pDataIn, DWORD dwSizeIn, BYTE** pDataOut, DWORD& dwSizeOut);

public:
	CLegicProtocol();
	virtual ~CLegicProtocol();

	virtual EERROR Open();
	virtual void SetCom(UINT nCom);
	virtual EERROR GetState(BYTE& bState);
	virtual EERROR SetState(ESTATE eState);
	virtual EERROR GetCards(ECARDTYPE eCardType, DWORD& dwCards, BYTE** pCards, DWORD& dwSize);
	virtual EERROR SelectCard(ECARDTYPE eCardType, DWORD dwCard, DWORD dwSpeed);
	virtual EERROR SelectFile(UINT nSeg, EFILETYPE eFileType, BYTE* pStamp, DWORD dwStamp, DWORD& dwFileSize);
	virtual EERROR ReadFile(DWORD dwAddress, BYTE* pData, DWORD& dwSize);
	virtual EERROR WriteFile(DWORD dwAddress, BYTE* pData, DWORD dwSize);
	virtual EERROR GetIDB(DWORD dwTag, BYTE** pData, DWORD& dwSize);
	virtual EERROR SetLeds(BOOL bOn);
	virtual EERROR SetBuzzer(BOOL bOn);
	virtual EERROR Close();
};