#pragma once

#include "Def.h"
#include "TransportSerial.h"


enum EHF_CMD
{
	HF_GET_VERSION	= 0x00,
	HF_GET_CARDS14443A,
	HF_READ_CARDS14443A,
	HF_UNKNOWN
};

class CHFProtocol 
{
private:
	CTransportSerial	m_clsTransport;
	BYTE				m_bAddress;

private:
	EERROR SendCmd(EHF_CMD eCmd, BYTE* pData, DWORD dwData);
	EERROR RecvData(BYTE** pData, DWORD& dwSize);
	EERROR CheckProtocol(BYTE* pData, DWORD dwSize);

public:
	CHFProtocol(UINT nCom);
	virtual ~CHFProtocol();

	virtual EERROR Open();
	EERROR GetFirmware(BYTE* pData, DWORD& dwSize);
	virtual EERROR GetCards14443A(BYTE** pCards, DWORD& dwSize);
	EERROR Read14443(BYTE* pKey, BOOL bKeyA, DWORD dwStartBlock, DWORD dwNrBlocks,  BYTE* pData, DWORD& dwData);
	virtual EERROR Close();

};