#include "stdafx.h"

#include "SoapFile.h"
#include <iostream>
#include <sstream>
#include <string>


SOAP_NMAC struct Namespace namespaces[] =
{
	{"SOAP-ENV", "http://schemas.xmlsoap.org/soap/envelope/", "http://www.w3.org/*/soap-envelope", NULL},
	{"SOAP-ENC", "http://schemas.xmlsoap.org/soap/encoding/", "http://www.w3.org/*/soap-encoding", NULL},
	{"xsi", "http://www.w3.org/2001/XMLSchema-instance", "http://www.w3.org/*/XMLSchema-instance", NULL},
	{"xsd", "http://www.w3.org/2001/XMLSchema", "http://www.w3.org/*/XMLSchema", NULL},
	{NULL, NULL, NULL, NULL}
};

CSoapFile::CSoapFile()
{

}

CSoapFile::~CSoapFile()
{

}

soap* CSoapFile::CreateSoapFile(std::string strFileOpen)
{
	soap* pSoap = NULL;

	FILE* pFile = fopen(strFileOpen.c_str(), "w+b");
	if(pFile != NULL)
	{
		pSoap = soap_new();
		pSoap->version = 2;
		soap_init(pSoap);

		pSoap->sendfd		= pFile;

		soap_begin(pSoap);
		soap_set_namespaces(pSoap, namespaces);
	}

	return pSoap;
}

void CSoapFile::DeleteSoapFile(soap* pSoap)
{
	if(pSoap != NULL)
	{
		fclose(pSoap->sendfd);
		soap_destroy(pSoap);  
		soap_end(pSoap);
		soap_done(pSoap);
		free(pSoap);
	}
}