#include "stdafx.h"
#include "R-HH-M3O-LEG42-USB-SDK-DEMO.h"
#include "DlgLedBuzz.h"
#include "R-HH-M3O-LEG42-USB-SDK.h"



IMPLEMENT_DYNAMIC(CDlgLedBuzz, CPropertyPage)

CDlgLedBuzz::CDlgLedBuzz()
	: CPropertyPage(CDlgLedBuzz::IDD)
{

}

CDlgLedBuzz::~CDlgLedBuzz()
{
}

void CDlgLedBuzz::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_BTN_BUZZER, m_ctrlBuzzer);
	DDX_Control(pDX, IDC_BTN_LED, m_ctrlLeds);
}


BEGIN_MESSAGE_MAP(CDlgLedBuzz, CPropertyPage)
	ON_BN_CLICKED(IDOK, &CDlgLedBuzz::OnBnClickedOk)
END_MESSAGE_MAP()



void CDlgLedBuzz::OnBnClickedOk()
{
	SDKHANDLE hReader = OpenReader(0x01);
	if(hReader != NULL)
	{
		BYTE bBuzzer = m_ctrlBuzzer.GetCheck();
		SetReaderCaps(hReader, ERD_BUZZER, &bBuzzer, sizeof(BYTE));

		BYTE bLeds = m_ctrlLeds.GetCheck();
		SetReaderCaps(hReader, ERD_LEDS, &bLeds, sizeof(BYTE));

		CloseReader(hReader);
	}	
}
