#include "stdafx.h"
#include "R-HH-M3O-LEG42-USB-SDK-DEMO.h"
#include "DlgCardScan.h"

#include "SoapFile.h"
#include "CardInfoH.h"

#include "Utility.h"

static SCAN_TYPE tbScanType[]=
{
	{ECARD_LEGIC,			_T("Card Legic")		},
	{ECARD_ISO15693,		_T("Card Iso15693")		},
	{ECARD_ISO14443A,		_T("Card Iso14443A")	},
	{ECARD_ISO14443B,		_T("Card Iso14443B")	},
	{ECARD_INSIDESECURE,	_T("Card Inside Secure")},
	{ECARD_SONYFELICA,		_T("Card Sony Felica")	},
};

IMPLEMENT_DYNAMIC(CDlgCardScan, CPropertyPage)

CDlgCardScan::CDlgCardScan()
	: CPropertyPage(CDlgCardScan::IDD)
{

}

CDlgCardScan::~CDlgCardScan()
{
}

void CDlgCardScan::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST_CARD, m_ctrlCard);
	DDX_Control(pDX, IDC_CHECK_SAVE, m_ctrlSave);
	DDX_Control(pDX, IDC_EDIT_SCAN_SAVE, m_ctrlSavePath);
	DDX_Control(pDX, IDC_BUTTON_SCAN_SAVE, m_btnSave);
}


BEGIN_MESSAGE_MAP(CDlgCardScan, CPropertyPage)
	ON_BN_CLICKED(IDOK, &CDlgCardScan::OnBnClickedOk)
	ON_BN_CLICKED(IDC_BUTTON_SCAN_SAVE, &CDlgCardScan::OnBnClickedButtonScanSave)
	ON_BN_CLICKED(IDC_CHECK_SAVE, &CDlgCardScan::OnBnClickedCheckSave)
	ON_WM_TIMER()
END_MESSAGE_MAP()


void CDlgCardScan::InsertColumn(UINT nCol, TCHAR* szData, UINT nMaxLen)
{
	if(szData != NULL)
	{
		LV_COLUMN stLvc;
		stLvc.mask		= LVCF_FMT | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
		stLvc.iSubItem	= nCol;
		stLvc.pszText	= szData;
		stLvc.cx		= nMaxLen;
		stLvc.fmt		= LVCFMT_LEFT;
		m_ctrlCard.InsertColumn(nCol, &stLvc);
	}
}

void CDlgCardScan::InsertItem(UINT nIntem, UINT nSubItem, TCHAR* szString, UINT nImage)
{
	LVITEM stLvItem;
	::ZeroMemory(&stLvItem, sizeof(LVITEM));

	stLvItem.iItem = nIntem;
	stLvItem.iSubItem = nSubItem;
	stLvItem.mask = LVIF_TEXT | LVIF_STATE;
	if(nImage != -1)
	{
		stLvItem.mask |= LVIF_IMAGE;
		stLvItem.iImage	 = nImage;
	}
	stLvItem.pszText = szString;
	stLvItem.cchTextMax = (int)_tcslen(szString) + 1;

	if(nSubItem == 0x00)
	{
		// set the default count to 1 - in item data
		//
		m_ctrlCard.SetItemData(m_ctrlCard.InsertItem(&stLvItem), 0x01);
	}

	if(nSubItem > 0x00)
		m_ctrlCard.SetItem(&stLvItem);
}

#define ICON_SIZE	0x10
BOOL CDlgCardScan::OnInitDialog()
{
	CDialog::OnInitDialog();

	m_nStepTimer	= 0x00;
	m_hSdk			= NULL;

	InsertColumn(0, _T("Card type"), 80);
	InsertColumn(1, _T("Card id"), 150);

	m_lstImage.Create(ICON_SIZE, ICON_SIZE, ILC_COLOR16 | ILC_MASK, 0x01, 0x02);

	HICON hIcon = AfxGetApp()->LoadIcon(IDI_CARD);
	m_lstImage.Add(hIcon);
	m_ctrlCard.SetImageList(&m_lstImage, LVSIL_SMALL);

	m_ctrlCard.ModifyStyle(0, LVS_SHOWSELALWAYS | LVS_REPORT);
	m_ctrlCard.SetExtendedStyle( /*LVS_EX_FLATSB |*/LVS_EX_FULLROWSELECT);

	OnBnClickedCheckSave();
	SetImageIcon(FALSE);

	return TRUE;
}

CString CDlgCardScan::ByteToString(BYTE* pData, UINT nSize)
{
	CString strRet = _T("");
	if((pData != NULL) && (nSize > 0))
	{
		CHAR szData[MAX_PATH];
		for(UINT nCount = 0; nCount < nSize; nCount++)
		{
			sprintf(szData, "%02X", pData[nCount]);
			strRet += szData;
		}
	}
	return strRet;
}

void CDlgCardScan::SetImageIcon(BOOL bOn)
{
	CWnd* pWndOff = GetDlgItem(IDC_ICON_POWEROFF);
	CWnd* pWndOn = GetDlgItem(IDC_ICON_POWERON);
	if((pWndOff != NULL) && (pWndOn != NULL))
	{
		pWndOn->ShowWindow(bOn ? SW_SHOW : SW_HIDE);
		pWndOff->ShowWindow(bOn ? SW_HIDE : SW_SHOW);
	}
}

void CDlgCardScan::OnBnClickedOk()
{
	m_ctrlCard.DeleteAllItems();
	m_hSdk = NULL;

	if((m_hSdk = OpenReader(0x01)) != NULL)
	{
		SetTimer(10, 100, NULL);
		m_nStepTimer = 0x00;
		m_btnSave.EnableWindow(FALSE);
		SetImageIcon(TRUE);
	}
}

static TCHAR BASED_CODE szFilter[] = _T("Xml Files (*.xml)|*.xml|All Files (*.*)|*.*||");
void CDlgCardScan::OnBnClickedButtonScanSave()
{
	CFileDialog clsSaveFile(FALSE, _T("xml"), _T(""), OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, szFilter);
	if(clsSaveFile.DoModal() == IDOK)
	{
		CString strPath = clsSaveFile.GetPathName();
		m_ctrlSavePath.SetWindowText(strPath);
	}
}

void CDlgCardScan::OnBnClickedCheckSave()
{
	BOOL bSave = m_ctrlSave.GetCheck();
	m_btnSave.EnableWindow(bSave);
}

void CDlgCardScan::OnTimer(UINT_PTR nIDEvent)
{
	// check if we should write data to file
	BOOL bWrite = m_ctrlSave.GetCheck() ? TRUE : FALSE;

	USES_CONVERSION;
	ns1__CardInfoList	stCardList;

	TCHAR szItem[MAX_PATH];

	DWORD dwTotalCards = 0x00;
	for(UINT nCount = ECARD_LEGIC; nCount <= ECARD_SONYFELICA; nCount++)
	{
		BYTE pDataRet[MAX_PATH]; DWORD dwDataRet = MAX_PATH;
		*((DWORD*)pDataRet) = nCount;
		EERROR eRet = GetReaderCaps(m_hSdk, ERD_CARD, pDataRet, dwDataRet);
		if(eRet == ER_OK)
		{
			dwTotalCards += *((DWORD*)pDataRet);
			DWORD dwNav = sizeof(DWORD);
			for(DWORD dwCard = 0; dwCard < *((DWORD*)pDataRet); dwCard++)
			{
				CString strCardID = ByteToString(pDataRet + dwNav + 1, pDataRet[dwNav]);

				BOOL bFound = FALSE;
				for(int iCount = 0; iCount < m_ctrlCard.GetItemCount(); iCount++)
				{
					ZeroMemory(szItem, MAX_PATH);
					LVITEM stItem;
					stItem.mask			= LVIF_TEXT | LVIF_STATE;
					stItem.iItem		= iCount;
					stItem.iSubItem		= 0x01;
					stItem.pszText		= szItem;
					stItem.cchTextMax	= MAX_PATH;
					m_ctrlCard.GetItem(&stItem);
					if(strCardID == T2A(szItem))
					{
						bFound = TRUE;
					}
				}

				if(!bFound)
				{
					InsertItem(0, 0, tbScanType[nCount].szMsg, -1);
					InsertItem(0, 1, (TCHAR*)(LPCTSTR)strCardID, -1);
				}

				m_ctrlCard.SetItemData(0, nCount);
				dwNav += pDataRet[dwNav] + 0x01;
			}
		}

		m_ctrlCard.SetItemState(0, LVIS_SELECTED, LVIS_SELECTED);
	}

	if(m_nStepTimer >= 10)
	{
		CloseReader(m_hSdk);
		m_hSdk = NULL;
		m_btnSave.EnableWindow(TRUE);
		SetImageIcon(FALSE);

		if(bWrite && (m_ctrlCard.GetItemCount() > 0x00))
		{
			CString strPath = _T("");
			m_ctrlSavePath.GetWindowText(strPath);

			if(strPath.GetLength() > 0x04)
			{
				CSoapFile clsSoapFile;
				soap* pSoap = clsSoapFile.CreateSoapFile(T2A((LPCTSTR)strPath));

				for(int iCount = 0; iCount < m_ctrlCard.GetItemCount(); iCount++)
				{
					ZeroMemory(szItem, MAX_PATH);
					LVITEM stItem;
					stItem.mask			= LVIF_TEXT | LVIF_STATE;
					stItem.iItem		= iCount;
					stItem.iSubItem		= 0x01;
					stItem.pszText		= szItem;
					stItem.cchTextMax	= MAX_PATH;
					m_ctrlCard.GetItem(&stItem);
					UINT nCardType = (UINT)m_ctrlCard.GetItemData(iCount);

					stCardList.CardInfo.push_back(CUtility::GetSoapData(T2A(szItem), T2A(tbScanType[nCardType].szMsg)));
				}


				stCardList.soap_put(pSoap, "CardInfoList", NULL);
				clsSoapFile.DeleteSoapFile(pSoap);
			}
		}
		KillTimer(10);
	}
	m_nStepTimer++;

	CPropertyPage::OnTimer(nIDEvent);
}
