#include "stdafx.h"
#include "R-HH-M3O-LEG42-USB-SDK.h"
#include "R-HH-M3O-LEG42-USB-SDK-DEMO.h"
#include "DlgReadWrite.h"



IMPLEMENT_DYNAMIC(CDlgReadWrite, CPropertyPage)

CDlgReadWrite::CDlgReadWrite()
	: CPropertyPage(CDlgReadWrite::IDD)
{

}

CDlgReadWrite::~CDlgReadWrite()
{
}

void CDlgReadWrite::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COMBO_CARD, m_ctrlCard);
	DDX_Control(pDX, IDC_EDIT_DATA, m_ctrlData);
	DDX_Control(pDX, IDC_COMBO2, m_ctrlDataCount);
}


BEGIN_MESSAGE_MAP(CDlgReadWrite, CPropertyPage)
	ON_BN_CLICKED(IDC_BUTTON_READ, &CDlgReadWrite::OnBnClickedButtonRead)
	ON_BN_CLICKED(IDC_BUTTON_WRITE, &CDlgReadWrite::OnBnClickedButtonWrite)
	ON_BN_CLICKED(IDC_BUTTON_CARD, &CDlgReadWrite::OnBnClickedButtonCard)
END_MESSAGE_MAP()


BOOL CDlgReadWrite::OnInitDialog()
{
	CDialog::OnInitDialog();
	CString strTmp = _T("");
	for(UINT nCount = 0; nCount < 0x100; nCount++)
	{
		strTmp.Format(_T("%d"), nCount);
		m_ctrlDataCount.AddString(strTmp);
	}

	m_ctrlDataCount.SetCurSel(0x00);

	return TRUE;
}

void CDlgReadWrite::OnBnClickedButtonRead()
{
	UINT nSelCard = m_ctrlCard.GetCurSel();
	if(nSelCard != LB_ERR)
	{
		SDKHANDLE hReader = OpenReader(0x01);
		if(hReader != NULL)
		{
			USES_CONVERSION;

			UINT nSelCard = m_ctrlCard.GetCurSel();
			DWORD pDataSelCard[0x03];
			pDataSelCard[0x00] = ECARD_LEGIC;
			pDataSelCard[0x01] = nSelCard;
			pDataSelCard[0x02] = 0;

			EERROR eRet = SetReaderCaps(hReader, ERD_CARD, (BYTE*)pDataSelCard, 3 * sizeof(DWORD));
			if(eRet == ER_OK)
			{
				DWORD dwDataSelFile[0x04];
				dwDataSelFile[0x00] = 0x00; // segment
				dwDataSelFile[0x01] = FILE_DATA_SEG; // type of segment
				dwDataSelFile[0x02] = 0x00; // no stamp for segment

				if((eRet = SetReaderCaps(hReader, ERD_SELECT_FILE, (BYTE*)pDataSelCard, 3 * sizeof(DWORD))) == ER_OK)
				{
					BYTE pDataRet[MAX_PATH]; DWORD dwDataRet = 0x10;
					if((eRet = ReadData(hReader, 0x01, pDataRet, dwDataRet)) == ER_OK)
					{
						m_ctrlData.SetWindowText(ByteToString(pDataRet, dwDataRet));
					}
				}
			}
			CloseReader(hReader);
		}
	}
}

void CDlgReadWrite::OnBnClickedButtonWrite()
{
	UINT nSelCard = m_ctrlCard.GetCurSel();
	if(nSelCard != LB_ERR)
	{
		SDKHANDLE hReader = OpenReader(0x01);
		if(hReader != NULL)
		{
			USES_CONVERSION;

			UINT nSelCard = m_ctrlCard.GetCurSel();
			DWORD pDataSelCard[0x03];
			pDataSelCard[0x00] = ECARD_LEGIC;
			pDataSelCard[0x01] = nSelCard;
			pDataSelCard[0x02] = 0;

			EERROR eRet = SetReaderCaps(hReader, ERD_CARD, (BYTE*)pDataSelCard, 3 * sizeof(DWORD));
			if(eRet == ER_OK)
			{
				DWORD dwDataSelFile[0x04];
				dwDataSelFile[0x00] = 0x00; // segment
				dwDataSelFile[0x01] = FILE_DATA_SEG; // type of segment
				dwDataSelFile[0x02] = 0x00; // no stamp for segment

				if((eRet = SetReaderCaps(hReader, ERD_SELECT_FILE, (BYTE*)pDataSelCard, 3 * sizeof(DWORD))) == ER_OK)
				{
					BYTE pDataRet[MAX_PATH]; DWORD dwDataRet = 0x10;
					memset(pDataRet, (BYTE)m_ctrlDataCount.GetCurSel(), MAX_PATH);
					if((eRet = WriteData(hReader, 0x01, pDataRet, dwDataRet)) == ER_OK)
					{
						m_ctrlData.SetWindowText(ByteToString(pDataRet, dwDataRet));
					}
				}
			}
			CloseReader(hReader);
		}
	}
}


CString CDlgReadWrite::ByteToString(BYTE* pData, UINT nSize)
{
	CString strRet = _T("");
	if((pData != NULL) && (nSize > 0))
	{
		CHAR szData[MAX_PATH];
		for(UINT nCount = 0; nCount < nSize; nCount++)
		{
			sprintf(szData, "%02X", pData[nCount]);
			strRet += szData;
		}
	}
	return strRet;
}

void CDlgReadWrite::OnBnClickedButtonCard()
{
	m_ctrlCard.ResetContent();
	SDKHANDLE hReader = OpenReader(0x01);
	if(hReader != NULL)
	{
		USES_CONVERSION;
		DWORD dwTotalCards = 0x00;

		BYTE pDataRet[MAX_PATH]; DWORD dwDataRet = MAX_PATH;
		*((DWORD*)pDataRet) = ECARD_LEGIC;
		EERROR eRet = GetReaderCaps(hReader, ERD_CARD, pDataRet, dwDataRet);
		if(eRet == ER_OK)
		{
			dwTotalCards += *((DWORD*)pDataRet);
			DWORD dwNav = sizeof(DWORD);
			for(DWORD dwCard = 0; dwCard < *((DWORD*)pDataRet); dwCard++)
			{
				// display cards id !!!
				m_ctrlCard.AddString((TCHAR*)(LPCTSTR)ByteToString(pDataRet + dwNav + 1, pDataRet[dwNav]));
				dwNav += pDataRet[dwNav] + 0x01;
			}
		}

		m_ctrlCard.SetCurSel(0x00);
		CloseReader(hReader);
	}	
}
