package h.com.newserialapp.util;

import android.content.Context;
import android.widget.Toast;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * Created by huxiongda on 2018/6/7.
 */

public class Tools {

    /*字节转换成String*/
    public static String Bytes2HexString(byte[] b) {
        String ret = "";
        for (int i = 0; i < b.length; i++) {
            String hex = Integer.toHexString(b[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            ret += " 0x" + hex.toUpperCase();
        }
        return ret;
    }

    /**
     * To byte byte.
     *
     * @param hexString the hex string
     * @return the byte
     */
    public static byte toByte(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return 0x00;
        }
        hexString = hexString.replace(" ", "").toLowerCase();
        final byte byteArray;
        if (hexString.length() == 1) {
            byteArray = (byte) (Character.digit(hexString.charAt(0), 16) & 0xFF);
        } else {
            byte highDit = (byte) (Character.digit(hexString.charAt(0), 16) & 0xFF);
            byte lowDit  = (byte) (Character.digit(hexString.charAt(1), 16) & 0xFF);
            byteArray = (byte) (highDit << 4 | lowDit);
        }
        return byteArray;
    }

    /**
     * To byte array byte [ ].
     *
     * @param hexString the hex string
     * @return the byte [ ]
     */
    public static byte[] toByteArray(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.replace(" ", "").toLowerCase();
        final byte[] byteArray = new byte[hexString.length() >> 1];
        int index = 0;
        for (int i = 0; i < byteArray.length; i++) {
            byte highDit = (byte) (Character.digit(hexString.charAt(index), 16) & 0xFF);
            byte lowDit = (byte) (Character.digit(hexString.charAt(index + 1), 16) & 0xFF);
            byteArray[i] = (byte) (highDit << 4 | lowDit);
            index += 2;
        }
        return byteArray;
    }

    /**
     * byte[] to Hex string.
     *
     * @param byteArray the byte array
     * @return the string
     */
    public static String toHexString(byte[] byteArray, int arrayLen) {
        final StringBuilder hexString = new StringBuilder();
        if (byteArray == null || byteArray.length <= 0 || arrayLen <= 0) {
            return null;
        }
        for (int i = 0; i < arrayLen; i++) {
            int v = byteArray[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                hexString.append(0);
            }
            hexString.append(hv);
        }
        return hexString.toString().toLowerCase();
    }

    /**
     * 判断是否为空
     */
    public static boolean isNull(String str) {
        return str == null || str.equals("") || str.equals("null") || str.equals("NULL");
    }

    /**
     * 弹出吐司
     */
    public static void showToast(Context context, String content) {
        Toast.makeText(context, content, Toast.LENGTH_SHORT).show();
    }

    /**
     * 弹出吐司
     */
    public static void showToast(Context context, int content) {
        Toast.makeText(context, content, Toast.LENGTH_SHORT).show();
    }

    public static String formatDate(long date) {
        SimpleDateFormat format = new SimpleDateFormat("MM-dd HH:mm");
        return format.format(new Date(date));
    }


    private static byte[] current1;
    private static byte[] current2;
    private static int current1len;
    private static int current2len;


    /**
     * @param data1
     * @param data2
     * @return data1 与 data2拼接的结果
     */
    public static byte[] addBytes(byte[] data1, byte[] data2) {
        byte[] data3 = new byte[data1.length + data2.length];
        System.arraycopy(data1, 0, data3, 0, data1.length);
        System.arraycopy(data2, 0, data3, data1.length, data2.length);
        return data3;

    }

}
