package h.com.newserialapp.activity

import android.content.Intent
import android.graphics.Typeface
import android.os.Bundle
import android.support.v7.app.AppCompatActivity
import android.view.Menu
import android.view.MenuItem
import android.view.View
import h.com.newserialapp.R
import h.com.newserialapp.activity.AutoOperationActivity.AutoActivity
import h.com.newserialapp.activity.ConfigActivity.SerialPortConfigurationActivity
import h.com.newserialapp.activity.ISO14443A34Activity.ISO14443A3_4
import h.com.newserialapp.activity.ISO14443BActivity.ISO14443BActivity
import h.com.newserialapp.activity.ISO15693Activity.ISO15693Activity
import h.com.newserialapp.activity.MIAFREDESFireActivity.MifareDesFireActivity
import h.com.newserialapp.activity.MIFAREClassicActivity.MifareClassicActivity
import h.com.newserialapp.activity.MIFAREUltralightActivity.MifareUltralightActivity
import h.com.serialportapi.comn.SerialPortManager
import kotlinx.android.synthetic.main.activity_main.*

class MainActivity : AppCompatActivity(), View.OnClickListener {


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)
        bt_serial_port_configuration.setOnClickListener(this)
        bt_auto_list_cards.setOnClickListener(this)
        bt_iso14443a34.setOnClickListener(this)
        bt_mifare_classic.setOnClickListener(this)
        bt_mifare_ultralight.setOnClickListener(this)
        bt_iso14443b.setOnClickListener(this)
        bt_iso15693.setOnClickListener(this)
        bt_mifare_desfire.setOnClickListener(this)
        val typeface = Typeface.createFromAsset(this.assets, "fonts/Eurostile LT Demi.ttf")
        bt_auto_list_cards.typeface = typeface
        bt_serial_port_configuration.typeface = typeface
        bt_iso14443a34.typeface = typeface
        bt_mifare_classic.typeface = typeface
        bt_mifare_ultralight.typeface = typeface
        bt_iso14443b.typeface = typeface
        bt_iso15693.typeface = typeface
        bt_mifare_desfire.typeface = typeface
    }

    override fun onClick(v: View?) {
        when (v!!.id) {
            R.id.bt_serial_port_configuration -> {
                startActivity(Intent(this, SerialPortConfigurationActivity().javaClass))
            }
            R.id.bt_auto_list_cards -> {
                startActivity(Intent(this, AutoActivity().javaClass))
            }
            R.id.bt_iso14443a34 -> {
//                if (SerialPortManager.instance().getmSerialPort() == 0) {
                startActivity(Intent(this, ISO14443A3_4().javaClass))
//                } else if (SerialPortManager.instance().getmSerialPort() == 1) {
//                    ToastUtil.show(this, "Please first open serial port")
//                }
            }
            R.id.bt_mifare_classic -> {
//                if (SerialPortManager.instance().getmSerialPort() == 0) {
                startActivity(Intent(this, MifareClassicActivity().javaClass))
//                } else if (SerialPortManager.instance().getmSerialPort() == 1) {
//                    ToastUtil.show(this, "Please first open serial port")
//                }
            }
            R.id.bt_mifare_ultralight -> {
//                if (SerialPortManager.instance().getmSerialPort() == 0) {
                startActivity(Intent(this, MifareUltralightActivity().javaClass))
//                } else if (SerialPortManager.instance().getmSerialPort() == 1) {
//                    ToastUtil.show(this, "Please first open serial port")
//                }
            }
            R.id.bt_iso14443b -> {
               // if (SerialPortManager.instance().getmSerialPort() == 0) {
                    startActivity(Intent(this, ISO14443BActivity().javaClass))
              //  } else if (SerialPortManager.instance().getmSerialPort() == 1) {
              //      ToastUtil.show(this, "Please first open serial port")
               // }
            }
            R.id.bt_iso15693 -> {
//                if (SerialPortManager.instance().getmSerialPort() == 0) {
                startActivity(Intent(this, ISO15693Activity().javaClass))
//                } else if (SerialPortManager.instance().getmSerialPort() == 1) {
//                    ToastUtil.show(this, "Please first open serial port")
//                }
            }
            R.id.bt_mifare_desfire -> {
//                if (SerialPortManager.instance().getmSerialPort() == 0) {
                startActivity(Intent(this, MifareDesFireActivity().javaClass))
//                } else if (SerialPortManager.instance().getmSerialPort() == 1) {
//                    ToastUtil.show(this, "Please first open serial port")
//                }
            }
        }
    }

    override fun onCreateOptionsMenu(menu: Menu): Boolean {
        // Inflate the menu; this adds items to the action bar if it is present.
        menuInflater.inflate(R.menu.menu_main, menu)
        return true
    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        return when (item.itemId) {
            R.id.action_settings -> true
            else -> super.onOptionsItemSelected(item)
        }
    }

    override fun onDestroy() {
        SerialPortManager.instance().close()
        super.onDestroy()
    }
}
