package h.com.newserialapp.activity.MIAFREDESFireActivity;

import android.graphics.Typeface;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;

import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

import h.com.newserialapp.R;
import h.com.newserialapp.activity.BaseActivity;
import h.com.newserialapp.util.Tools;
import h.com.newserialapp.views.FontTextView;
import h.com.newserialapp.views.ScrollButton;
import h.com.serialportapi.comn.CommPacket;
import h.com.serialportapi.comn.Packet;
import h.com.serialportapi.comn.Reader;
import h.com.serialportapi.comn.SerialPortManager;
import h.com.serialportapi.comn.SerialReadThread;
import h.com.serialportapi.comn.message.ICMessage;
import h.com.serialportapi.comn.message.IMessage;

/**
 * Created by hxd on 2018/12/8.
 */

public class CardSysCommandActivity extends BaseActivity implements View.OnClickListener {
    private FontTextView tvTagType, tvSAK, tvUIDNumber, tvATS, tvVersion, tvBack, tvStatus;
    private ScrollButton btActiveCard, btRats, btGetVersion;

    private Reader reader;

    private Handler handler = new Handler(new Handler.Callback() {
        @Override
        public boolean handleMessage(Message msg) {
            switch (msg.what) {
                case 101:
                    tvTagType.setText(mICMessage.getTag_Type());
                    tvUIDNumber.setText(mICMessage.getUID_number());
                    tvSAK.setText(mICMessage.getSAK());
                    break;
                case 102:
                    if (!tempCommand.substring(0, 2).equals("F0")) {
                        tvATS.setText(tempCommand.substring(8, tempCommand.length() - 2));
                    }
                    break;
                case 103:
                    if (!tempCommand.substring(0, 2).equals("F0")) {
                        tvVersion.setText(tempCommand.substring(8, tempCommand.length() - 2));
                    }
                    break;
            }
            return false;
        }
    });

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_card_sys_commands);
        bindView();

        reader = SerialPortManager.instance().reader;
        if (reader == null) {
            Toast.makeText(this, "Please open the serial port first.", Toast.LENGTH_LONG).show();
        } else {
            reader.setLisenter(true);
        }
    }

    void bindView() {
        Typeface typeface = Typeface.createFromAsset(this.getAssets(), "fonts/Eurostile LT Demi.ttf");
        tvTagType = findViewById(R.id.tv_tag_type);
        tvSAK = findViewById(R.id.tv_sak);
        tvUIDNumber = findViewById(R.id.tv_uid_number);
        tvATS = findViewById(R.id.tv_ats);
        tvVersion = findViewById(R.id.tv_version);
        tvBack = findViewById(R.id.tv_back);
        tvStatus = findViewById(R.id.tv_status_bar);
        btActiveCard = findViewById(R.id.bt_active_card);
        btRats = findViewById(R.id.bt_rats);
        btGetVersion = findViewById(R.id.bt_get_version);
        btActiveCard.setTypeface(typeface);
        btRats.setTypeface(typeface);
        btGetVersion.setTypeface(typeface);
        tvBack.setOnClickListener(this);
        btActiveCard.setOnClickListener(this);
        btRats.setOnClickListener(this);
        btGetVersion.setOnClickListener(this);
    }

    private byte[] all = new byte[]{10, 52};
    private byte[] idle = new byte[]{10, 26};
    private ICMessage mICMessage;
    private String tempCommand;

    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.bt_active_card: {
                byte[] pATQ = new byte[2];
                byte[] pSak = new byte[1];
                byte[] pUIDLen = new byte[1];
                byte[] pUID = new byte[16];

                tvStatus.setText("");
                if (reader == null) {
                    Tools.showToast(this, "Please open the serial port first.");
                    return;
                }
                int result = reader.PiccActivate((byte) 0x10, (byte) 0x26, pATQ, pSak, pUIDLen, pUID);
                if (result == 0) {
                    tvTagType.setText(Tools.toHexString(pATQ, pATQ.length));
                    tvSAK.setText(Tools.toHexString(pSak, 1));
                    tvUIDNumber.setText(Tools.toHexString(pUID, pUIDLen[0]));
                } else {
                    tvTagType.setText("-");
                    tvSAK.setText("-");
                    tvUIDNumber.setText("");
                }
                break;
            }
            case R.id.bt_rats: {
                byte[] pATS = new byte[32];
                byte[] pATSLen = new byte[1];

                tvStatus.setText("");
                if (reader == null) {
                    Tools.showToast(this, "Please open the serial port first.");
                    return;
                }
                int result = reader.PiccRequestATS((byte)0x00, pATSLen, pATS);
                if (result == 0) {
                    tvATS.setText(Tools.toHexString(pATS, pATSLen[0]));
                } else {
                    tvATS.setText("");
                }
                break;
            }
            case R.id.bt_get_version: {
                byte[] relen = new byte[1];
                byte[] rebuf = new byte[1];

                tvStatus.setText("");
                if (reader == null) {
                    Tools.showToast(this, "Please open the serial port first.");
                    return;
                }
                int result = reader.DESGetDESVersion(relen, rebuf);
                if (result == 0) {
                    tvVersion.setText(Tools.toHexString(rebuf, relen[0]));
                } else {
                    tvVersion.setText("");
                }
                break;
            }
            case R.id.tv_back: {
                finish();
                break;
            }
        }
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onMessageEvent(IMessage message) {
        // 收到时间，刷新界面
        tvStatus.setText(message.getMessage());
    }

}
