package h.com.newserialapp.activity.ISO14443BActivity;

import android.graphics.Typeface;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

import h.com.newserialapp.R;
import h.com.newserialapp.activity.BaseActivity;
import h.com.newserialapp.util.ToastUtil;
import h.com.newserialapp.util.Tools;
import h.com.newserialapp.views.FontTextView;
import h.com.serialportapi.comn.CommPacket;
import h.com.serialportapi.comn.Reader;
import h.com.serialportapi.comn.SerialPortManager;
import h.com.serialportapi.comn.SerialReadThread;
import h.com.serialportapi.comn.message.IMessage;

/**
 * Created by hxd on 2018/12/3.
 */

public class ISO14443BActivity extends BaseActivity implements View.OnClickListener {
    private Button btActiveTypeB, btAPDU, btAPDUChannel;
    private FontTextView tvTagType, tvUIDNumber, tvCommand, tvPrevious, tvStatus;
    private EditText etAPDU, etAPDUChannel;

    private Reader reader;

    private Handler handler = new Handler(new Handler.Callback() {
        @Override
        public boolean handleMessage(Message msg) {
            switch (msg.what) {
                case 101:
                    tvTagType.setText("ISO14443B");
                    tvUIDNumber.setText(tempCommand.substring(8, tempCommand.length() - 2));
                    break;
            }
            return false;
        }
    });

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_iso14443b);
        bindView();

        reader = SerialPortManager.instance().reader;
        if (reader == null) {
            Toast.makeText(this, "Please open the serial port first.", Toast.LENGTH_LONG).show();
        } else {
            reader.setLisenter(true);
        }
    }

    void bindView() {
        Typeface typeface = Typeface.createFromAsset(this.getAssets(), "fonts/Eurostile LT Demi.ttf");
        btActiveTypeB = findViewById(R.id.bt_active_typeb);
        btAPDU = findViewById(R.id.bt_apdu);
        btAPDUChannel = findViewById(R.id.bt_apdu_channel);
        tvPrevious = findViewById(R.id.tv_back);
        tvTagType = findViewById(R.id.tv_tag_type);
        tvUIDNumber = findViewById(R.id.tv_uid_number);
        tvCommand = findViewById(R.id.tv_command);
        tvStatus = findViewById(R.id.tv_status_bar);
        etAPDU = findViewById(R.id.et_apdu);
        etAPDUChannel = findViewById(R.id.et_apdu_channel);
        btActiveTypeB.setOnClickListener(this);
        btAPDU.setOnClickListener(this);
        btAPDUChannel.setOnClickListener(this);
        tvPrevious.setOnClickListener(this);
        btActiveTypeB.setTypeface(typeface);
        btAPDU.setTypeface(typeface);
        btAPDUChannel.setTypeface(typeface);
    }

    private String tempCommand;

    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.bt_active_typeb: {
                byte[] pUIDLen = new byte[1];
                byte[] pUID = new byte[16];

                tvStatus.setText("");
                if (reader == null) {
                    Tools.showToast(this, "Please open the serial port first.");
                    return;
                }
                int result = reader.PiccActivateB((byte) 0x00, (byte) 0x00, (byte) 0x00, pUIDLen, pUID);
                if (result == 0) {
                    tvTagType.setText("ISO14443B");
                    tvUIDNumber.setText(Tools.toHexString(pUID, pUIDLen[0]));
                } else {
                    tvTagType.setText("-");
                    tvUIDNumber.setText("");
                }
                break;
            }
            case R.id.bt_apdu: {
                int [] pRcvLen = new int[1];
                byte[] pRcvBuf = new byte[1024];

                tvStatus.setText("");
                if (reader == null) {
                    Tools.showToast(this, "Please open the serial port first.");
                    return;
                }
                byte[] pSendBuf = Tools.toByteArray(etAPDU.getText().toString());
                if (pSendBuf == null || pSendBuf.length == 0) {
                    Tools.showToast(this, "APDU is not null");
                    return;
                }
                reader.PiccAPDU(pSendBuf.length, pSendBuf, pRcvLen, pRcvBuf);
                break;
            }
            case R.id.bt_apdu_channel: {
                int[] pRcvLen = new int[1];
                byte[] pRcvBuf = new byte[1024];

                tvStatus.setText("");
                if (reader == null) {
                    Tools.showToast(this, "Please open the serial port first.");
                    return;
                }
                byte[] pSendBuf = Tools.toByteArray(etAPDUChannel.getText().toString());
                if (pSendBuf == null || pSendBuf.length == 0) {
                    Tools.showToast(this, "APDU Channel is not null");
                    return;
                }
                reader.PiccTransfer(pSendBuf.length, pSendBuf, pRcvLen, pRcvBuf);
                break;
            }
            case R.id.tv_back: {
                finish();
                break;
            }
        }
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onMessageEvent(IMessage message) {
        // 收到时间，刷新界面
        tvStatus.setText(message.getMessage());
    }

}
