package h.com.newserialapp.activity.ISO14443A34Activity;

import android.graphics.Typeface;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.Nullable;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

import h.com.newserialapp.R;
import h.com.newserialapp.activity.BaseActivity;
import h.com.newserialapp.util.Tools;
import h.com.serialportapi.comn.Reader;
import h.com.serialportapi.comn.SerialPortManager;
import h.com.serialportapi.comn.message.ICMessage;
import h.com.serialportapi.comn.message.IMessage;

/**
 * Created by hxd on 2018/11/30.
 */

public class ISO14443A3_4 extends BaseActivity implements View.OnClickListener {
    private Button btActivieCard, btSendRATS, btSendAPDU, btAPDUChannel;
    private TextView tvTagType, tvSAK, tvUIDNumber, tvATS, tvBack, tvStatus;
    private EditText etAPDU, etAPDUChannel;

    private Reader reader;

    private Handler handler = new Handler(new Handler.Callback() {
        @Override
        public boolean handleMessage(Message msg) {
            switch (msg.what) {
                case 101:
                    tvTagType.setText(mICMessage.getTag_Type());
                    tvSAK.setText(mICMessage.getSAK());
                    tvUIDNumber.setText(mICMessage.getUID_number());
                    break;
                case 102:
                    if (!tempCommand.substring(0, 2).equals("F0")) {
                        tvATS.setText(tempCommand.substring(4, tempCommand.length() - 2));
                    } else {
                        tvATS.setText("");
                    }
                    break;
                case 103:
                    tvStatus.setText("receive instruction " + tempCommand);
                    break;
            }
            return false;
        }
    });

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.iso14443a3_4);
        bindView();

        reader = SerialPortManager.instance().reader;
        if (reader == null) {
            Toast.makeText(this, "Please open the serial port first.", Toast.LENGTH_LONG).show();
        } else {
            reader.setLisenter(true);
        }
    }

    void bindView() {
        Typeface typeface = Typeface.createFromAsset(this.getAssets(), "fonts/Eurostile LT Demi.ttf");
        btActivieCard = findViewById(R.id.bt_active_card);
        btSendAPDU = findViewById(R.id.bt_send_apdu);
        btSendRATS = findViewById(R.id.bt_send_rats);
        btAPDUChannel = findViewById(R.id.bt_apdu_channel);
        tvStatus = findViewById(R.id.tv_status_bar);
        tvTagType = findViewById(R.id.tv_tag_type);
        tvSAK = findViewById(R.id.tv_sak);
        tvATS = findViewById(R.id.tv_ats);
        btActivieCard.setTypeface(typeface);
        btSendAPDU.setTypeface(typeface);
        btSendRATS.setTypeface(typeface);
        btAPDUChannel.setTypeface(typeface);
        tvUIDNumber = findViewById(R.id.tv_uid_number);
        tvBack = findViewById(R.id.tv_back);
        etAPDU = findViewById(R.id.et_apdu);
        etAPDUChannel = findViewById(R.id.et_apdu_channel);
        setListener();
    }

    void setListener() {
        btActivieCard.setOnClickListener(this);
        btSendAPDU.setOnClickListener(this);
        btSendRATS.setOnClickListener(this);
        btAPDUChannel.setOnClickListener(this);
        tvBack.setOnClickListener(this);
    }

    private byte[] all = new byte[]{10, 52};
    private byte[] idle = new byte[]{10, 26};
    private ICMessage mICMessage;
    private String tempCommand;

    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.bt_active_card: {
                byte[] pATQ = new byte[2];
                byte[] pSak = new byte[1];
                byte[] pUIDLen = new byte[1];
                byte[] pUID = new byte[16];

                tvStatus.setText("");
                if (reader == null) {
                    Tools.showToast(this, "Please open the serial port first.");
                    return;
                }
                int result = reader.PiccActivate((byte) 0x10, (byte) 0x26, pATQ, pSak, pUIDLen, pUID);
                if (result == 0) {
                    tvTagType.setText(Tools.toHexString(pATQ, pATQ.length));
                    tvSAK.setText(Tools.toHexString(pSak, 1));
                    tvUIDNumber.setText(Tools.toHexString(pUID, pUIDLen[0]));
                } else {
                    tvTagType.setText("-");
                    tvSAK.setText("-");
                    tvUIDNumber.setText("");
                }
                break;
            }
            case R.id.bt_send_rats: {
                byte[] pATS = new byte[32];
                byte[] pATSLen = new byte[1];

                tvStatus.setText("");
                if (reader == null) {
                    Tools.showToast(this, "Please open the serial port first.");
                    return;
                }
                int result = reader.PiccRequestATS((byte)0x00, pATSLen, pATS);
                if (result == 0) {
                    tvATS.setText(Tools.toHexString(pATS, pATSLen[0]));
                } else {
                    tvATS.setText("");
                }
                break;
            }
            case R.id.bt_send_apdu: {
                int [] pRcvLen = new int[1];
                byte[] pRcvBuf = new byte[1024];

                tvStatus.setText("");
                if (reader == null) {
                    Tools.showToast(this, "Please open the serial port first.");
                    return;
                }
                byte[] pSendBuf = Tools.toByteArray(etAPDU.getText().toString());
                if (pSendBuf == null || pSendBuf.length == 0) {
                    Tools.showToast(this, "APDU is not null");
                    return;
                }
                reader.PiccAPDU(pSendBuf.length, pSendBuf, pRcvLen, pRcvBuf);
                break;
            }
            case R.id.bt_apdu_channel: {
                int [] pRcvLen = new int[1];
                byte[] pRcvBuf = new byte[1024];

                tvStatus.setText("");
                if (reader == null) {
                    Tools.showToast(this, "Please open the serial port first.");
                    return;
                }
                byte[] pSendBuf = Tools.toByteArray(etAPDUChannel.getText().toString());
                if (pSendBuf == null || pSendBuf.length == 0) {
                    Tools.showToast(this, "APDU Channel is not null");
                    return;
                }
                reader.PiccTransfer(pSendBuf.length, pSendBuf, pRcvLen, pRcvBuf);
                break;
            }
            case R.id.tv_back: {
                finish();
                break;
            }
        }
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onMessageEvent(IMessage message) {
        // 收到时间，刷新界面
        tvStatus.setText(message.getMessage());
    }

}
