package h.com.newserialapp.activity;

import android.os.Bundle;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;

import org.greenrobot.eventbus.EventBus;

import butterknife.ButterKnife;


public abstract class BaseActivity extends AppCompatActivity {

    protected ActionBar mActionBar;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ButterKnife.bind(this);
        if (hasActionBar()) {
            mActionBar = getSupportActionBar();
        }
//        initFragment();
    }


    @Override
    protected void onResume() {
        super.onResume();
//        refreshLogList();
    }

//    /**
//     * 刷新日志列表
//     */
//    protected void refreshLogList() {
//        mLogFragment.updateAutoEndButton();
//        mLogFragment.updateList();
//    }

//    /**
//     * 初始化日志Fragment
//     */
//    protected void initFragment() {
//        FragmentManager fragmentManager = getSupportFragmentManager();
//        mLogFragment = (ISO1444334) fragmentManager.findFragmentById(R.id.log_fragment);
//    }

//    /**
//     * 添加日志
//     *
//     * @param message
//     */
//    protected void addLog(IMessage message) {
//        LogManager.instance().add(message);
//        refreshLogList();
//    }


    @Override
    protected void onStart() {
        super.onStart();
        EventBus.getDefault().register(this);
    }

    @Override
    protected void onStop() {
        super.onStop();
        EventBus.getDefault().unregister(this);
    }

    @Override
    public boolean onSupportNavigateUp() {
        finish();
        return super.onSupportNavigateUp();
    }

    protected boolean hasActionBar() {
        return true;
    }

    protected void setActionBar(boolean showUp, String title) {
        mActionBar.setHomeButtonEnabled(showUp);
        mActionBar.setDisplayHomeAsUpEnabled(showUp);
        mActionBar.setTitle(title);
    }

    protected void setActionBar(boolean showUp, int stringResId) {
        mActionBar.setHomeButtonEnabled(showUp);
        mActionBar.setDisplayHomeAsUpEnabled(showUp);
        mActionBar.setTitle(stringResId);
    }

//    @Subscribe(threadMode = ThreadMode.MAIN)
//    public void onMessageEvent(IMessage message) {
//        // 收到时间，刷新界面
//        mLogFragment=HomeActivity.fragment
//        mLogFragment.add(message);
//    }


}
