/*
 * Decompiled with CFR 0.152.
 */
package com.android.hdhe.uhf.reader;

import com.android.hdhe.uhf.reader.NewSendCommendManager;
import com.android.hdhe.uhf.reader.SerialPort;
import com.android.hdhe.uhf.readerInterface.CommendManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class UhfReader
implements CommendManager {
    private static NewSendCommendManager manager;
    private static SerialPort serialPort;
    private static int port;
    private static int baudRate;
    private static InputStream in;
    private static OutputStream os;
    private static UhfReader reader;
    public static final int MEMBANK_RESEVER = 0;
    public static final int MEMBANK_EPC = 1;
    public static final int MEMBANK_TID = 2;
    public static final int MEMBANK_USER = 3;
    public static final int LOCK_TYPE_OPEN = 0;
    public static final int LOCK_TYPE_PERMA_OPEN = 1;
    public static final int LOCK_TYPE_LOCK = 2;
    public static final int LOCK_TYPE_PERMA_LOCK = 3;
    public static final int LOCK_MEM_KILL = 0;
    public static final int LOCK_MEM_ACCESS = 1;
    public static final int LOCK_MEM_EPC = 2;
    public static final int LOCK_MEM_TID = 3;
    public static final int LOCK_MEM_USER = 4;

    static {
        port = 13;
        baudRate = 115200;
    }

    private UhfReader() {
    }

    public static UhfReader getInstance() {
        if (serialPort == null) {
            try {
                serialPort = new SerialPort(port, baudRate, 0);
            }
            catch (Exception e) {
                return null;
            }
            serialPort.psampoweron();
            in = serialPort.getInputStream();
            os = serialPort.getOutputStream();
        }
        if (manager == null) {
            manager = new NewSendCommendManager(in, os);
        }
        if (reader == null) {
            reader = new UhfReader();
        }
        try {
            Thread.sleep(200L);
            manager.setWorkArea(2);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return reader;
    }

    public void powerOn() {
        serialPort.psampoweron();
    }

    public void powerOff() {
        serialPort.psampoweroff();
    }

    @Override
    public boolean setBaudrate() {
        return manager.setBaudrate();
    }

    @Override
    public byte[] getFirmware() {
        return manager.getFirmware();
    }

    @Override
    public boolean setOutputPower(int value) {
        return manager.setOutputPower(value);
    }

    @Override
    public List<byte[]> inventoryRealTime() {
        return manager.inventoryRealTime();
    }

    @Override
    public void selectEPC(byte[] epc) {
        manager.selectEPC(epc);
    }

    @Override
    public byte[] readFrom6C(int memBank, int startAddr, int length, byte[] accessPassword) {
        return manager.readFrom6C(memBank, startAddr, length, accessPassword);
    }

    @Override
    public boolean writeTo6C(byte[] password, int memBank, int startAddr, int dataLen, byte[] data) {
        return manager.writeTo6C(password, memBank, startAddr, dataLen, data);
    }

    @Override
    public void setSensitivity(int value) {
        manager.setSensitivity(value);
    }

    @Override
    public boolean lock6C(byte[] password, int memBank, int lockType) {
        return manager.lock6C(password, memBank, lockType);
    }

    @Override
    public void close() {
        if (manager != null) {
            manager.close();
            manager = null;
        }
        if (serialPort != null) {
            serialPort.psampoweroff();
            serialPort.close(port);
            serialPort = null;
        }
        if (reader != null) {
            reader = null;
        }
    }

    @Override
    public byte checkSum(byte[] data) {
        return 0;
    }

    @Override
    public int setFrequency(int startFrequency, int freqSpace, int freqQuality) {
        return manager.setFrequency(startFrequency, freqSpace, freqQuality);
    }

    public void setDistance(int distance) {
    }

    public void close(InputStream input, OutputStream output) {
        if (manager != null) {
            manager = null;
            try {
                input.close();
                output.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public int setWorkArea(int area) {
        return manager.setWorkArea(area);
    }

    public List<byte[]> inventoryMulti() {
        return manager.inventoryMulti();
    }

    public void stopInventoryMulti() {
        manager.stopInventoryMulti();
    }

    public int getFrequency() {
        return manager.getFrequency();
    }

    public int unSelect() {
        return manager.unSelectEPC();
    }

    public void setRecvParam(int mixer_g, int if_g, int trd) {
        manager.setRecvParam(mixer_g, if_g, trd);
    }

    public boolean kill6C(byte[] killPassword) {
        return manager.kill6C(killPassword);
    }
}

