﻿using Android.App;
using Android.Widget;
using Android.OS;
using Com.Android.Hdhe.Uhf.Reader;
using System;
using System.Collections.Generic;
using System.Collections;
using System.Text;

namespace UHFDemo1
{
    [Activity(Label = "UHFDemo1", MainLauncher = true)]
    public class MainActivity : Activity
    {
        private EditText editTextEpc;
        private Button buttonInventoryEpc;

        private UhfReader uhfReader;
        protected override void OnCreate(Bundle savedInstanceState)
        {
            base.OnCreate(savedInstanceState);

            // Set our view from the "main" layout resource
            SetContentView(Resource.Layout.Main);
            editTextEpc = (EditText)FindViewById(Resource.Id.edittext_epc);
            buttonInventoryEpc = (Button)FindViewById(Resource.Id.inventory_epc);
            buttonInventoryEpc.Click += Button_Click;
            uhfReader = UhfReader.Instance;
            if (uhfReader != null) {
                uhfReader.SetOutputPower(26);// 15  26
                uhfReader.SetWorkArea(3); //default 2:FCC,3:Eu
            }
        }
        protected override void OnDestroy()
        {
            if (uhfReader != null) uhfReader.Close();
            base.OnDestroy();
        }
        private void Button_Click(object sender, EventArgs e)
        {
            if (uhfReader != null) {
                //inventory epc
                IList<byte[]> Ilist = uhfReader.InventoryRealTime();
                if (Ilist != null && Ilist.Count > 0)
                {
                    editTextEpc.Text = ToHexString(Ilist[0]);
                }
                // read 
                //byte[] readdata = uhfreader.readfrom6c(1,2,6,new byte[4]);//epc 
                ////byte[] readdata = uhfreader.readfrom6c(2, 0, 6, new byte[4]);//tid
                //if (readdata != null) {
                //    edittextepc.text = tohexstring(readdata);//09 not tag
                //}
                // write 
                //byte[] writedata = { 0xaa,0xbb,0xcc,0xdd, 0xaa, 0xbb, 0xcc, 0xdd, 0xaa, 0xbb, 0xcc, 0xdd };
                //Boolean writeFlag = uhfReader.WriteTo6C(new byte[4], 1, 2, 6, writedata);
                //if (writeFlag) editTextEpc.Text = "write success"; else editTextEpc.Text = "write fail";
            }
        }
        
        public static string ToHexString(byte[] bytes) // 0xae00cf => "AE00CF "

        {
            string hexString = string.Empty;

            if (bytes != null)

            {

                StringBuilder strB = new StringBuilder();

                for (int i = 0; i < bytes.Length; i++)

                {

                    strB.Append(bytes[i].ToString("X2"));

                }

                hexString = strB.ToString();

            }
            return hexString;

        }
       
    }
}

