package com.example.uart;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

import com.example.uartdemo.SerialPort;
import com.example.uartdemo.Tools;

import android.os.Bundle;
import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import android.view.Menu;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.View.OnFocusChangeListener;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemSelectedListener;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.Toast;
import android.widget.CompoundButton.OnCheckedChangeListener;
import android.widget.EditText;
import android.widget.MultiAutoCompleteTextView;
import android.widget.Spinner;

public class MainActivity extends Activity implements OnClickListener {
	
	/** UI  **/
	private EditText editRecv ;
	private AutoCompleteTextView editSend ;
	private Spinner spinnerBuadrate ;
	private Spinner spinnerSerialport ;
	private Spinner spinnerPower ;
	private CheckBox checkRecv ;
	private CheckBox checkSend ;
	private Button buttonOpen ;
	private Button buttonSend ;
	private Button buttonClear ;
	
	private String[] buadrateStrs ;
	private String[] serialportStrs ;
	private String[] powerStrs ;
	
	private List<String> listBuadRate = new ArrayList<String>();
	private List<String> listSerialPort = new ArrayList<String>();
	private List<String> listPower = new ArrayList<String>();
	
	/** serialport **/
	private SerialPort mSerialPort ;
	private InputStream is ;
	private OutputStream os ;
	
	private int port ;
	private int buad ;
	private String powerStr;
	
	/** recv Thread **/
	private RecvThread recvThread ;
	
	private boolean isHexRecv = false  ;
	private boolean isHexSend = false ;
	private boolean isOpen = false ;
	
	private Context context ;
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);
		
		context = this;
		initView();
		listener();
	}
	
	
	private void initView(){
		editRecv = (EditText) findViewById(R.id.editTextInfo);
		editSend = (AutoCompleteTextView) findViewById(R.id.editTextSend);
		initHistory("history",editSend); 
		spinnerBuadrate = (Spinner) findViewById(R.id.spinnerBuadrate);
		spinnerPower = (Spinner) findViewById(R.id.spinnerPower);
		spinnerSerialport = (Spinner) findViewById(R.id.spinnerSerialport);
		checkRecv = (CheckBox) findViewById(R.id.checkBoxHexRecv);
		checkSend = (CheckBox) findViewById(R.id.checkBoxHexSend);
		buttonOpen = (Button) findViewById(R.id.buttonOpen);
		buttonSend = (Button) findViewById(R.id.buttonSend);
		buttonClear = (Button) findViewById(R.id.buttonClear);
		
		buadrateStrs = context.getResources().getStringArray(R.array.buadrateArray);
		serialportStrs = context.getResources().getStringArray(R.array.serialportArray);
		powerStrs = context.getResources().getStringArray(R.array.powerArray);
		
		for(String buad:buadrateStrs){
			listBuadRate.add(buad);
		}
		for(String serial:serialportStrs){
			listSerialPort.add(serial);
		}
		for(String power:powerStrs){
			listPower.add(power);
		}
		spinnerBuadrate.setAdapter(new ArrayAdapter<String>(context, 
				android.R.layout.simple_spinner_dropdown_item,
				listBuadRate));
		spinnerSerialport.setAdapter(new ArrayAdapter<String>(context, 
				android.R.layout.simple_spinner_dropdown_item,
				listSerialPort));
		spinnerPower.setAdapter(new ArrayAdapter<String>(context, 
				android.R.layout.simple_spinner_dropdown_item,
				listPower));
	}
	
	/**
	 * listen componet
	 */
	private void listener(){
		spinnerSerialport.setOnItemSelectedListener(new OnItemSelectedListener() {

			@Override
			public void onItemSelected(AdapterView<?> adapter, View view,
					int position, long id) {
				port = position;
				
			}

			@Override
			public void onNothingSelected(AdapterView<?> arg0) {
				
			}
		});
		spinnerBuadrate.setOnItemSelectedListener(new OnItemSelectedListener() {

			@Override
			public void onItemSelected(AdapterView<?> adapter, View view,
					int position, long id) {
				String buadrate = buadrateStrs[position];
				buad = Integer.valueOf(buadrate);
			}

			@Override
			public void onNothingSelected(AdapterView<?> arg0) {
				
			}
		});
		spinnerPower.setOnItemSelectedListener(new OnItemSelectedListener() {

			@Override
			public void onItemSelected(AdapterView<?> adapter, View view,
					int position, long id) {
				powerStr = powerStrs[position];
			}

			@Override
			public void onNothingSelected(AdapterView<?> arg0) {
				
			}
		});
		
		checkRecv.setOnCheckedChangeListener(new OnCheckedChangeListener() {
			
			@Override
			public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
				isHexRecv = isChecked;
				
			}
		});
		checkSend.setOnCheckedChangeListener(new OnCheckedChangeListener() {
			
			@Override
			public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
				isHexSend = isChecked;
				
			}
		});
		
		buttonOpen.setOnClickListener(this);
		buttonSend.setOnClickListener(this);
		buttonClear.setOnClickListener(this);
		
	}
	
	@Override
	protected void onDestroy() {
		this.close();
		super.onDestroy();
	}

	//open serialport
	private void open(){
		//open
		try {
			mSerialPort = new SerialPort(port, buad, 0);
		}catch (Exception e) {
			
			Toast.makeText(this, "SerialPort init fail!!", 0).show();
			return;
		}
		is = mSerialPort.getInputStream();
		os = mSerialPort.getOutputStream();
		if("3.3V".equals(powerStr)){
			mSerialPort.power3v3on();
		}else if("5V".equals(powerStr)){
			mSerialPort.power_5Von();
		}else if("scan power".equals(powerStr)){
			mSerialPort.scaner_poweron();
		}else if("psam power".equals(powerStr)){
			mSerialPort.psam_poweron();
		}else if("rfid power".equals(powerStr)){
			mSerialPort.rfid_poweron();
		}
		recvThread = new RecvThread();
		recvThread.start();
		isOpen = true;
		spinnerBuadrate.setClickable(false);
		spinnerPower.setClickable(false);
		spinnerSerialport.setClickable(false);
		buttonOpen.setText(context.getResources().getString(R.string.close));
		Toast.makeText(this, "SerialPort open success", 0).show();
		
	}
	//close serialport
	private void close(){
		if(recvThread != null){
			recvThread.interrupt();
		}
		if(mSerialPort != null){
			
			if("3.3V".equals(powerStr)){
				mSerialPort.power3v3off();
			}else if("5V".equals(powerStr)){
				mSerialPort.power_5Voff();
			}else if("scan power".equals(powerStr)){
				mSerialPort.scaner_poweroff();
			}else if("psam power".equals(powerStr)){
				mSerialPort.psam_poweroff();
			}else if("rfid power".equals(powerStr)){
				mSerialPort.rfid_poweroff();
			}
			try {
				is.close();
				os.close();
			} catch (IOException e) {
//				e.printStackTrace();
			}
			mSerialPort.close(port);
			isOpen = false;
			spinnerBuadrate.setClickable(true);
			spinnerPower.setClickable(true);
			spinnerSerialport.setClickable(true);
			buttonOpen.setText(context.getResources().getString(R.string.open));
		}
	}
	
	//send cmd
	private void send(){
		byte[] cmd = null;
		String commandStr = editSend.getText().toString();
		Log.i("send()", commandStr);
		if(commandStr == null){
			Toast.makeText(context, "cmd is null", 0).show();
		}
		if(isHexSend){
			cmd = Tools.HexString2Bytes(commandStr);
		}else{
			cmd = commandStr.getBytes();
		}
		try {
			os.write(cmd);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
	}

	@Override
	public void onClick(View v) {
		int id = v.getId();
		switch (id) {
		case R.id.buttonOpen:
			if(!isOpen){
				this.open();
			}else{
				this.close();
			}
			
			break;
		case R.id.buttonSend:
			if(isOpen){
				saveHistory("history", editSend);
				send();
			}else{
				Toast.makeText(context, "please open serialport", 0).show();
			}
			break;
		case R.id.buttonClear:
			editRecv.setText("");
			break;

		default:
			break;
		}
		
	}
	
	/**
	 * recv thread receive serialport data
	 * @author Administrator
	 *
	 */
	private class RecvThread extends Thread{
		@Override
		public void run() {
			super.run();
			try {
			while(!isInterrupted()){
				int size = 0;
				int avi = 0 ;
				byte[] buffer = new byte[512];
				if(is == null){
					return;
				}
				avi = is.available() ;
				if(avi > 0){
					Thread.sleep(200);
					size = is.read(buffer);
					if(size > 0){
						onDataReceived(buffer, size);
					}
				}
				
				Thread.sleep(10);
			}
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
	}
	/**
	 * add recv data on UI
	 * @param buffer
	 * @param size
	 */
	private void onDataReceived(final byte[] buffer, final int size){
		runOnUiThread(new Runnable() {
			
			@Override
			public void run() {
				if(isHexRecv){
					String recv = Tools.Bytes2HexString(buffer, size);
					editRecv.append("[Recv(HEX)]:" + recv + "\n");
				}else{
					String recv = new String(buffer, 0 , size);
					editRecv.append("[Recv]:" + recv + "\n");
				}
				
			}
		});
	}
	
	/**
	 * ��ʼ����ʷ��¼
	 * @param field
	 * @param auto
	 */
	private void initHistory(String field,AutoCompleteTextView auto){
		SharedPreferences sp = getSharedPreferences("commad", 0);  
        String longhistory = sp.getString("history", "nothing");  
        String[]  hisArrays = longhistory.split(",");  
        ArrayAdapter<String> adapter = new ArrayAdapter<String>(this,  
                android.R.layout.simple_dropdown_item_1line, hisArrays);
      //ֻ��������50���ļ�¼ 
        if(hisArrays.length > 50){  
            String[] newArrays = new String[50];  
            System.arraycopy(hisArrays, 0, newArrays, 0, 50);  
            adapter = new ArrayAdapter<String>(this,  
                    android.R.layout.simple_dropdown_item_1line, newArrays);  
        }  
        auto.setAdapter(adapter);  
        auto.setDropDownHeight(350);  
        auto.setThreshold(1);  
//        auto.setCompletionHint("����5����¼");  
        auto.setOnFocusChangeListener(new OnFocusChangeListener() {  
            @Override  
            public void onFocusChange(View v, boolean hasFocus) {  
                AutoCompleteTextView view = (AutoCompleteTextView) v;  
                if (hasFocus) {  
                        view.showDropDown();  
                }  
            }  
        }); 
		
	}
	/**
	 * ������ʷ��¼
	 * @param field
	 * @param auto
	 */
	private void saveHistory(String field,AutoCompleteTextView auto) {
		String text = auto.getText().toString();
		SharedPreferences sp = getSharedPreferences("commad", 0);  
		String longhistory = sp.getString(field, "nothing"); 
		 if (!longhistory.contains(text + ",")) {  
	            StringBuilder sb = new StringBuilder(longhistory);  
	            sb.insert(0, text + ",");  
	            sp.edit().putString("history", sb.toString()).commit();  
	        } 
	}
	

}
