﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using WLANNet;
using System.Net;
using System.Threading;



namespace WLANTestNet
{
    


    public partial class Form1 : Form
    {

        [DllImport("coredll.dll")]
        public static extern bool SystemParametersInfo(uint uiAction, uint uiParam, StringBuilder pvParam, bool fWinIni);

        private Password option;
        public static string m_password;
        public static int type;
        static System.Windows.Forms.Timer timer;
        static System.Windows.Forms.Timer OnOffTimer;
        static System.Windows.Forms.Timer SSIDtimer;
        public static bool ing = false;
        public static bool m_On = false;
        public static int ProgressValue = 0;
        public Thread th;
        public String APPVERSION = "1.0.2";
        public String APPRELEASE = "2013-11-26";
        const int SPI_GETPLATFORMTYPE = 257;

        
        WLANNet.WLANNet Wlan = new WLANNet.WLANNet();
        
        public Form1()
        {
            m_password = "";
            InitializeComponent();
          
        
            this.listView1.FullRowSelect = true;
            
          
            this.progressBar1.Maximum=100;
            this.progressBar1.Minimum=0;
            
            timer = new System.Windows.Forms.Timer();
            timer.Tick += new EventHandler(OnMyEvent);
            timer.Interval = 5000;
            timer.Enabled = true;
            timer.Enabled = false;
            SSIDtimer = new System.Windows.Forms.Timer();
            SSIDtimer.Tick += new EventHandler(OnRSSIEvent);
            SSIDtimer.Interval = 1000;
            SSIDtimer.Enabled = true;
            if (Wlan.GetPowerStatus())
            {
                OnOff.Text = "Power OFF";
                m_On = true;
                Search.Enabled = true;
                Connect.Enabled = true;

            }
            else
            {
                OnOff.Text = "Power ON";
                m_On = false;
                Search.Enabled = false;
                Connect.Enabled = false;
            }

            onoff_label.Text = "";
            remaintime_label1.Text = "";
            onoff_progressBar.Visible = false;
            onoff_panel.Visible = false;
            onoff_label.Visible = false;
            remaintime_label1.Visible = false;

            m_result.Text = "Select Import or Export Button.";

            StringBuilder tmp1 = new StringBuilder();
            StringBuilder tmp2 = new StringBuilder();

            Wlan.GetVersion(tmp1, tmp2);
            m_szAPP_version.Text = "APP:" + APPVERSION + " (" + APPRELEASE + ")";
            m_szDLL_version.Text = "DLL:" + tmp1 + " (" + tmp2 + ")";

            string tmp3, tmp4;
            Wlan.GetNetVersion(out tmp3, out tmp4);
            m_szNetDLL_version.Text = "Net DLL:" + tmp3 + " (" + tmp4 + ")";



            StringBuilder sb = new StringBuilder();

            SystemParametersInfo(SPI_GETPLATFORMTYPE, 255, sb, false);

            if (sb.ToString().Trim() == "PocketPC" || sb.ToString().Trim() == "SmartPhone")
            {
                MainMenu mainMenu = new MainMenu();

                this.Menu = mainMenu;
            }
           
        }

        private void OnRSSIEvent(object source, EventArgs e)
        {
            ViewRSSI();
        }

        private void OnMyEvent(object source, EventArgs e)
        {
            ViewState();
        }

        private void Search_Click(object sender, EventArgs e)
        {
            FindAPList();
        }

     
        private void Connect_Click(object sender, EventArgs e)
        {
            RealConnect();
        }

        private void ViewRSSI()
        {
            WLAN_STATUS st = new WLAN_STATUS();
            Wlan.GetCurrentAPInfo(ref st);
            string tmp = new string(st.CardState);

            if (tmp.CompareTo("NOT INSERTED") == 0 || tmp.CompareTo("NOT ASSOCIATED") == 0)
            {
                m_rssi.Text = "0";
                progressBar1.Value = 0;
            }
            else
            {
                m_rssi.Text = st.Rssi.ToString();
                m_rssi.Text += " dBm";

                if (100 + st.Rssi >= 100)
                {
                    progressBar1.Value = 100;
                }
                else
                {
                    progressBar1.Value = 100 + st.Rssi;
                }
            }
        }

        private void ViewState()
        {
            try
            {
                m_list_status.Items.Clear();
                WLAN_STATUS st = new WLAN_STATUS();
                Wlan.GetCurrentAPInfo(ref st);
                string tmp = new string(st.CardState);

                
                if (tmp.CompareTo("NOT INSERTED") == 0 || tmp.CompareTo("NOT ASSOCIATED") == 0)
                {
                    ListViewItem BsItem = new ListViewItem();
                    BsItem.Text = "Status";
                    BsItem.SubItems.Add(tmp);
                
                    m_list_status.Items.Add(BsItem);    
                }

                else if(st.Rssi==0)
                {
                    ListViewItem BsItem = new ListViewItem();
                    BsItem.Text = "Status";
                    BsItem.SubItems.Add(tmp);

                    m_list_status.Items.Add(BsItem);
                }
                else
                {
                    string[] APInfoItem ={ "Status", "SSID", "Client IP", "Client Mac", "AP IP", "AP Mac", "Beacon", "DTIM", "Channel", "Bit Rate", "TX Power" };
                    string[] APValue = new string[11];

                    APValue[0] = tmp;

                    tmp = new string(st.SSID);
                    APValue[1] = tmp;

                    APValue[2] = string.Format("{0:d3}.{1:d3}.{2:d3}.{3:d3}", st.Client_IP[0], st.Client_IP[1], st.Client_IP[2], st.Client_IP[3]);
                    APValue[3] = string.Format("{0:X2}:{1:X2}:{2:X2}:{3:X2}:{4:X2}:{5:X2}", st.Client_Mac[0], st.Client_Mac[1], st.Client_Mac[2], st.Client_Mac[3], st.Client_Mac[4], st.Client_Mac[5]);

                    APValue[4] = string.Format("{0:d3}.{1:d3}.{2:d3}.{3:d3}", st.AP_IP[0], st.AP_IP[1], st.AP_IP[2], st.AP_IP[3]);
                    APValue[5] = string.Format("{0:X2}:{1:X2}:{2:X2}:{3:X2}:{4:X2}:{5:X2}", st.AP_Mac[0], st.AP_Mac[1], st.AP_Mac[2], st.AP_Mac[3], st.AP_Mac[4], st.AP_Mac[5]);

                    APValue[6] = st.BeaconPeriod.ToString();

                    APValue[7] = st.DTIM.ToString();

                    APValue[8] = st.Channel.ToString();

                    APValue[9] = st.BitRate.ToString();
                    APValue[9] += " Mbps";

                                        
                    m_active.Text = APValue[1];

                    for (int i = 0; i < 10; i++)
                    {
                        ListViewItem BsItem = new ListViewItem();
                        BsItem.Text = APInfoItem[i];
                        BsItem.SubItems.Add(APValue[i]);
                        m_list_status.Items.Add(BsItem);
                    }

                    
                }
            }


            catch
            {

            }
            
        }

        private void WLANTAP_SelectedIndexChanged(object sender, EventArgs e)
        {
            switch(About.SelectedIndex)
            {
                case 0:
                    timer.Enabled = false;
                    break;
                case 1:
                    ViewState();
                    timer.Enabled = true;
                    break;
                case 2:
                    {
                        timer.Enabled = false;
                        WLAN_STATUS st = new WLAN_STATUS();
                        Wlan.GetCurrentAPInfo(ref st);
                        string tmp = new string(st.SSID);
                        m_active.Text = tmp;

                        profiles.Items.Clear();

                        WLAN_CONFIG_NAME[] NameList = new WLAN_CONFIG_NAME[20];

                        Cursor.Current = Cursors.WaitCursor;
                        Wlan.GetAllConfigName(ref NameList);
                        Cursor.Current = Cursors.Default;

                        for (int i = 0; i < NameList.Length; i++)
                            profiles.Items.Add(NameList[i].ConfigName);
                        
                    }
                    break;
                case 3:
                    timer.Enabled = false;
                    break;
            }
        }

        private void button1_Click(object sender, EventArgs e)
        {
            string tmp = profiles.SelectedItem.ToString();

            Wlan.ActivateConfig(tmp);
            m_active.Text = tmp;

        }

        private void button2_Click(object sender, EventArgs e)
        {
            string tmp = profiles.SelectedItem.ToString();

            if (tmp.CompareTo(m_active.Text) == 0)
                MessageBox.Show("Activate config can not removed!!");

            else
            {
                Wlan.DeleteConfig(tmp);

                WLAN_STATUS st = new WLAN_STATUS();
                Wlan.GetCurrentAPInfo(ref st);
                string tmpSSID = new string(st.SSID);
                m_active.Text = tmpSSID;

                profiles.Items.Clear();

                WLAN_CONFIG_NAME[] NameList = new WLAN_CONFIG_NAME[20];

                Cursor.Current = Cursors.WaitCursor;
                Wlan.GetAllConfigName(ref NameList);
                Cursor.Current = Cursors.Default;

                for (int i = 0; i < NameList.Length; i++)
                    profiles.Items.Add(NameList[i].ConfigName);
            }
        }

        private void ThreadFunc()
        {
            if (Wlan.GetPowerStatus())
                Wlan.PowerOff();
            else
                Wlan.PowerOn();
        
        }

        private void OnOff_Click(object sender, EventArgs e)
        {
            OnOff.Enabled = false;
            onoff_panel.Visible = true;
            
            onoff_label.Visible = true;
            remaintime_label1.Visible = true;
            onoff_progressBar.Visible = true;
            onoff_progressBar.Minimum = 0;


            OnOffTimer = new System.Windows.Forms.Timer();
            OnOffTimer.Tick += new EventHandler(OnPowerEvent);
            OnOffTimer.Interval = 100;
            OnOffTimer.Enabled = true;

            th = new Thread(new ThreadStart(this.ThreadFunc));
            
           // th.
            if (Wlan.GetPowerStatus())
            {
                th.Start();
                m_On = false;
                onoff_label.Text = "Turning Off!";
                onoff_progressBar.Maximum = 9000;
                listView1.Items.Clear();
                OnOff.Text = "Power ON";

                Search.Enabled = false;
                Connect.Enabled = false;
//                OnOff.Enabled = true; 

            }
            else
            {
                th.Start();
                m_On = true;
                onoff_label.Text = "Turning On!";
                onoff_progressBar.Maximum = 8000;
                OnOff.Text = "Power OFF";

                Search.Enabled = true;
                Connect.Enabled = true;
             
                //FindAPList();
            }           
            ViewState();
        }

        private void OnPowerEvent(object source, EventArgs e)
        {
            
                ProgressValue += 100;
                if(onoff_progressBar.Maximum<=ProgressValue)
                {
                    onoff_panel.Visible = false;
                    onoff_progressBar.Visible = false;
                    onoff_label.Visible = false;
                    remaintime_label1.Visible = false;
                    OnOffTimer.Dispose();
                    ProgressValue = 0;
                }
                onoff_progressBar.Value = ProgressValue;


                if (ProgressValue % 1000 == 0)
                {
                    remaintime_label1.Text = "" + (onoff_progressBar.Maximum - ProgressValue) / 1000 + " Second Remaning...";

                    if ((onoff_progressBar.Maximum - ProgressValue) / 1000 == 1) 
                    {
                        OnOff.Enabled = true;
                    }
                }
            
        }

       

    
        private void Form1_Closing(object sender, CancelEventArgs e)
        {
            this.Dispose();
        }

        private void FindAPList()
        {

                if (m_On)
                {
                    listView1.Items.Clear();
                    WLAN_SSID[] ssidlist = new WLAN_SSID[40];


                    Cursor.Current = Cursors.WaitCursor;

                    try
                    {
                        int nCheckCnt = 0;
                        ///2013.09.09 AP LIST 계속 찾지 않도록 수정.
                        do
                        {
                            Wlan.GetBssidList(ref ssidlist);
                            System.Threading.Thread.Sleep(500);
                            nCheckCnt++;
                        } while (ssidlist.Length == 0 && nCheckCnt < 3);
                    }
                    catch
                    {

                    }

                    Cursor.Current = Cursors.Default;



                    WLAN_SSID[] templist = new WLAN_SSID[40];

                    int tmpcnt = 0;
                    for (int i = 0; i < ssidlist.Length; i++)
                    {
                        if (ssidlist[i].Rssi >= 0)
                            continue;

                        templist[tmpcnt++] = ssidlist[i];
                    }

                    for (int i = 0; i < tmpcnt; i++)
                    {
                        if (templist[i].Rssi >= 0)
                        {

                            continue;
                        }
                        ListViewItem BsItem = new ListViewItem();

                        BsItem.Text = templist[i].SSIDName;

                        BsItem.SubItems.Add(string.Format("{0:d}", templist[i].Rssi));

                        if (templist[i].privacy == 0)
                            BsItem.SubItems.Add("False");
                        else
                            BsItem.SubItems.Add("True");
                        listView1.Items.Add(BsItem);
                    }

                } 
           
        }

        private void m_button_Import_Click(object sender, EventArgs e)
        {
            if (FileDialog2.ShowDialog() == DialogResult.OK)
                m_filepath.Text = FileDialog2.FileName;

            if (Wlan.ImportConfig(m_filepath.Text))
            {
                m_result.Text = "Import Success!!";




                timer.Enabled = false;
                WLAN_STATUS st = new WLAN_STATUS();
                Wlan.GetCurrentAPInfo(ref st);
                string tmp = new string(st.SSID);
                m_active.Text = tmp;

                profiles.Items.Clear();

                WLAN_CONFIG_NAME[] NameList = new WLAN_CONFIG_NAME[20];

                Cursor.Current = Cursors.WaitCursor;
                Wlan.GetAllConfigName(ref NameList);
                Cursor.Current = Cursors.Default;

                for (int i = 0; i < NameList.Length; i++)
                    profiles.Items.Add(NameList[i].ConfigName);




            }
            else
                m_result.Text = "Import Fail!!!";
        }

        private void m_button_Export_Click(object sender, EventArgs e) 
        {
            if (FileDialog.ShowDialog() == DialogResult.OK)
                m_filepath.Text = FileDialog.FileName;

            if (Wlan.ExportConfig(m_filepath.Text))
                m_result.Text="Export Success!!";
            else
             m_result.Text = "Export Fail!!!";
         }

        private void RealConnect()
        {
            
            try
            {
                string a = listView1.FocusedItem.SubItems[0].Text;

                string b = listView1.FocusedItem.SubItems[2].Text;
                string tt = "False";
                if (b.CompareTo(tt) == 0)
                {
                    Wlan.ConnectAP(a);
                    About.SelectedIndex = 1;
                }
                else  // 암호
                {
                    option = new Password(listView1.FocusedItem.SubItems[0].Text, listView1.FocusedItem.SubItems[1].Text);
                    DialogResult answer = option.ShowDialog();
                    if (DialogResult.OK == answer)
                    {
                        if (m_password.CompareTo("") != 0)
                        {

                            if (Form1.type == 1)
                            {
                                if (Form1.m_password.Length > 10)
                                {
                                    Wlan.ConnectAPEX(a, m_password, type, 2);
                                }
                                else
                                {
                                    Wlan.ConnectAPEX(a, m_password, type, 1);
                                }
                            }
                            else
                            {

                                Wlan.ConnectAPEX(a, m_password, type, 2);

                            }

                            About.SelectedIndex = 1;

                        }
                    }
                }
            }
            catch
            {

            }
            
        }
       
        private void ListClick(object sender, EventArgs e)
        {
            RealConnect();
        }



    }
}