// APList.cpp : implementation file
//

#include "stdafx.h"
#include "WLANTest.h"
#include "APList.h"
#include "ProgressStatus.h"

#include <windows.h>
	//#include <wlanapi.h>
#include <objbase.h>
#include <wtypes.h>

#include <stdio.h>
#include <stdlib.h>


#pragma comment(lib, "wlanapi.lib")
#pragma comment(lib, "ole32.lib")

// CAPList dialogWLAN

IMPLEMENT_DYNAMIC(CAPList, CPropertyPage)

CAPList::CAPList()
	: CPropertyPage(CAPList::IDD)
{

}

CAPList::~CAPList()
{
}

void CAPList::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST_AP, m_APList);
	DDX_Control(pDX, IDC_BTN_POWER, m_ctrPower);
}


BEGIN_MESSAGE_MAP(CAPList, CPropertyPage)
	ON_BN_CLICKED(IDC_BTN_POWER, &CAPList::OnBnClickedBtnPower)
	ON_BN_CLICKED(IDC_BTN_SEARCH, &CAPList::OnBnClickedBtnSearch)
	ON_BN_CLICKED(IDC_BTN_CONNECT, &CAPList::OnBnClickedBtnConnect)
	ON_NOTIFY(LVN_ITEMCHANGED, IDC_LIST_AP, &CAPList::OnLvnItemchangedListAp)
	ON_NOTIFY(LVN_COLUMNCLICK, IDC_LIST_AP, &CAPList::OnLvnColumnclickListAp)
	ON_NOTIFY(NM_CLICK, IDC_LIST_AP, &CAPList::OnNMClickListAp)
END_MESSAGE_MAP()


// CAPList message handlers

BOOL CAPList::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	// TODO:  Add extra initialization here


//	m_APList.InsertColumn(0, _T("SSID"), LVCFMT_LEFT, 110);
//	m_APList.InsertColumn(1, _T("RSSI"), LVCFMT_LEFT, 37);
//	m_APList.InsertColumn(2, _T("Security"), LVCFMT_LEFT, 55);
	m_APList.InsertColumn(0, _T("SSID"), LVCFMT_LEFT, 510);
	m_APList.InsertColumn(1, _T("RSSI"), LVCFMT_LEFT, 137);
	m_APList.InsertColumn(2, _T("Security"), LVCFMT_LEFT, 155);
	m_APList.SetExtendedStyle(LVS_EX_FULLROWSELECT);

	HWND hConnect, hSearch;
	hConnect=::GetDlgItem(this->m_hWnd, IDC_BTN_CONNECT);
	hSearch=::GetDlgItem(this->m_hWnd, IDC_BTN_SEARCH);


		if(WLAN_GetPowerStatus())
		{
			SetDlgItemText(IDC_BTN_POWER, _T("Power OFF"));
			//OnBnClickedBtnSearch();
			::EnableWindow(hConnect, TRUE);
			::EnableWindow(hSearch, TRUE);
			
		}
		else
		{

			SetDlgItemText(IDC_BTN_POWER, _T("Power ON"));
			::EnableWindow(hConnect, FALSE);
			::EnableWindow(hSearch, FALSE);
		}

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

UINT ThreadFunc(LPVOID pParam)
{
	int* type=(int*)pParam;
	if(*type==0) 
		WLAN_PowerOn();	
	else
		WLAN_PowerOff();
	
	return 0;
}

void CAPList::OnBnClickedBtnPower()
{
	// TODO: Add your control notification handler code here
	CProgressStatus ProgressDlg;
	m_ctrPower.EnableWindow(false);


	int OnOffStatus=0;
	HWND hConnect, hSearch;
	hConnect=::GetDlgItem(this->m_hWnd, IDC_BTN_CONNECT);
	hSearch=::GetDlgItem(this->m_hWnd, IDC_BTN_SEARCH);

	if(WLAN_GetPowerStatus())
	{

		OnOffStatus=1;
		CWinThread* pThread=::AfxBeginThread(ThreadFunc, &OnOffStatus);
		CProgressStatus ProgressDlg(NULL, FALSE);
		ProgressDlg.DoModal();
		
		::WaitForSingleObject(pThread->m_hThread, INFINITE);
				
		m_APList.DeleteAllItems();
		SetDlgItemText(IDC_BTN_POWER, _T("Power ON"));
		
		
		::EnableWindow(hConnect, FALSE);
		::EnableWindow(hSearch, FALSE);
	}
	else
	{

		OnOffStatus=0;
		CWinThread* pThread=::AfxBeginThread(ThreadFunc, &OnOffStatus);
		CProgressStatus ProgressDlg(NULL, TRUE);
		ProgressDlg.DoModal();

		::WaitForSingleObject(pThread->m_hThread, INFINITE);
		
		SetDlgItemText(IDC_BTN_POWER, _T("Power OFF"));
		//OnBnClickedBtnSearch();

		::EnableWindow(hConnect, TRUE);
		::EnableWindow(hSearch, TRUE);
	}
	
	m_ctrPower.EnableWindow(true);
}


void CAPList::OnBnClickedBtnSearch()
{
	// TODO: Add your control notification handler code here
	BeginWaitCursor();
	m_APList.DeleteAllItems();

	WLAN_SSID_LIST* SSIDList=new WLAN_SSID_LIST();
	SSIDList->m_SSID=new WLAN_SSID[100];

//	TCHAR PowerStatusBuf[10]={0,};
	TCHAR PowerStatusBuf[20]={0,};
	GetDlgItemText(IDC_BTN_POWER, PowerStatusBuf, 11);

	if(_tcscmp(PowerStatusBuf, _T("Power OFF"))==0)
	{
		int nCheckCnt = 0;


		do 
		{
			WLAN_GetBssidList(SSIDList);
			nCheckCnt++;
		} while(SSIDList->m_NumberOfItems==0 && nCheckCnt < 3);


		int tt=0;
		CString buf, wepbuf;

		for(int i=0;i<SSIDList->m_NumberOfItems;i++)
		{
			int result=_tcscmp(SSIDList->m_SSID[i].SSID, _T("\0"));
			if(result!=0)
			{
				if(_tcscmp(SSIDList->m_SSID[i].SSID, _T(""))==0)
					continue;
				m_APList.InsertItem(tt, SSIDList->m_SSID[i].SSID, 0);
				buf.Format(_T("%d"), SSIDList->m_SSID[i].Rssi);

				m_APList.SetItemText(tt, 1, buf);

				if(SSIDList->m_SSID[i].Privacy==0)
          					wepbuf=_T("false");
				else
					wepbuf=_T("true");

				m_APList.SetItemText(tt++, 2, wepbuf);

			}
		}

		delete SSIDList;
		UpdateData(FALSE);

	}
	
	EndWaitCursor ();
}

void CAPList::OnBnClickedBtnConnect()
{
	// TODO: Add your control notification handler code here
	WLAN_CONFIG_NAME_LIST* NameList=new WLAN_CONFIG_NAME_LIST();
	WLAN_GetAllConfigName(NameList);

	if(NameList->m_NumberOfItems>20)
		AfxMessageBox(_T("Max Config is 20"));

	else
	{

		int result=0;
		POSITION pos=m_APList.GetFirstSelectedItemPosition();

		CString tmp=m_APList.GetItemText((int)pos-1, 0);
		CString tmp2=m_APList.GetItemText((int)pos-1, 2);
		CString tmp3=m_APList.GetItemText((int)pos-1, 1);

		if(tmp2.Compare(_T(""))!=0)
		{
			if(tmp2.Compare(_T("true"))==0)
			{
				optionDlg.InsertData(tmp, tmp3);
				if(optionDlg.DoModal()==IDOK)
				{
					if(optionDlg.m_combo_encrytion.GetCurSel() == 0)
					{
						if(optionDlg.m_password.GetLength()>10)
						{
							result=WLAN_ConnectAPEX(tmp.GetBuffer(), optionDlg.m_password.GetBuffer(), optionDlg.m_encryptionType+1,2);
						}
						else
						{
							result=WLAN_ConnectAPEX(tmp.GetBuffer(), optionDlg.m_password.GetBuffer(), optionDlg.m_encryptionType+1,1);
						}
					}
					else
					{

						result=WLAN_ConnectAPEX(tmp.GetBuffer(), optionDlg.m_password.GetBuffer(), optionDlg.m_encryptionType+1,2);
					}					
						optionDlg.m_password = "";
						optionDlg.m_repeat = "";
				}
				else
					result=-120;
				delete optionDlg;
			}
			else
			{
				result=WLAN_ConnectAPEX(tmp.GetBuffer(), _T('\0'), 0 ,2);
			}

			if(result==2)
				AfxMessageBox(_T("Select AP To Access!!"));	
			else if(result!=-120)
			{
				CPropertySheet* pSheet=(CPropertySheet*)GetParent();
				pSheet->SetActivePage(1);
			}
		}
		
	}
	
}

void CAPList::OnLvnItemchangedListAp(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMLISTVIEW pNMLV = reinterpret_cast<LPNMLISTVIEW>(pNMHDR);
	// TODO: Add your control notification handler code here
	//POSITION pos=m_APList.GetFirstSelectedItemPosition();
	
	*pResult = 0;
}


void CAPList::OnLvnColumnclickListAp(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMLISTVIEW pNMLV = reinterpret_cast<LPNMLISTVIEW>(pNMHDR);
	// TODO: Add your control notification handler code here
	//OnBnClickedBtnConnect();
	*pResult = 0;
}

void CAPList::OnNMClickListAp(NMHDR *pNMHDR, LRESULT *pResult)
{
	// TODO: Add your control notification handler code here
	OnBnClickedBtnConnect();
	*pResult = 0;
}
