// State.cpp : implementation file
//

#include "stdafx.h"
#include "WLANTest.h"
#include "State.h"


// CState dialog

IMPLEMENT_DYNAMIC(CState, CPropertyPage)

CState::CState()
	: CPropertyPage(CState::IDD)
	, m_rssi(_T(""))
{

}

CState::~CState()
{
}

void CState::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST_STATUS, m_stateList);
	DDX_Text(pDX, IDC_STATIC_RSSI, m_rssi);
	DDX_Control(pDX, IDC_PROGRESS1, m_progress_rssi);
}


BEGIN_MESSAGE_MAP(CState, CPropertyPage)
	ON_WM_TIMER()
	ON_NOTIFY(LVN_ITEMCHANGED, IDC_LIST_STATUS, &CState::OnLvnItemchangedListStatus)
END_MESSAGE_MAP()


// CState message handlers

BOOL CState::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	// TODO:  Add extra initialization here
	m_stateList.InsertColumn(0, _T("ITEM"), LVCFMT_LEFT, 60);
	m_stateList.InsertColumn(1, _T("VALUE"), LVCFMT_LEFT, 153);
	m_stateList.SetExtendedStyle(LVS_EX_FULLROWSELECT);

	m_progress_rssi.SetRange(0, 100);
	::SetTimer(this->m_hWnd, 1001, 1000, NULL);

	UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

BOOL CState::OnSetActive()
{
	// TODO: Add your specialized code here and/or call the base class
	ViewStat();
	return CPropertyPage::OnSetActive();
}

void CState::OnTimer(UINT_PTR nIDEvent)
{
	// TODO: Add your message handler code here and/or call default
	if (nIDEvent==1001)
		ViewStat();

	CPropertyPage::OnTimer(nIDEvent);
}


void CState::ViewStat()
{
	m_stateList.DeleteAllItems();
	CString APInfoItem[]={_T("Status"), _T("SSID"), _T("Client IP"), _T("Client Mac"), _T("AP IP"), _T("AP Mac"), _T("Beacon"), _T("DTIM"), _T("Channel"), _T("Bit Rate"), _T("TX Power")};
	CString APInfoValue[11]={_T(""),};
	

	if(WLAN_GetPowerStatus())
	{

		WLAN_STATUS st;
		memset(&st, 0, sizeof(st));
		WLAN_GetCurrentAPInfo(&st);

		APInfoValue[0]=st.CardState;
		APInfoValue[1]=st.SSID;
		
		ULONG     len = 0;
		PBYTE mac;
		CString one, str = _T("");


		mac = (PBYTE) st.AP_MAC;
		len = 6;
		for(ULONG i=0; i < len; i++){
			one.Format(_T("%02X"), mac[i]);
			str += one;
			if( i < len-1 ) str += _T(":");
		}

		APInfoValue[5]=str;

		mac=0;
		one=_T("");
		str=_T("");

		mac = (PBYTE) st.client_MAC;
		for(ULONG i=0; i < len; i++){
			one.Format(_T("%02X"), mac[i]);
			str += one;
			if( i < len-1 ) str += _T(":");
		}

		APInfoValue[3]=str;

		mac=0;
		one=_T("");
		str=_T("");

		mac = (PBYTE) st.AP_IP;
		len = 4;
		for(ULONG i=0; i < len; i++){
			one.Format(_T("%d"), mac[i]);
			str += one;
			if( i < len-1 ) str += _T(".");
		}

		APInfoValue[4]=str;

		mac=0;
		one=_T("");
		str=_T("");

		mac = (PBYTE) st.client_IP;
		for(ULONG i=0; i < len; i++){
			one.Format(_T("%d"), mac[i]);
			str += one;
			if( i < len-1 ) str += _T(".");
		}

		APInfoValue[2]=str;

		TCHAR buf[10]={0,};
		wsprintf(buf, _T("%d"), st.beaconPeriod);
		APInfoValue[6]=buf;
		ZeroMemory(buf, _tcslen(buf));

		wsprintf(buf, _T("%d"), st.DTIM);
		APInfoValue[7]=buf;
		ZeroMemory(buf, _tcslen(buf));
		
		wsprintf(buf, _T("%d"), st.channel);
		APInfoValue[8]=buf;
		ZeroMemory(buf, _tcslen(buf));
		
		if(st.bitRate==5.5)
			wsprintf(buf, _T("5.5 Mbps"));
		else
			wsprintf(buf, _T("%d Mbps"), (int)st.bitRate);
		APInfoValue[9]=buf;
		ZeroMemory(buf, _tcslen(buf));
		
		wsprintf(buf, _T("%d dBm"), st.rssi);
		m_rssi=buf;

		if(_tcscmp(st.CardState, _T("NOT ASSOCIATED"))==0)
		{
			m_progress_rssi.SetPos(0);
			m_rssi=_T("0");
		}
		else
		{
			int rssiValue=100+st.rssi;
			m_progress_rssi.SetPos(rssiValue);
		}
	}
	else
	{

		WLAN_STATUS st;
		memset(&st, 0, sizeof(st));
		WLAN_GetCurrentAPInfo(&st);

		APInfoValue[0]=st.CardState;

		m_rssi=_T("0");
		m_progress_rssi.SetPos(0);
	}

	for(int i=0;i<10;i++)
	{
		m_stateList.InsertItem(i, APInfoItem[i], 0);
		m_stateList.SetItemText(i, 1, APInfoValue[i]);
	}

	UpdateData(FALSE);
	Invalidate(TRUE);
}

void CState::OnLvnItemchangedListStatus(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMLISTVIEW pNMLV = reinterpret_cast<LPNMLISTVIEW>(pNMHDR);
	// TODO: Add your control notification handler code here
	*pResult = 0;
}
