#include "stdafx.h"
#include "Size.h"

Size::Size(HWND m_hwnd, BOOL Main_Resizing)
{
	OSVERSIONINFO osinfo;
	osinfo.dwOSVersionInfoSize=sizeof(osinfo);
	GetVersionEx(&osinfo);

	if(osinfo.dwMajorVersion==5)
	{
		if(osinfo.dwMinorVersion==0)
			OSType=1;
		else
			OSType=2;
	}
	
	hWnd=m_hwnd;	

	if(Main_Resizing==0)
		Dialog_Resize();
}

void Size::Dialog_Resize()
{
	if(OSType==1)
	{
		RECT rt;
		GetWindowRect(hWnd, &rt);

		RECT shellrt;
		HWND hShell=FindWindow(_T("HHTaskBar"), 0);
		GetWindowRect(hShell, &shellrt);
		int shell_height=shellrt.bottom-shellrt.top;

		int gx=rt.right-rt.left;
		int gy=rt.bottom-rt.top;

		int fx = GetSystemMetrics(SM_CXSCREEN);
		int fy = GetSystemMetrics(SM_CYSCREEN);

		fy-=shell_height;
		x_rate=(double)fx/gx;
		y_rate=(double)fy/gy;

		SetWindowPos(hWnd, 0, 0, -1, fx, fy, SWP_NOOWNERZORDER);
	}

	else 
	{
		RECT rt;
		GetWindowRect(hWnd, &rt);

		RECT shellrt;
		HWND hShell=FindWindow(_T("HHTaskBar"), 0);
		GetWindowRect(hShell, &shellrt);
		int shell_height=shellrt.bottom-shellrt.top;

		int gx=rt.right-rt.left;
		int gy=rt.bottom-rt.top;

		int fx = GetSystemMetrics(SM_CXSCREEN);
		int fy = GetSystemMetrics(SM_CYSCREEN);

		fy-=shell_height;
		x_rate=(double)fx/gx;
		y_rate=(double)fy/gy;

		SetWindowPos(hWnd, 0, 0, shellrt.bottom, fx, fy, SWP_NOOWNERZORDER);
	}
}

void Size::Control_Resize(int ResourceID)
{
	RECT rt;
	HWND hDlgItem=GetDlgItem(hWnd, ResourceID);

	TCHAR ClassName[512]={0,};
	GetClassName(hDlgItem, ClassName, 512);

	GetWindowRect(hDlgItem, &rt);

	POINT pt[2]={0,};

	pt[0].x=rt.left;
	pt[0].y=rt.top;

	pt[1].x=rt.right;
	pt[1].y=rt.bottom;

	ScreenToClient(hWnd, &pt[0]);
	ScreenToClient(hWnd, &pt[1]);

	rt.left=pt[0].x*x_rate;
	rt.right=pt[1].x*x_rate;
	rt.top=pt[0].y*y_rate;

	if(_tcscmp(ClassName, _T("combobox"))==0)
		rt.bottom=200;

	else
		rt.bottom=pt[1].y*y_rate;

	if(OSType==1)
		MoveWindow(hDlgItem, rt.left, rt.top, rt.right-rt.left, rt.bottom-rt.top, TRUE);
	else
		MoveWindow(hDlgItem, rt.left+8, rt.top, rt.right-rt.left+12, rt.bottom-rt.top, TRUE);	
}

void Size::Control_Resize_List(int* ResourceID_List, int count)
{
	if(count!=0)
		for(int i=0;i<count;i++)
			if(ResourceID_List[i]!=NULL)
				Control_Resize(ResourceID_List[i]);

}
