// ProgressStatus.cpp : implementation file
//

#include "stdafx.h"
#include "WLANTest.h"
#include "ProgressStatus.h"


// CProgressStatus dialog

IMPLEMENT_DYNAMIC(CProgressStatus, CDialog)

CProgressStatus::CProgressStatus(CWnd* pParent /*=NULL*/, BOOL On)
	: CDialog(CProgressStatus::IDD, pParent)
	, m_OnOff(_T(""))
	, m_time(_T(""))
	, m_On(On)
{

}

CProgressStatus::~CProgressStatus()
{
}

void CProgressStatus::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_PROGRESS1, m_status);
	DDX_Text(pDX, IDC_STATIC_ONOFF, m_OnOff);
	DDX_Text(pDX, IDC_STATIC_TIME, m_time);
}


BEGIN_MESSAGE_MAP(CProgressStatus, CDialog)
	ON_WM_TIMER()
END_MESSAGE_MAP()


// CProgressStatus message handlers
BOOL CProgressStatus::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  Add extra initialization here
	OnTime=0;
	OffTime=0;

	if(m_On)
		m_status.SetRange(0, 8000);
	else
		m_status.SetRange(0, 9000);

	m_status.SetPos(0);

	::SetTimer(this->m_hWnd, 1001, 100, NULL);
	::SetTimer(this->m_hWnd, 1002, 1000, NULL);

	if(m_On)
		m_OnOff=_T("Turning On...");
	else
		m_OnOff=_T("Turning Off...");
	
	

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CProgressStatus::OnTimer(UINT_PTR nIDEvent)
{
	// TODO: Add your message handler code here and/or call default
	TCHAR TimeBuf[100]={0,};
	if (nIDEvent==1001)
	{
		if(m_On)
		{
			if((8000-OnTime)%1000==0)
			{
				wsprintf(TimeBuf, _T("%d Second Remaining."), (8000-OnTime)/1000);
				m_time=TimeBuf;

				int tmp=(8000-OnTime)/1000;
			}
			if(OnTime==8000)
			{
				OnTime=0;
				OnOK();

			}
			m_status.SetPos(OnTime);
			OnTime+=100;
		}
		else
		{
			if((9000-OffTime)%1000==0)
			{
				wsprintf(TimeBuf, _T("%d Second Remaining."), (9000-OffTime)/1000);
				m_time=TimeBuf;
			}
			if(OffTime==9000)
			{
				OffTime=0;
				OnOK();

			}
			m_status.SetPos(OffTime);
			OffTime+=100;
		}
	}

	UpdateData(FALSE);
	
	CDialog::OnTimer(nIDEvent);
}
