// ProfileConfig.cpp : implementation file
//

#include "stdafx.h"
#include "WLANTest.h"
#include "ProfileConfig.h"


// CProfileConfig dialog

IMPLEMENT_DYNAMIC(CProfileConfig, CPropertyPage)

CProfileConfig::CProfileConfig()
	: CPropertyPage(CProfileConfig::IDD)
	, m_active(_T(""))
	, m_filepath(_T(""))
	, m_result(_T(""))
{

}

CProfileConfig::~CProfileConfig()
{
}

void CProfileConfig::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_STATIC_SSID, m_active);
	DDX_Control(pDX, IDC_COMBO_PROFILE, m_profile);
	DDX_Text(pDX, IDC_EDIT_FILEPATH, m_filepath);
	DDX_Text(pDX, IDC_STATIC_EXPORTSTATUS, m_result);
}


BEGIN_MESSAGE_MAP(CProfileConfig, CPropertyPage)
	ON_BN_CLICKED(IDC_BTN_CONNECT, &CProfileConfig::OnBnClickedBtnConnect)
	ON_BN_CLICKED(IDC_BTN_DELETE, &CProfileConfig::OnBnClickedBtnDelete)
	ON_BN_CLICKED(IDC_BTN_IMPORT, &CProfileConfig::OnBnClickedBtnImport)
	ON_BN_CLICKED(IDC_BTN_EXPORT, &CProfileConfig::OnBnClickedBtnExport)
END_MESSAGE_MAP()


// CProfileConfig message handlers

BOOL CProfileConfig::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	// TODO:  Add extra initialization here
	WLAN_STATUS st;
	memset(&st, 0, sizeof(st));
	WLAN_GetCurrentAPInfo(&st);

	m_active=st.SSID;

	m_result=_T("Select Import Button or Export Button.");
	UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CProfileConfig::OnBnClickedBtnConnect()
{
	// TODO: Add your control notification handler code here
	int tmp=m_profile.GetCurSel();
	TCHAR buf[128]={0,};
	m_profile.GetLBText(tmp, buf);

	WLAN_ActivateConfig(buf);
	m_active=buf;


	UpdateData(FALSE);
}

void CProfileConfig::OnBnClickedBtnDelete()
{
	// TODO: Add your control notification handler code here
	int tmp=m_profile.GetCurSel();
	TCHAR buf[128]={0,};

	m_profile.GetLBText(tmp, buf);

	int rrr=WLAN_DeleteConfig(buf);

	if(!rrr)
		AfxMessageBox(_T("Activate config can not removed!!"));
	else
		m_profile.DeleteString(tmp);
}

BOOL CProfileConfig::OnSetActive()
{
	// TODO: Add your specialized code here and/or call the base class
	Refrash();
	return CPropertyPage::OnSetActive();
}

void CProfileConfig::Refrash()
{
	m_profile.ResetContent();

	WLAN_CONFIG_NAME_LIST* NameList=new WLAN_CONFIG_NAME_LIST();
	int rrr=WLAN_GetAllConfigName(NameList);

	if(NameList->m_NumberOfItems==0)
	{
		m_profile.InsertString(0, _T("No Config"));
	}

	else
	{
		for(int i=0;i<NameList->m_NumberOfItems;i++)
			m_profile.InsertString(i, NameList->m_ConfigName[i].ConfigName);
	}
	

	WLAN_STATUS st;
	memset(&st, 0, sizeof(st));
	WLAN_GetCurrentAPInfo(&st);

	if(_tcscmp(st.SSID, _T(""))==0)
		m_active=_T("No Activate Config.");
	else
		m_active=st.SSID;

	m_profile.SetCurSel(0);
	UpdateData(FALSE);
}
void CProfileConfig::OnBnClickedBtnImport()
{
	// TODO: Add your control notification handler code here
	TCHAR szFilter[]=_T("SDC files(*.sdc)|*.sdc|All files(*.*)|*.*||");
	CFileDialog LoadDlg(TRUE, _T("sdc"), _T("SummitSettings.sdc"), OFN_HIDEREADONLY, szFilter);

	if (IDOK==LoadDlg.DoModal())
		m_filepath=LoadDlg.GetPathName();

	if(WLAN_ImportConfig(m_filepath.GetBuffer()))
	{
		m_result=_T("Import Success!!");
		Refrash();
	}
	else
	{
		m_result=_T("Import Fail!!");
	}
	UpdateData(FALSE);
}

void CProfileConfig::OnBnClickedBtnExport()
{
	// TODO: Add your control notification handler code here
	TCHAR szFilter[]=_T("SDC files(*.sdc)|*.sdc|All files(*.*)|*.*||");
	CFileDialog SaveDlg(FALSE, _T("sdc"), _T("SummitSettings.sdc"), OFN_HIDEREADONLY, szFilter);

	if (IDOK==SaveDlg.DoModal())
		m_filepath=SaveDlg.GetPathName();
	
	if(WLAN_ExportConfig(m_filepath.GetBuffer()))
		m_result=_T("Export Success!!");
	else
		m_result=_T("Export Fail!!");

	UpdateData(FALSE);
}
