// About.cpp : implementation file
//

#include "stdafx.h"
#include "WLANTest.h"
#include "About.h"

// CAbout dialog

IMPLEMENT_DYNAMIC(CAbout, CPropertyPage)

CAbout::CAbout()
	: CPropertyPage(CAbout::IDD)
	, m_strDLLVersion(_T(""))
	, m_strAPPVersion(_T(""))
{

}

CAbout::~CAbout()
{
}

void CAbout::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_APPVERSION, m_strDLLVersion);
	DDX_Text(pDX, IDC_DLLVERSION, m_strAPPVersion);
}


BEGIN_MESSAGE_MAP(CAbout, CPropertyPage)
END_MESSAGE_MAP()


BOOL CAbout::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	// Version
	TCHAR tzDllVersion[MAX_PATH] = {0x00};
	TCHAR tzDllRelease[MAX_PATH] = {0x00};

	TCHAR tzDllVer[MAX_PATH] = {0x00};
	TCHAR tzAppVersion[MAX_PATH] = {0x00};

	memset(tzDllVersion, 0x00, sizeof(TCHAR) * MAX_PATH);
	memset(tzDllRelease, 0x00, sizeof(TCHAR) * MAX_PATH);

	memset(tzDllVer, 0x00, sizeof(TCHAR) * MAX_PATH);
	memset(tzAppVersion, 0x00, sizeof(TCHAR) * MAX_PATH);

	WLAN_GetVersion(tzDllVersion, tzDllRelease);

	wsprintf(tzAppVersion, L"APP: %s (%s)", APP_VERSION, APP_RELEASE);
	wsprintf(tzDllVer, L"DLL: %s (%s)", tzDllVersion, tzDllRelease);

	::SetWindowText(::GetDlgItem(m_hWnd, IDC_APPVERSION), tzAppVersion);
	::SetWindowText(::GetDlgItem(m_hWnd, IDC_DLLVERSION), tzDllVer);

	
	UpdateData(TRUE);

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}
