#ifdef WLAN_EXPORTS
#define WLAN_API __declspec(dllexport)
#else
#define WLAN_API __declspec(dllimport)
#endif
#include <ntddndis.h>
#define  MAX_AP 30

typedef enum
{
	SUCCESS=0,
	FAIL,
	INVALID_NAME,
	INVALID_CONFIG,
	INVALID_DELETE,
	POWERCYCLE_REQUIRED,
	INVALID_PARAMETER,
	INVALID_EAP_TYPE,
	INVALID_WEP_TYPE,
	INVALID_FILE
}WLAN_ERROR_RESULT;

typedef struct _WLAN_STATUS
{
	DWORD	channel;
	int		rssi;
	double	bitRate;
	int     txPower;
	DWORD   DTIM;
	DWORD   beaconPeriod;
	DWORD   beaconsReceived;  
	TCHAR	SSID[32];
	TCHAR   CardState[36];
	byte    client_MAC[6];
	byte    client_IP[4];
	byte    AP_MAC[6];
	byte    AP_IP[4];
}WLAN_STATUS, *P_WLAN_STATUS;

typedef struct _WLAN_SSID
{
	TCHAR SSID[32];
	BOOL Privacy;
	int Rssi;
} WLAN_SSID;

typedef struct _WLAN_SSID_LIST
{
	int m_NumberOfItems; 
	WLAN_SSID* m_SSID;
} WLAN_SSID_LIST;

typedef struct _WLAN_CONFIG_NAME
{
	TCHAR ConfigName[32];
} WLAN_CONFIG_NAME;

typedef struct _WLAN_CONFIG_NAME_LIST
{
	int m_NumberOfItems; 
	WLAN_CONFIG_NAME* m_ConfigName;
}WLAN_CONFIG_NAME_LIST;

/***************************Return Value Info*************************************/
// BOOL Type
//	Success : TRUE
//	Fail	: FALSE

// int Type
// 0: SUCCESS
// 1: FAIL
// 2: INVALID NAME
// 3: INVALID CONFIG
// 4: INVALID DELETE
// 5: POWERCYCLE REQUIRED
// 6: INVALID PARAMETER
// 7: INVALID EAP TYPE
// 8: INVALID WEP TYPE
// 9: INVALID FILE

// WLAN_GetPowerStatus
//	TRUE : Power On
//	FALSE : Power Off  
/**********************************************************************************/
extern "C" WLAN_API  BOOL WLAN_Init();
extern "C" WLAN_API  BOOL WLAN_Close();
extern "C" WLAN_API  BOOL WLAN_PowerOn();
extern "C" WLAN_API  BOOL WLAN_PowerOff();
extern "C" WLAN_API  BOOL WLAN_GetPowerStatus();
extern "C" WLAN_API  BOOL WLAN_GetBssidList(WLAN_SSID_LIST* pstSsidList);
extern "C" WLAN_API  int  WLAN_ConnectAP(TCHAR* szBssid, TCHAR* szPassword, int iEncryptionType, int iWepKeyType);
extern "C" WLAN_API  int  WLAN_GetCurrentAPInfo(WLAN_STATUS* pstStatus);
extern "C" WLAN_API  int  WLAN_GetAllConfigName(WLAN_CONFIG_NAME_LIST* pstConfigList);
extern "C" WLAN_API  BOOL WLAN_DeleteConfig(TCHAR *szConfigName);
extern "C" WLAN_API  BOOL WLAN_ActivateConfig(TCHAR* szName);
extern "C" WLAN_API  BOOL WLAN_ExportConfig(TCHAR* szExportPath);
extern "C" WLAN_API  BOOL WLAN_ImportConfig(TCHAR* szImportPath);
extern "C" WLAN_API  BOOL WLAN_GetVersion(TCHAR* tzDllVersion, TCHAR* tzDllRelease);