﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using RFID_UHF_Net;

using INT8U = System.Byte;
using INT16U = System.UInt16;
using INT32U = System.UInt32;
using BOOL32 = System.Int32;
using HANDLE32 = System.UInt32;

namespace UHF_Gun_Net_Test
{
    public partial class Form_Access : Form
    {
        RFIDUHF _UHFNet;

        public Form_Access(RFIDUHF uhf)
        {
            InitializeComponent();

            _UHFNet = uhf;
            _UHFNet.MessageClass.AccessFunc += new ReceivedMemoryData(OnReceivedData);

            comboBox_Bank.Items.Add("RESERVED");
            comboBox_Bank.Items.Add("EPC");
            comboBox_Bank.Items.Add("TID");
            comboBox_Bank.Items.Add("USER");
            comboBox_Bank.SelectedIndex = 1;

            comboBox_Lock_Kill.Items.Add("ACCESSIBLE");
            comboBox_Lock_Kill.Items.Add("ALWAYS_ACCESSIBLE");
            comboBox_Lock_Kill.Items.Add("SECURED_ACCESSIBLE");
            comboBox_Lock_Kill.Items.Add("ALWAYS_NOT_ACCESSIBLE");
            comboBox_Lock_Kill.Items.Add("NO CHANGE");
            comboBox_Lock_Kill.SelectedIndex = 4;

            comboBox_Lock_Acc.Items.Add("ACCESSIBLE");
            comboBox_Lock_Acc.Items.Add("ALWAYS_ACCESSIBLE");
            comboBox_Lock_Acc.Items.Add("SECURED_ACCESSIBLE");
            comboBox_Lock_Acc.Items.Add("ALWAYS_NOT_ACCESSIBLE");
            comboBox_Lock_Acc.Items.Add("NO CHANGE");
            comboBox_Lock_Acc.SelectedIndex = 4;

            comboBox_Lock_EPC.Items.Add("ACCESSIBLE");
            comboBox_Lock_EPC.Items.Add("ALWAYS_ACCESSIBLE");
            comboBox_Lock_EPC.Items.Add("SECURED_ACCESSIBLE");
            comboBox_Lock_EPC.Items.Add("ALWAYS_NOT_ACCESSIBLE");
            comboBox_Lock_EPC.Items.Add("NO CHANGE");
            comboBox_Lock_EPC.SelectedIndex = 4;

            comboBox_Lock_TID.Items.Add("ACCESSIBLE");
            comboBox_Lock_TID.Items.Add("ALWAYS_ACCESSIBLE");
            comboBox_Lock_TID.Items.Add("SECURED_ACCESSIBLE");
            comboBox_Lock_TID.Items.Add("ALWAYS_NOT_ACCESSIBLE");
            comboBox_Lock_TID.Items.Add("NO CHANGE");
            comboBox_Lock_TID.SelectedIndex = 4;

            comboBox_Lock_User.Items.Add("ACCESSIBLE");
            comboBox_Lock_User.Items.Add("ALWAYS_ACCESSIBLE");
            comboBox_Lock_User.Items.Add("SECURED_ACCESSIBLE");
            comboBox_Lock_User.Items.Add("ALWAYS_NOT_ACCESSIBLE");
            comboBox_Lock_User.Items.Add("NO CHANGE");
            comboBox_Lock_User.SelectedIndex = 4;

            textBox_OffSet.Text = "2";
            textBox_WCnt.Text = "6";
            textBox_RWPwd.Text = "00000000";
            textBox_Read_Data.Text = String.Empty;
            textBox_Write_Data.Text = String.Empty;
            textBox_Lock_Pwd.Text = "00000000";
            textBox_Kill_Pwd.Text = "00000000";

            if (_UHFNet.IsCEDevice()) mainMenu1.Dispose();

        }

        private void button_Read_Clear_Click(object sender, EventArgs e)
        {
            textBox_Read_Data.Text = String.Empty;
            textBox_Write_Data.Text = String.Empty;
        }

        private void button_Read_Click(object sender, EventArgs e)
        {
            RFIDUHF.RFID_STATUS status = new RFIDUHF.RFID_STATUS();
            RFIDUHF.RFIDReadCmd ReadCmd = new RFIDUHF.RFIDReadCmd();

            ReadCmd.bank = (RFIDUHF.RFIDTagBank)comboBox_Bank.SelectedIndex;
            ReadCmd.wlength = (INT8U)Convert.ToUInt16(textBox_WCnt.Text);
            ReadCmd.offset = (INT8U)Convert.ToUInt16(textBox_OffSet.Text);
            ReadCmd.accpwd = Convert.ToUInt16(textBox_RWPwd.Text, 16);

            status = _UHFNet.Read(ref ReadCmd);

            if (status != RFIDUHF.RFID_STATUS.RFID_STATUS_OK)
            {
                MessageBox.Show("RFID Read Fail!");
            }
        }

        private void button_Write_Click(object sender, EventArgs e)
        {
            RFIDUHF.RFID_STATUS status = new RFIDUHF.RFID_STATUS();
            RFIDUHF.RFIDWriteCmd WriteCmd = new RFIDUHF.RFIDWriteCmd();

            String WriteData = textBox_Write_Data.Text;
            UInt16[] Data = new UInt16[32];

            for (int i = 0; i < Convert.ToUInt32(textBox_WCnt.Text); i++)
            {
                Data[i] = Convert.ToUInt16(WriteData.Substring(i * 4, 4), 16);
            }

            WriteCmd.accpwd = Convert.ToUInt32(textBox_RWPwd.Text, 16);
            WriteCmd.wlength = (INT8U)Convert.ToUInt32(textBox_WCnt.Text);
            WriteCmd.offset = (INT8U)Convert.ToUInt32(textBox_OffSet.Text);
            WriteCmd.bank = (RFIDUHF.RFIDTagBank)comboBox_Bank.SelectedIndex;
            WriteCmd.wdata = Data;

            status = _UHFNet.Write(ref WriteCmd);

            if (status != RFIDUHF.RFID_STATUS.RFID_STATUS_OK)
            {
                MessageBox.Show("RFID WRITE FAIL!");
            }
        }

        private void button_Lock_Click(object sender, EventArgs e)
        {
            RFIDUHF.RFID_STATUS status = new RFIDUHF.RFID_STATUS();
            RFIDUHF.RFIDLockCmd LockCmd = new RFIDUHF.RFIDLockCmd();

            LockCmd.lockkillpwd = (RFIDUHF.RFIDLockPermission)comboBox_Lock_Kill.SelectedIndex;
            LockCmd.lockaccesspwd = (RFIDUHF.RFIDLockPermission)comboBox_Lock_Acc.SelectedIndex;
            LockCmd.lockepc = (RFIDUHF.RFIDLockPermission)comboBox_Lock_EPC.SelectedIndex;
            LockCmd.locktid = (RFIDUHF.RFIDLockPermission)comboBox_Lock_TID.SelectedIndex;
            LockCmd.lockuser = (RFIDUHF.RFIDLockPermission)comboBox_Lock_User.SelectedIndex;

            LockCmd.accpwd = Convert.ToUInt32(textBox_Lock_Pwd.Text, 16);

            status = _UHFNet.Lock(ref LockCmd);

            if (status != RFIDUHF.RFID_STATUS.RFID_STATUS_OK)
            {
                MessageBox.Show("RFID LOCK FAIL!");
            }

        }

        private void button_Kill_Click(object sender, EventArgs e)
        {
            RFIDUHF.RFID_STATUS status = new RFIDUHF.RFID_STATUS();
            RFIDUHF.RFIDKillCmd KillCmd = new RFIDUHF.RFIDKillCmd();

            KillCmd.killpwd = uint.Parse(textBox_Kill_Pwd.Text);

            status = _UHFNet.Kill(ref KillCmd);

            if (status != RFIDUHF.RFID_STATUS.RFID_STATUS_OK)
            {
                MessageBox.Show("RFID KILL FAIL!");
            }
        }

        private void OnReceivedData()
        {
            int nLength = 0;
            StringBuilder strData = new StringBuilder(260);

            RFIDUHF.RFIDErrorcode error;

            nLength = _UHFNet.GetData(strData);

            if (nLength == 0)
            {
                error = _UHFNet.GetError();

                MessageBox.Show("OnReceivedData: " + error.ToString());
            }
            else
            {
                textBox_Read_Data.Text = String.Format("{0:X2}", strData);
            }
        }

        private void textBox_RWPwd_EnabledChanged(object sender, EventArgs e)
        {
            textBox_Lock_Pwd.Text = textBox_RWPwd.Text;
        }

        private void textBox_Lock_Pwd_EnabledChanged(object sender, EventArgs e)
        {
            textBox_RWPwd.Text = textBox_Lock_Pwd.Text;
        }
    }
}