﻿/********************************************************************
created		:	2012/01/13
file base	: 	SystemNetTest.exe

file ext	:	cs
author		:	Eun-Taek Lee

purpose		:	System C# Demo Program
Report		:	2012. 01. 13 [ET] v1.0.0 - M3Orange/M3Sky_Summit/M3Smart_WM/M3T 통합 버전
Report		:	2012. 05. 15 [ET] v1.1.0 - M3Smart_CE 추가 / GetGuid()기능 추가
Report		:	2013. 04. 25 [ET] v1.1.2 - M3OrangePlus 추가 / M3Smart의 Gyrosensor 기능 추가
Report		:	2013. 08. 25 [ET] v1.1.3 - M3OrangePlus CE추가
Report		:	2014. 02. 26 [ET] v1.1.4 - Black 추가
Report		:	2014. 09. 01 [ET] v1.1.5 - UL10 추가
Report		:	2015. 02. 05 [ET] v1.1.6 - M3BLACK CE 추가
*********************************************************************/

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SystemNet;
using System.Runtime.InteropServices;


namespace SystemTestNet
{
    public partial class SystemTestNet : Form
    {
        private SystemNet.SystemNet m_System;
        public string m_strVersion;
        SystemNet.MODEL_TYPE m_DeviceInfo;

        [DllImport("coredll.dll")]
        public static extern bool SystemParametersInfo(uint uiAction, uint uiParam, StringBuilder pvParam, bool fWinIni);

        const int SPI_GETPLATFORMTYPE = 257;
        

        private const string NETSDK_VERSION = "\r\nNetSDK Ver : 1.1.6 (20150205)";

        public SystemTestNet()
        {
            InitializeComponent();

            m_System = new SystemNet.SystemNet();

            StringBuilder strVersion = new StringBuilder(2711);
            m_strVersion = m_System.GetVersionInfo();
            m_strVersion = m_strVersion.ToString() + NETSDK_VERSION;
            
            m_DeviceInfo = m_System.GetDeviceInfo();

             
            if (m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3SMARTWM || m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3BLACK)   //DEVICE_M3SMARTWM:
            {
                BN_GyroSensor.Visible = true;
            }
            else
            {
                BN_GyroSensor.Visible = false;
            }


            TB_INFOMATION.Text = m_strVersion;


            StringBuilder sb = new StringBuilder();

            SystemParametersInfo(SPI_GETPLATFORMTYPE, 255, sb, false);

            if (sb.ToString().Trim() == "PocketPC" || sb.ToString().Trim() == "SmartPhone")
            {
                MainMenu mainMenu = new MainMenu();

                this.Menu = mainMenu;
            }

        }

        private void BN_BACKLIGHT_Click(object sender, EventArgs e)
        {
            FBACKLIGHT Backlight = new FBACKLIGHT();

            Backlight.ShowDialog();
        }

        private void BN_VOLUME_Click(object sender, EventArgs e)
        {
            FVOLUME Volume = new FVOLUME();

            Volume.ShowDialog();
        }

        private void BN_POWERCPU_Click(object sender, EventArgs e)
        {
            FPOWERCPU Powercpu = new FPOWERCPU();

            Powercpu.ShowDialog();
        }

        private void BN_CURRENTSTATUS_Click(object sender, EventArgs e)
        {
            FSTATUS Status = new FSTATUS();

            Status.ShowDialog();
        }

        private void BN_GYROSENSOR_Click(object sender, EventArgs e)
        {
            FGYROSENSOR Gyrosensor = new FGYROSENSOR();

            Gyrosensor.ShowDialog();
        }
    }
}