﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using SystemNet;

namespace SystemTestNet
{
    public partial class FVOLUME : Form
    {
        [DllImport("user32.dll", CharSet = CharSet.Auto)]
        private static extern IntPtr SetFocus(IntPtr hwnd);

        private SystemNet.SystemNet m_System;

        int nVolumeLevel_Cur;
        int nPhoneVolumeLevel_Cur;

        int nIndex;

        SystemNet.MODEL_TYPE m_DeviceInfo;

        public FVOLUME()
        {
            InitializeComponent();

            nIndex = 0;

            m_System = new SystemNet.SystemNet();

            m_DeviceInfo = m_System.GetDeviceInfo();

            if (m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_Pos)     
            {            
                TB_PHONEVOLUME.Enabled = false;
                BN_VIBRATEON.Enabled = false;
                BN_VIBRATEOFF.Enabled = false;
            }



            if (m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3T || m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_Pos)
            {
                TB_MAINVOLUME.Maximum = 10;
                TB_MAINVOLUME.Minimum = 0;

                nVolumeLevel_Cur = m_System.GetVolumeLevel();
                TB_MAINVOLUME.Value = nVolumeLevel_Cur;
            }
            else if ((m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3SMARTCE) || (m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3ORANGEPLUS_CE) || (m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3UL10_CE) || (m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3BLACK_CE) )
            {
                TB_MAINVOLUME.Maximum = 6;
                TB_MAINVOLUME.Minimum = 0;

                nVolumeLevel_Cur = m_System.GetVolumeLevel();
                TB_MAINVOLUME.Value = nVolumeLevel_Cur;
            }
            else
            {
                TB_MAINVOLUME.Maximum = 5;
                TB_MAINVOLUME.Minimum = 0;

                nVolumeLevel_Cur = m_System.GetVolumeLevel();
                TB_MAINVOLUME.Value = nVolumeLevel_Cur;
            }

            if ((m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3T) || (m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3SMARTCE) || (m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3ORANGEPLUS_CE) || (m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3UL10_CE) || (m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3BLACK_CE))
            {
                label3.Enabled = false;
                TB_PHONEVOLUME.Enabled = false;
            }
            else if (m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3BLACK)
            {
                TB_PHONEVOLUME.Maximum = 5;
                TB_PHONEVOLUME.Minimum = 0;

                nPhoneVolumeLevel_Cur = m_System.GetPhoneVolumeLevel();
                TB_PHONEVOLUME.Value = nPhoneVolumeLevel_Cur;
            }
            else
            {

                TB_PHONEVOLUME.Maximum = 5;
                TB_PHONEVOLUME.Minimum = 0;

                nPhoneVolumeLevel_Cur = m_System.GetPhoneVolumeLevel();

                switch (nPhoneVolumeLevel_Cur)
                {
                    case 0:
                        nPhoneVolumeLevel_Cur = 5;
                        break;
                    case 1:
                        nPhoneVolumeLevel_Cur = 4;
                        break;
                    case 2:
                        nPhoneVolumeLevel_Cur = 3;
                        break;
                    case 3:
                        nPhoneVolumeLevel_Cur = 2;
                        break;
                    case 4:
                        nPhoneVolumeLevel_Cur = 1;
                        break;
                    case 5:
                        nPhoneVolumeLevel_Cur = 0;
                        break;
                    default:
                        nPhoneVolumeLevel_Cur = 3;
                        break;
                }
                                
                TB_PHONEVOLUME.Value = nPhoneVolumeLevel_Cur;

            }
            nIndex = 1;
         
        }

        private void BN_VOLUMEMUTE_Click(object sender, EventArgs e)
        {
            if (m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3T || m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_Pos)
            {
                m_System.SetVolumeLevel(10);
                TB_MAINVOLUME.Value = 0;
            }
            else if (m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3SMARTCE || m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3ORANGEPLUS_CE || m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3UL10_CE || m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3BLACK_CE)
            {
                m_System.SetVolumeLevel(6);
                TB_MAINVOLUME.Value = 0;
            }

            else if (m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3BLACK)
            {
                m_System.SetVolumeLevel(0);
                TB_MAINVOLUME.Value = 0;

                m_System.SetPhoneVolumeLevel(0);
                TB_PHONEVOLUME.Value = 0;

            }
            else
            {
                m_System.SetVolumeLevel(5);
                TB_MAINVOLUME.Value = 0;

                m_System.SetPhoneVolumeLevel(0);
                TB_PHONEVOLUME.Value = 0;
            }

            BN_VIBRATEOFF.Focus();

            m_System.VolumeMute();
            // for test
        }

        private void BN_VIBRATEON_Click(object sender, EventArgs e)
        {
            m_System.Vibrate(true);
        }

        private void BN_VIBRATEOFF_Click(object sender, EventArgs e)
        {
            m_System.Vibrate(false);
        }

        private void TB_MAINVOLUME_ValueChanged(object sender, EventArgs e)
        {
            int nPos;
            if(nIndex == 1)
            {
                nPos = TB_MAINVOLUME.Value;

                if (m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3T || m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_Pos)
                {
                    switch (nPos)
                    {
                        case 0:
                            nPos = 10;
                            break;
                        case 1:
                            nPos = 9;
                            break;
                        case 2:
                            nPos = 8;
                            break;
                        case 3:
                            nPos = 7;
                            break;
                        case 4:
                            nPos = 6;
                            break;
                        case 5:
                            nPos = 5;
                            break;
                        case 6:
                            nPos = 4;
                            break;
                        case 7:
                            nPos = 3;
                            break;
                        case 8:
                            nPos = 2;
                            break;
                        case 9:
                            nPos = 1;
                            break;
                        case 10:
                            nPos = 0;
                            break;
                        default:
                            nPos = 3;
                            break;
                    }
                }
                else if (m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3SMARTCE || m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3ORANGEPLUS_CE || m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3UL10_CE || m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3BLACK_CE) 
                {
                    switch (nPos)
                    {
                        case 0:
                            nPos = 6;
                            break;
                        case 1:
                            nPos = 5;
                            break;
                        case 2:
                            nPos = 4;
                            break;
                        case 3:
                            nPos = 3;
                            break;
                        case 4:
                            nPos = 2;
                            break;
                        case 5:
                            nPos = 1;
                            break;
                        case 6:
                            nPos = 0;
                            break;
                        default:
                            nPos = 3;
                            break;
                    }                
                }
                else if (m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3BLACK )
                {

                }
                else
                {
                    switch (nPos)
                    {
                        case 0:
                            nPos = 5;
                            break;
                        case 1:
                            nPos = 4;
                            break;
                        case 2:
                            nPos = 3;
                            break;
                        case 3:
                            nPos = 2;
                            break;
                        case 4:
                            nPos = 1;
                            break;
                        case 5:
                            nPos = 0;
                            break;
                        default:
                            nPos = 3;
                            break;
                    }
                }
                m_System.SetVolumeLevel(nPos);
            }
        }

        private void TB_PHONEVOLUME_ValueChanged(object sender, EventArgs e)
        {
            int nPos;

            if (nIndex == 1)
            {
                nPos = TB_PHONEVOLUME.Value;

                if (m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3T || m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_Pos)
                {
                    switch (nPos)
                    {
                        case 0:
                            nPos = 0;
                            break;
                        case 1:
                            nPos = 1;
                            break;
                        case 2:
                            nPos = 2;
                            break;
                        case 3:
                            nPos = 3;
                            break;
                        case 4:
                            nPos = 4;
                            break;
                        case 5:
                            nPos = 5;
                            break;
                        case 6:
                            nPos = 6;
                            break;
                        case 7:
                            nPos = 7;
                            break;
                        case 8:
                            nPos = 8;
                            break;
                        case 9:
                            nPos = 9;
                            break;
                        case 10:
                            nPos = 10;
                            break;
                        default:
                            nPos = 3;
                            break;
                    }
                }
                else if (m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3SMARTCE || m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3ORANGEPLUS_CE || m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3UL10_CE)
                {
                    switch (nPos)
                    {
                        case 0:
                            nPos = 6;
                            break;
                        case 1:
                            nPos = 5;
                            break;
                        case 2:
                            nPos = 4;
                            break;
                        case 3:
                            nPos = 3;
                            break;
                        case 4:
                            nPos = 2;
                            break;
                        case 5:
                            nPos = 1;
                            break;
                        case 6:
                            nPos = 0;
                            break;
                        default:
                            nPos = 3;
                            break;
                    }

                }
                else
                {


                    switch (nPos)
                    {
                        case 0:
                            nPos = 0;
                            break;
                        case 1:
                            nPos = 1;
                            break;
                        case 2:
                            nPos = 2;
                            break;
                        case 3:
                            nPos = 3;
                            break;
                        case 4:
                            nPos = 4;
                            break;
                        case 5:
                            nPos = 5;
                            break;
                        default:
                            nPos = 3;
                            break;
                    }
                }
                m_System.SetPhoneVolumeLevel(nPos);
            }
        }

        private void BTN_CLOSE_Click(object sender, EventArgs e)
        {
            Close();
        }
    }
}
