﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;

namespace SystemTestNet
{
    public partial class FSTATUS : Form
    {
        private SystemNet.SystemNet m_System;

        public SystemNet.MODEL_TYPE m_DeviceInfo;
        IntPtr nCpuClock;
        int nCurClock;

        string strSerial;
        string strOSVersion;
        string strGuid;
        int stBatteryLife;

        string strBattery;
        [DllImport("coredll.dll")]
        public static extern bool SystemParametersInfo(uint uiAction, uint uiParam, StringBuilder pvParam, bool fWinIni);

        const int SPI_GETPLATFORMTYPE = 257;

        public FSTATUS()
        {
            InitializeComponent();
            
            m_System = new SystemNet.SystemNet();
            m_DeviceInfo = m_System.GetDeviceInfo();

            strSerial = m_System.GetSerialNumber();
            LB_SERIAL.Text = "Serial Number : " + strSerial;

            strGuid = m_System.GetGuid();
            if (m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3SKY || m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3ORANGE || m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3SKYSAM || m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3SMARTCE || m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3T || m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_MM3 || m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_Pos)
            {
                LB_GUID.Text = "GUID : " + strGuid; 
            }
            else
            {
                LB_GUID.Text = "UUID : " + strGuid;
            }

            strOSVersion = m_System.GetOSVersionInfo();
            LB_OSVERSION.Text = "OS Version : " + strOSVersion;


            if (m_System.GetWlan() == true)
                LB_WLAN.Text = "WLAN : ON";
            else
                LB_WLAN.Text = "WLAN : OFF";


            if (m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3SMARTCE || m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3ORANGEPLUS_CE || m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_Pos || m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3T || m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3UL10_CE) 
            {
                LB_BT.Text = "BT : N/A";
            }
            else
            {
                if (m_System.GetBluetooth() == true)
                    LB_BT.Text = "BT : ON";
                else
                    LB_BT.Text = "BT : OFF";
            }

            switch (m_DeviceInfo)
            {
                case SystemNet.MODEL_TYPE.DEVICE_M3SMARTWM:
                case SystemNet.MODEL_TYPE.DEVICE_MM3:
                case SystemNet.MODEL_TYPE.DEVICE_M3ORANGEPLUS_CE:
                case SystemNet.MODEL_TYPE.DEVICE_M3ORANGEPLUS_WM:
                case SystemNet.MODEL_TYPE.DEVICE_M3UL10_CE:
                    break;
                case SystemNet.MODEL_TYPE.DEVICE_M3SKY:
                case SystemNet.MODEL_TYPE.DEVICE_M3SKYSAM:
                    M3Sky_GetCpu();
                    break;
                case SystemNet.MODEL_TYPE.DEVICE_M3ORANGE:
                    M3Orange_GetCpu();
                    break;
                case SystemNet.MODEL_TYPE.DEVICE_M3T:
                    M3T_GetCpu();
                    break;
                case SystemNet.MODEL_TYPE.DEVICE_Pos:	
                    Pos_GetCpu();
                    break;
                case SystemNet.MODEL_TYPE.DEVICE_M3BLACK_CE: 
                case SystemNet.MODEL_TYPE.DEVICE_M3BLACK:
                    M3BLACK_GetCpu();
                    break;
            }
            
                        

            if (m_System.GetBatteryState() == true)
                LB_BATTERYSTATUS.Text = "Power : AC Power";
            else
                LB_BATTERYSTATUS.Text = "Power : Battery Power";

            if (m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3UL10_CE)
            {
                strBattery = "Battery Life : NA";
            
            }
            else
            {
                stBatteryLife = m_System.GetBatteryLifePercent();
                strBattery = "Battery Life : " + stBatteryLife.ToString() + "%";
            }
            LB_BATTERYLIFE.Text = strBattery;
            PB_BATTERYLIFE.Value = stBatteryLife;

            StringBuilder sb = new StringBuilder();

            SystemParametersInfo(SPI_GETPLATFORMTYPE, 255, sb, false);

            if (sb.ToString().Trim() == "PocketPC" || sb.ToString().Trim() == "SmartPhone")
            {
                MainMenu mainMenu = new MainMenu();

                this.Menu = mainMenu;
            }
              
        }

        
        public void M3BLACK_GetCpu()
        {
            nCurClock = m_System.GetCpuClock(out nCpuClock);

            switch (nCurClock)
            {
                case (int)SystemNet.BLACK_CPUTYPE.CLOCK_300MHz: 
                    LB_CPUCLOCK.Text = "CPU Clock : 300MHz";
                    break;
                case (int)SystemNet.BLACK_CPUTYPE.CLOCK_600MHz:
                    LB_CPUCLOCK.Text = "CPU Clock : 600MHz";
                    break;
                case (int)SystemNet.BLACK_CPUTYPE.CLOCK_800MHz: 
                    LB_CPUCLOCK.Text = "CPU Clock : 800MHz";
                    break;
                case (int)SystemNet.BLACK_CPUTYPE.CLOCK_1000MHz:
                    LB_CPUCLOCK.Text = "CPU Clock : 1000MHz";
                    break;
                default:
                    LB_CPUCLOCK.Text = "CPU Clock : 300MHz";
                    break;
            }
        }


        public void Pos_GetCpu()
        {
            nCurClock = m_System.GetCpuClock(out nCpuClock);

            switch (nCurClock)
            {
                case (int)SystemNet.POS_CPUTYPE.CLOCK_208MHz:
                    LB_CPUCLOCK.Text = "CPU Clock : 208MHz";
                    break;
                case (int)SystemNet.POS_CPUTYPE.CLOCK_416MHz: 
                    LB_CPUCLOCK.Text = "CPU Clock : 416MHz";
                    break;
                case (int)SystemNet.POS_CPUTYPE.CLOCK_624MHz:
                    LB_CPUCLOCK.Text = "CPU Clock : 624MHz";
                    break;
                case (int)SystemNet.POS_CPUTYPE.CLOCK_806MHz:
                    LB_CPUCLOCK.Text = "CPU Clock : 806MHz";
                    break;
                default:
                    LB_CPUCLOCK.Text = "CPU Clock : 208MHz";
                    break;
            }
        }

        public void M3Sky_GetCpu()
        {
            nCurClock = m_System.GetCpuClock(out nCpuClock);

            switch (nCurClock)
            {
                case (int)SystemNet.SKY_CPUTYPE.CLOCK_208MHz:
                    LB_CPUCLOCK.Text = "CPU Clock : 208MHz";
                    break;
                case (int)SystemNet.SKY_CPUTYPE.CLOCK_312MHz:
                    LB_CPUCLOCK.Text = "CPU Clock : 312MHz";
                    break;
                case (int)SystemNet.SKY_CPUTYPE.CLOCK_416MHz:
                    LB_CPUCLOCK.Text = "CPU Clock : 416MHz";
                    break;
                case (int)SystemNet.SKY_CPUTYPE.CLOCK_520MHz:
                    LB_CPUCLOCK.Text = "CPU Clock : 520MHz";
                    break;
                case (int)SystemNet.SKY_CPUTYPE.CLOCK_624MHz:
                    LB_CPUCLOCK.Text = "CPU Clock : 624MHz";
                    break;
                default:
                    LB_CPUCLOCK.Text = "CPU Clock : 208MHz";
                    break;
            }
        }

        public void M3Orange_GetCpu()
        {
            nCurClock = m_System.GetCpuClock(out nCpuClock);

            switch (nCurClock)
            {
                case (int)SystemNet.ORANGE_CPUTYPE.CLOCK_208MHz:
                    LB_CPUCLOCK.Text = "CPU Clock : 208MHz";
                    break;
                case (int)SystemNet.ORANGE_CPUTYPE.CLOCK_416MHz:
                    LB_CPUCLOCK.Text = "CPU Clock : 416MHz";
                    break;
                case (int)SystemNet.ORANGE_CPUTYPE.CLOCK_624MHz:
                    LB_CPUCLOCK.Text = "CPU Clock : 624MHz";
                    break;
                case (int)SystemNet.ORANGE_CPUTYPE.CLOCK_806MHz:
                    LB_CPUCLOCK.Text = "CPU Clock : 806MHz";
                    break;
                default:
                    LB_CPUCLOCK.Text = "CPU Clock : 208MHz";
                    break;
            }
        }


        public void M3T_GetCpu()
        {
            nCurClock = m_System.GetCpuClock(out nCpuClock);

            switch (nCurClock)
            {
                case (int)SystemNet.M3T_CPUTYPE.CLOCK_208MHz:
                    LB_CPUCLOCK.Text = "CPU Clock : 208MHz";
                    break;
                case (int)SystemNet.M3T_CPUTYPE.CLOCK_416MHz:
                    LB_CPUCLOCK.Text = "CPU Clock : 416MHz";
                    break;
                case (int)SystemNet.M3T_CPUTYPE.CLOCK_624MHz:
                    LB_CPUCLOCK.Text = "CPU Clock : 624MHz";
                    break;
                case (int)SystemNet.M3T_CPUTYPE.CLOCK_806MHz:
                    LB_CPUCLOCK.Text = "CPU Clock : 806MHz";
                    break;
                default:
                    LB_CPUCLOCK.Text = "CPU Clock : 208MHz";
                    break;
            }
        }

        private void FSTATUS_KeyDown_1(object sender, KeyEventArgs e)
        {
            if ((e.KeyCode == System.Windows.Forms.Keys.Up))
            {
                // Up
            }
            if ((e.KeyCode == System.Windows.Forms.Keys.Down))
            {
                // Down
            }
            if ((e.KeyCode == System.Windows.Forms.Keys.Left))
            {
                // Left
            }
            if ((e.KeyCode == System.Windows.Forms.Keys.Right))
            {
                // Right
            }
            if ((e.KeyCode == System.Windows.Forms.Keys.Enter))
            {
                // Enter
            }

        }

        
    }
}