﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;

namespace SystemTestNet
{
    public partial class FPOWERCPU : Form
    {
        private SystemNet.SystemNet m_System;

        SystemNet.MODEL_TYPE m_DeviceInfo;
        IntPtr nCpuClock;
        int nCurClock;
        bool bCurWlan;
        bool bCurBT;
        bool bReboot;
        bool bIndex;
        [DllImport("coredll.dll")]
        public static extern bool SystemParametersInfo(uint uiAction, uint uiParam, StringBuilder pvParam, bool fWinIni);

        const int SPI_GETPLATFORMTYPE = 257;

        public FPOWERCPU()
        {
            InitializeComponent();

            bIndex = false;

            m_System = new SystemNet.SystemNet();
            m_DeviceInfo = m_System.GetDeviceInfo();

            RD_REBOOT.Checked = true;
   
            switch (m_DeviceInfo)
            {
                case SystemNet.MODEL_TYPE.DEVICE_M3ORANGEPLUS_CE:
                case SystemNet.MODEL_TYPE.DEVICE_M3ORANGEPLUS_WM:
                case SystemNet.MODEL_TYPE.DEVICE_MM3:
                case SystemNet.MODEL_TYPE.DEVICE_M3SMARTCE:
                case SystemNet.MODEL_TYPE.DEVICE_M3SMARTWM:
                case SystemNet.MODEL_TYPE.DEVICE_M3UL10_CE:
                    break;
                case SystemNet.MODEL_TYPE.DEVICE_M3ORANGE:
                    M3Orange_Init();
                    break;
                case SystemNet.MODEL_TYPE.DEVICE_M3SKY: 
                case SystemNet.MODEL_TYPE.DEVICE_M3SKYSAM: 
                    M3Sky_Init();
                    break;
                case SystemNet.MODEL_TYPE.DEVICE_M3T:
                    M3T_Init();
                    break;
                case SystemNet.MODEL_TYPE.DEVICE_Pos:
                    Pos_Init();
                    break;
                case SystemNet.MODEL_TYPE.DEVICE_M3BLACK:
                case SystemNet.MODEL_TYPE.DEVICE_M3BLACK_CE:
                    M3Black_Init();
                    break;        
            }
            if (m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3ORANGE || m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3ORANGEPLUS_CE || m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3UL10_CE || m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_Pos || m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3T || m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3BLACK_CE)
            {
                RD_BTON.Enabled = false;
                RD_BTOFF.Enabled = false;
                label6.Enabled = false;
                panel5.Enabled = false;
            }
            else 
            {
                bCurBT = m_System.GetBluetooth();

                if (bCurBT == true)
                    RD_BTON.Checked = true;
                else
                    RD_BTOFF.Checked = true;
            }

            if (m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3SMARTCE || m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3ORANGEPLUS_CE || m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3UL10_CE || m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3ORANGEPLUS_WM || m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_MM3 || m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3SMARTWM) 
            {
                label5.Enabled = false;
                label4.Enabled = false;
                CB_CPUCLOCK.Enabled = false;
            }

            bCurWlan = m_System.GetWlan();

            if (bCurWlan == true)
                RD_WLANON.Checked = true;
            else
                RD_WLANOFF.Checked = true;

          

            bReboot = false;
            bIndex = true;

            StringBuilder sb = new StringBuilder();

            SystemParametersInfo(SPI_GETPLATFORMTYPE, 255, sb, false);

            if (sb.ToString().Trim() == "PocketPC" || sb.ToString().Trim() == "SmartPhone")
            {
                MainMenu mainMenu = new MainMenu();

                this.Menu = mainMenu;
            }
        }

        private void BN_REBOOTON_Click(object sender, EventArgs e)
        {
            if (RD_REBOOT.Checked == true)
                bReboot = false;
            else
                bReboot = true;

            m_System.Cleanboot(bReboot);
            m_System.Reboot();
        }
        

        private void BN_KEYPADON_Click(object sender, EventArgs e)
        {
            m_System.KeypadLock(false);        
        }

        private void BN_KEYPADOFF_Click(object sender, EventArgs e)
        {
            m_System.KeypadLock(true);
        }
        

        private void CB_CPUCLOCK_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (bIndex == true)
            {
                switch (m_DeviceInfo)
                {
                    case SystemNet.MODEL_TYPE.DEVICE_M3SMARTWM:
                    case SystemNet.MODEL_TYPE.DEVICE_MM3:
                    case SystemNet.MODEL_TYPE.DEVICE_M3ORANGEPLUS_WM:
                    case SystemNet.MODEL_TYPE.DEVICE_M3ORANGEPLUS_CE:
                    case SystemNet.MODEL_TYPE.DEVICE_M3UL10_CE:
                        break;
                    case SystemNet.MODEL_TYPE.DEVICE_M3SKYSAM: 
                    case SystemNet.MODEL_TYPE.DEVICE_M3SKY:
                        M3Sky_SetCpu(CB_CPUCLOCK.SelectedIndex);
                        break;
                    case SystemNet.MODEL_TYPE.DEVICE_M3ORANGE:
                        M3Orange_SetCpu(CB_CPUCLOCK.SelectedIndex);
                        break;
                    case SystemNet.MODEL_TYPE.DEVICE_M3T: 
                        M3T_SetCpu(CB_CPUCLOCK.SelectedIndex);
                        break;
                    case SystemNet.MODEL_TYPE.DEVICE_Pos: 
                        Pos_SetCpu(CB_CPUCLOCK.SelectedIndex);
                        break;
                    case SystemNet.MODEL_TYPE.DEVICE_M3BLACK:
                    case SystemNet.MODEL_TYPE.DEVICE_M3BLACK_CE:
                        M3Black_SetCpu(CB_CPUCLOCK.SelectedIndex);
                        break;
                }
            }
            
        }



        public void M3Black_SetCpu(int nIndex)
        {
        
            switch (nIndex)
            {
                case 0: 
                    m_System.SetCpuClock((int)SystemNet.BLACK_CPUTYPE.CLOCK_300MHz);
                    break;
                case 1: 
                    m_System.SetCpuClock((int)SystemNet.BLACK_CPUTYPE.CLOCK_600MHz);
                    break;
                case 2: 
                    m_System.SetCpuClock((int)SystemNet.BLACK_CPUTYPE.CLOCK_800MHz);
                    break;
                case 3: 
                    m_System.SetCpuClock((int)SystemNet.BLACK_CPUTYPE.CLOCK_1000MHz);
                    break;
                default:
                    m_System.SetCpuClock((int)SystemNet.BLACK_CPUTYPE.CLOCK_300MHz);
                    break;
            }
        }


        public void M3Sky_Init()
        {
            CB_CPUCLOCK.Items.Clear();
            CB_CPUCLOCK.Items.Add("Release");
            CB_CPUCLOCK.Items.Add("208MHZ");
            CB_CPUCLOCK.Items.Add("312MHZ");
            CB_CPUCLOCK.Items.Add("416MHZ");
            CB_CPUCLOCK.Items.Add("520MHZ");
            CB_CPUCLOCK.Items.Add("624MHZ");

            nCurClock = m_System.GetCpuClock(out nCpuClock);

            switch (nCurClock)
            {
                case (int)SystemNet.SKY_CPUTYPE.CLOCK_208MHz: 
                    CB_CPUCLOCK.SelectedIndex = 1;
                    break;
                case (int)SystemNet.SKY_CPUTYPE.CLOCK_312MHz: 
                    CB_CPUCLOCK.SelectedIndex = 2;
                    break;
                case (int)SystemNet.SKY_CPUTYPE.CLOCK_416MHz:
                    CB_CPUCLOCK.SelectedIndex = 3;
                    break;
                case (int)SystemNet.SKY_CPUTYPE.CLOCK_520MHz:
                    CB_CPUCLOCK.SelectedIndex = 4;
                    break;
                case (int)SystemNet.SKY_CPUTYPE.CLOCK_624MHz: 
                    CB_CPUCLOCK.SelectedIndex = 5;
                    break;
                default:
                    CB_CPUCLOCK.SelectedIndex = 0;
                    break;
            }
        }

        public void M3Black_Init()
        {
            CB_CPUCLOCK.Items.Clear();
            CB_CPUCLOCK.Items.Add("300MHZ");
            CB_CPUCLOCK.Items.Add("600MHZ");
            CB_CPUCLOCK.Items.Add("800MHZ");
            CB_CPUCLOCK.Items.Add("1000MHZ");

            nCurClock = m_System.GetCpuClock(out nCpuClock);

            switch (nCurClock)
            {
                case (int)SystemNet.BLACK_CPUTYPE.CLOCK_300MHz: 
                    CB_CPUCLOCK.SelectedIndex = 0;
                    break;
                case (int)SystemNet.BLACK_CPUTYPE.CLOCK_600MHz: 
                    CB_CPUCLOCK.SelectedIndex = 1;
                    break;
                case (int)SystemNet.BLACK_CPUTYPE.CLOCK_800MHz: 
                    CB_CPUCLOCK.SelectedIndex = 2;
                    break;
                case (int)SystemNet.BLACK_CPUTYPE.CLOCK_1000MHz:
                    CB_CPUCLOCK.SelectedIndex = 3;
                    break;
                default:
                    CB_CPUCLOCK.SelectedIndex = 0;
                    break;
            }
        }
        

        public void M3Orange_Init()
        {
            CB_CPUCLOCK.Items.Clear();
            CB_CPUCLOCK.Items.Add("208MHZ");
            CB_CPUCLOCK.Items.Add("416MHZ");
            CB_CPUCLOCK.Items.Add("624MHZ");
            CB_CPUCLOCK.Items.Add("806MHZ");

            nCurClock = m_System.GetCpuClock(out nCpuClock);
            
            switch (nCurClock)
            {
                case (int)SystemNet.ORANGE_CPUTYPE.CLOCK_208MHz:
                    CB_CPUCLOCK.SelectedIndex = 0;
                    break;
                case (int)SystemNet.ORANGE_CPUTYPE.CLOCK_416MHz:
                    CB_CPUCLOCK.SelectedIndex = 1;
                    break;
                case (int)SystemNet.ORANGE_CPUTYPE.CLOCK_624MHz:
                    CB_CPUCLOCK.SelectedIndex = 2;
                    break;
                case (int)SystemNet.ORANGE_CPUTYPE.CLOCK_806MHz:
                    CB_CPUCLOCK.SelectedIndex = 3;
                    break;
                default:
                    CB_CPUCLOCK.SelectedIndex = 0;
                    break;
            }
        }

        public void M3T_Init()
        {
            CB_CPUCLOCK.Items.Clear();
            CB_CPUCLOCK.Items.Add("208MHZ");
            CB_CPUCLOCK.Items.Add("416MHZ");
            CB_CPUCLOCK.Items.Add("624MHZ");
            CB_CPUCLOCK.Items.Add("806MHZ");

            nCurClock = m_System.GetCpuClock(out nCpuClock);

            switch (nCurClock)
            {
                case (int)SystemNet.M3T_CPUTYPE.CLOCK_208MHz:
                    CB_CPUCLOCK.SelectedIndex = 0;
                    break;
                case (int)SystemNet.M3T_CPUTYPE.CLOCK_416MHz:
                    CB_CPUCLOCK.SelectedIndex = 1;
                    break;
                case (int)SystemNet.M3T_CPUTYPE.CLOCK_624MHz:
                    CB_CPUCLOCK.SelectedIndex = 2;
                    break;
                case (int)SystemNet.M3T_CPUTYPE.CLOCK_806MHz:
                    CB_CPUCLOCK.SelectedIndex = 3;
                    break;
                default:
                    CB_CPUCLOCK.SelectedIndex = 0;
                    break;
            }
        }

        public void Pos_Init()
        {
            CB_CPUCLOCK.Items.Clear();
            CB_CPUCLOCK.Items.Add("208MHZ");
            CB_CPUCLOCK.Items.Add("416MHZ");
            CB_CPUCLOCK.Items.Add("624MHZ");
            CB_CPUCLOCK.Items.Add("806MHZ");

            nCurClock = m_System.GetCpuClock(out nCpuClock);

            switch (nCurClock)
            {
                case (int)SystemNet.POS_CPUTYPE.CLOCK_208MHz:
                    CB_CPUCLOCK.SelectedIndex = 0;
                    break;
                case (int)SystemNet.POS_CPUTYPE.CLOCK_416MHz:
                    CB_CPUCLOCK.SelectedIndex = 1;
                    break;
                case (int)SystemNet.POS_CPUTYPE.CLOCK_624MHz:
                    CB_CPUCLOCK.SelectedIndex = 2;
                    break;
                case (int)SystemNet.POS_CPUTYPE.CLOCK_806MHz:
                    CB_CPUCLOCK.SelectedIndex = 3;
                    break;
                default:
                    CB_CPUCLOCK.SelectedIndex = 0;
                    break;
            }
        }



        public void M3Sky_SetCpu(int nIndex)
        {
            switch (nIndex)
            {
                case 0:
                    m_System.SetCpuClock((int)SystemNet.SKY_CPUTYPE.CLOCK_208MHz);
                    break;
                case 1: 
                    m_System.SetCpuClock((int)SystemNet.SKY_CPUTYPE.CLOCK_208MHz);
                    break;
                case 2: 
                    m_System.SetCpuClock((int)SystemNet.SKY_CPUTYPE.CLOCK_312MHz);
                    break;
                case 3:
                    m_System.SetCpuClock((int)SystemNet.SKY_CPUTYPE.CLOCK_416MHz);
                    break;
                case 4:
                    m_System.SetCpuClock((int)SystemNet.SKY_CPUTYPE.CLOCK_520MHz);
                    break;
                case 5:
                    m_System.SetCpuClock((int)SystemNet.SKY_CPUTYPE.CLOCK_624MHz);
                    break;
                default:
                    m_System.SetCpuClock((int)SystemNet.SKY_CPUTYPE.CLOCK_208MHz);
                    break;
            }
        }

        public void M3Orange_SetCpu(int nIndex)
        {
            switch (nIndex)
             {
                 case 0:
                     m_System.SetCpuClock((int)SystemNet.ORANGE_CPUTYPE.CLOCK_208MHz);
                     break;
                 case 1:
                     m_System.SetCpuClock((int)SystemNet.ORANGE_CPUTYPE.CLOCK_416MHz);
                     break;
                 case 2:
                     m_System.SetCpuClock((int)SystemNet.ORANGE_CPUTYPE.CLOCK_624MHz);
                     break;
                 case 3:
                     m_System.SetCpuClock((int)SystemNet.ORANGE_CPUTYPE.CLOCK_806MHz);
                     break;
                 default:
                     m_System.SetCpuClock((int)SystemNet.ORANGE_CPUTYPE.CLOCK_208MHz);
                     break;
             }
         }


        public void M3T_SetCpu(int nIndex)
        {
            switch (nIndex)
            {
                case 0: //208000
                    m_System.SetCpuClock((int)SystemNet.M3T_CPUTYPE.CLOCK_208MHz);
                    break;
                case 1: //416000
                    m_System.SetCpuClock((int)SystemNet.M3T_CPUTYPE.CLOCK_416MHz);
                    break;
                case 2: //624000
                    m_System.SetCpuClock((int)SystemNet.M3T_CPUTYPE.CLOCK_624MHz);
                    break;
                case 3: //806000
                    m_System.SetCpuClock((int)SystemNet.M3T_CPUTYPE.CLOCK_806MHz);
                    break;
                default:
                    m_System.SetCpuClock(0);
                    break;
            }
        }

        public void Pos_SetCpu(int nIndex)
        {
            switch (nIndex)
            {
                case 0:
                    m_System.SetCpuClock((int)SystemNet.POS_CPUTYPE.CLOCK_208MHz);
                    break;
                case 1: 
                    m_System.SetCpuClock((int)SystemNet.POS_CPUTYPE.CLOCK_416MHz);
                    break;
                case 2: 
                    m_System.SetCpuClock((int)SystemNet.POS_CPUTYPE.CLOCK_624MHz);
                    break;
                case 3: 
                    m_System.SetCpuClock((int)SystemNet.POS_CPUTYPE.CLOCK_806MHz);
                    break;
                default:
                    m_System.SetCpuClock((int)SystemNet.POS_CPUTYPE.CLOCK_208MHz);
                    break;
            }

        }


        private void RD_WLANON_CheckedChanged(object sender, EventArgs e)
        {
            Cursor.Current = Cursors.WaitCursor;

            if (bIndex == true)
            {
                if (RD_WLANON.Checked == true)
                {
                    m_System.SetWlan(true);
                    MessageBox.Show("WLAN On!");
                }
                else
                {
                    m_System.SetWlan(false);
                    MessageBox.Show("WLAN Off!");
                }
            }

            Cursor.Current = Cursors.Default;
        }

        private void RD_BTON_CheckedChanged(object sender, EventArgs e)
        {
            Cursor.Current = Cursors.WaitCursor;
            
            if(bIndex == true)
            {
                if(RD_BTON.Checked == true)
                {
                    m_System.SetBluetooth(true);
                    MessageBox.Show("BT On!");
                }
                else
                {
                    m_System.SetBluetooth(false);
                    MessageBox.Show("BT Off!");
                }
            }

            Cursor.Current = Cursors.Default;
        }
    }
}