﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SystemNet;
using System.Runtime.InteropServices;

namespace SystemTestNet
{
    public partial class FGYROSENSOR : Form
    {
        private SystemNet.SystemNet m_System;
        public GSensor_PARAMS m_GSensor_Params;

        [DllImport("coredll.dll")]
        public static extern bool SystemParametersInfo(uint uiAction, uint uiParam, StringBuilder pvParam, bool fWinIni);

        const int SPI_GETPLATFORMTYPE = 257;

        public FGYROSENSOR()
        {
            m_System = new SystemNet.SystemNet();
            InitializeComponent();



            StringBuilder sb = new StringBuilder();

            SystemParametersInfo(SPI_GETPLATFORMTYPE, 255, sb, false);

            if (sb.ToString().Trim() == "PocketPC" || sb.ToString().Trim() == "SmartPhone")
            {
                MainMenu mainMenu = new MainMenu();

                this.Menu = mainMenu;
            }
        }


        private void FGYROSENSOR_Load(object sender, EventArgs e)
        {
            m_GSensor_Params = new GSensor_PARAMS();
            m_System.GetGSensorValue(out m_GSensor_Params);


              if (m_GSensor_Params.GsensorEnable == 1) 
              {
                  RD_GSENSORON.Checked = true;
              }
              else if (m_GSensor_Params.GsensorEnable == 0)
              {
                  RD_GSENSOROFF.Checked = true;
              }

              CB_MotionDisplayOff.Checked       = m_GSensor_Params.MotionDisplayOff;
              CB_MotionDisplayWakeup.Checked    = m_GSensor_Params.MotionDisplayWakeup;
              CB_MotionSleepOn.Checked          = m_GSensor_Params.MotionSleepOn;
              CB_MotionSleepOnPrevent.Checked   = m_GSensor_Params.MotionSleepOnPrevent;
              CB_DisplayRotate.Checked          = m_GSensor_Params.DisplayRotate;
        }


        private void CB_MotionSleepOn_CheckStateChanged(object sender, EventArgs e)
        {
            if (CB_MotionSleepOn.Checked == true)
            {
                CB_MotionDisplayOff.Enabled = false;
            }
            else if (CB_MotionSleepOn.Checked == false && CB_MotionSleepOnPrevent.Checked == false)
            {
                CB_MotionDisplayOff.Enabled = true;
            }    
        }

        private void CB_MotionSleepOnPrevent_CheckStateChanged(object sender, EventArgs e)
        {
            if (CB_MotionSleepOnPrevent.Checked == true)
            {
                CB_MotionDisplayOff.Enabled = false;
            }
            else if (CB_MotionSleepOnPrevent.Checked == false && CB_MotionSleepOn.Checked == false)
            {
                CB_MotionDisplayOff.Enabled = true;
            }
        }

        private void CB_MotionDisplayOff_CheckStateChanged(object sender, EventArgs e)
        {
            if (CB_MotionDisplayOff.Checked == true)
            {
                CB_MotionDisplayWakeup.Enabled  = true;
                CB_MotionSleepOn.Enabled        = false;
                CB_MotionSleepOnPrevent.Enabled = false;
            }
            else if (CB_MotionDisplayOff.Checked == false)
            {
                CB_MotionSleepOn.Enabled        = true;
                CB_MotionSleepOnPrevent.Enabled = true;

                CB_MotionDisplayWakeup.Checked = false;
                CB_MotionDisplayWakeup.Enabled = false;
             
            }
        }

        private void RD_GSENSORON_CheckedChanged(object sender, EventArgs e)
        {
            m_GSensor_Params.GsensorEnable   = 1;
            CB_MotionDisplayOff.Enabled     = true;
            CB_MotionSleepOn.Enabled        = true;
            CB_MotionSleepOnPrevent.Enabled = true;
            CB_DisplayRotate.Enabled        = true;
        
        }

        private void RD_GSENSOROFF_CheckedChanged(object sender, EventArgs e)
        {
            m_GSensor_Params.GsensorEnable   = 0;
            CB_MotionDisplayOff.Enabled     = false;
            CB_MotionDisplayWakeup.Enabled  = false;
            CB_MotionSleepOn.Enabled        = false;
            CB_MotionSleepOnPrevent.Enabled = false;
            CB_DisplayRotate.Enabled        = false;

            CB_DisplayRotate.Checked        = false;
            CB_MotionDisplayOff.Checked     = false;
            CB_MotionDisplayWakeup.Checked  = false;
            CB_MotionSleepOn.Checked        = false;
            CB_MotionSleepOnPrevent.Checked = false;
        }

        private void OK_Click(object sender, EventArgs e)
        {
            m_GSensor_Params.MotionDisplayOff    = CB_MotionDisplayOff.Checked;
            m_GSensor_Params.MotionDisplayWakeup = CB_MotionDisplayWakeup.Checked;
            m_GSensor_Params.MotionSleepOn       = CB_MotionSleepOn.Checked;
            m_GSensor_Params.MotionSleepOnPrevent = CB_MotionSleepOnPrevent.Checked;
            m_GSensor_Params.DisplayRotate       = CB_DisplayRotate.Checked;
            
            m_System.SetGSensorValue(ref m_GSensor_Params);
            
            this.DialogResult = DialogResult.OK;
        }

        private void CANCEL_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }


      

    }
}