﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SystemNet;
using System.Runtime.InteropServices;

namespace SystemTestNet
{
    public partial class FBACKLIGHT : Form
    {
        private SystemNet.SystemNet m_System;

        public int nBacklightTimeout_Cur;
        public int nACBacklightTimeout_Cur;
        public int nBacklightlevel_Cur;
        public bool m_bLCDON;

        public int nPowerTimeout_Cur;
        public int nACPowerTimeout_Cur;

        public int PowerType;

        SystemNet.MODEL_TYPE m_DeviceInfo;
        [DllImport("coredll.dll")]
        public static extern bool SystemParametersInfo(uint uiAction, uint uiParam, StringBuilder pvParam, bool fWinIni);

        const int SPI_GETPLATFORMTYPE = 257;

        public FBACKLIGHT()
        {
            InitializeComponent();
            m_System = new SystemNet.SystemNet();
            m_DeviceInfo = m_System.GetDeviceInfo();
            m_bLCDON = false;

            if (m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3T || m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_Pos)  // M3T
                {
                    CB_BACKLIGHTTIMEOUT.Items.Add("NONE");
                    CB_BACKLIGHTTIMEOUT.Items.Add("10 Sec");
                    CB_BACKLIGHTTIMEOUT.Items.Add("30 Sec");
                    CB_BACKLIGHTTIMEOUT.Items.Add("1 Min");
                    CB_BACKLIGHTTIMEOUT.Items.Add("2 Min");
                    CB_BACKLIGHTTIMEOUT.Items.Add("5 Min");
                }
                else
                {
                    CB_BACKLIGHTTIMEOUT.Items.Add("NONE");
                    CB_BACKLIGHTTIMEOUT.Items.Add("10 Sec");
                    CB_BACKLIGHTTIMEOUT.Items.Add("30 Sec");
                    CB_BACKLIGHTTIMEOUT.Items.Add("1 Min");
                    CB_BACKLIGHTTIMEOUT.Items.Add("2 Min");
                    CB_BACKLIGHTTIMEOUT.Items.Add("3 Min");
                    CB_BACKLIGHTTIMEOUT.Items.Add("4 Min");
                    CB_BACKLIGHTTIMEOUT.Items.Add("5 Min");
                }

                if (m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3T || m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_Pos)
                {
                    CB_ACBACKLIGHTTIMEOUT.Items.Add("NONE");
                    CB_ACBACKLIGHTTIMEOUT.Items.Add("10 Sec");
                    CB_ACBACKLIGHTTIMEOUT.Items.Add("30 Sec");
                    CB_ACBACKLIGHTTIMEOUT.Items.Add("1 Min");
                    CB_ACBACKLIGHTTIMEOUT.Items.Add("2 Min");
                    CB_ACBACKLIGHTTIMEOUT.Items.Add("5 Min");
                    CB_ACBACKLIGHTTIMEOUT.Items.Add("10 Min");
                    CB_ACBACKLIGHTTIMEOUT.Items.Add("15 Min");
                    CB_ACBACKLIGHTTIMEOUT.Items.Add("30 Min");
                }
                else if (m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3SMARTCE || m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3ORANGEPLUS_CE || m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3UL10_CE || m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3BLACK_CE)
                {
                    CB_ACBACKLIGHTTIMEOUT.Items.Add("NONE");
                    CB_ACBACKLIGHTTIMEOUT.Items.Add("30 Sec");
                    CB_ACBACKLIGHTTIMEOUT.Items.Add("1 Min");
                    CB_ACBACKLIGHTTIMEOUT.Items.Add("2 Min");
                    CB_ACBACKLIGHTTIMEOUT.Items.Add("3 Min");
                    CB_ACBACKLIGHTTIMEOUT.Items.Add("4 Min");
                    CB_ACBACKLIGHTTIMEOUT.Items.Add("5 Min");
                    CB_ACBACKLIGHTTIMEOUT.Items.Add("10 Min");

                }
                else
                {
                    CB_ACBACKLIGHTTIMEOUT.Items.Add("NONE");
                    CB_ACBACKLIGHTTIMEOUT.Items.Add("1 Min");
                    CB_ACBACKLIGHTTIMEOUT.Items.Add("2 Min");
                    CB_ACBACKLIGHTTIMEOUT.Items.Add("3 Min");
                    CB_ACBACKLIGHTTIMEOUT.Items.Add("4 Min");
                    CB_ACBACKLIGHTTIMEOUT.Items.Add("5 Min");
                    CB_ACBACKLIGHTTIMEOUT.Items.Add("6 Min");
                    CB_ACBACKLIGHTTIMEOUT.Items.Add("7 Min");
                    CB_ACBACKLIGHTTIMEOUT.Items.Add("8 Min");
                    CB_ACBACKLIGHTTIMEOUT.Items.Add("9 Min");
                    CB_ACBACKLIGHTTIMEOUT.Items.Add("10 Min");
                }

                PowerType = 0; // Battery
                nBacklightTimeout_Cur = m_System.GetBackLightTimeOut(PowerType);
                CB_BACKLIGHTTIMEOUT.SelectedIndex = nBacklightTimeout_Cur;

                PowerType = 1; // AC
                nACBacklightTimeout_Cur = m_System.GetBackLightTimeOut(PowerType);
                CB_ACBACKLIGHTTIMEOUT.SelectedIndex = nACBacklightTimeout_Cur;
            
                nBacklightlevel_Cur = m_System.GetBacklightlevel();
                TB_BACKLIGHTLEVEL.Value = nBacklightlevel_Cur;


                if (m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3T)  // M3T
                {
                    TB_BACKLIGHTLEVEL.Maximum = 6;

                    switch (nBacklightlevel_Cur)
                    {
                        case 6:
                            LB_BACKLIGHTLEVEL.Text = "100%";
                            break;
                        case 5:
                            LB_BACKLIGHTLEVEL.Text = "90%";
                            break;
                        case 4:
                            LB_BACKLIGHTLEVEL.Text = "80%";
                            break;
                        case 3:
                            LB_BACKLIGHTLEVEL.Text = "60%";
                            break;
                        case 2:
                            LB_BACKLIGHTLEVEL.Text = "40%";
                            break;
                        case 1:
                            LB_BACKLIGHTLEVEL.Text = "20%";
                            break;
                        case 0:
                            LB_BACKLIGHTLEVEL.Text = "5%";
                            break;
                        default:
                            LB_BACKLIGHTLEVEL.Text = "5%";
                            break;
                    }
                }
                else
                {

                    TB_BACKLIGHTLEVEL.Maximum = 8;
                    switch (nBacklightlevel_Cur)
                    {
                        case 8:
                            LB_BACKLIGHTLEVEL.Text = "100%";
                            break;
                        case 7:
                            LB_BACKLIGHTLEVEL.Text = "90%";
                            break;
                        case 6:
                            LB_BACKLIGHTLEVEL.Text = "80%";
                            break;
                        case 5:
                            LB_BACKLIGHTLEVEL.Text = "70%";
                            break;
                        case 4:
                            LB_BACKLIGHTLEVEL.Text = "60%";
                            break;
                        case 3:
                            LB_BACKLIGHTLEVEL.Text = "40%";
                            break;
                        case 2:
                            LB_BACKLIGHTLEVEL.Text = "20%";
                            break;
                        case 1:
                            LB_BACKLIGHTLEVEL.Text = "10%";
                            break;
                        case 0:
                            LB_BACKLIGHTLEVEL.Text = "5%";
                            break;
                        default:
                            LB_BACKLIGHTLEVEL.Text = "5%";
                            break;
                    }
                }

                if (m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3T || m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_Pos || m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3BLACK_CE)
                {
                    CB_POWERTIMEOUT.Items.Add("NONE");
                    CB_POWERTIMEOUT.Items.Add("1 Min");
                    CB_POWERTIMEOUT.Items.Add("2 Min");
                    CB_POWERTIMEOUT.Items.Add("3 Min");
                    CB_POWERTIMEOUT.Items.Add("4 Min");
                    CB_POWERTIMEOUT.Items.Add("5 Min");
                    CB_POWERTIMEOUT.Items.Add("10 Min");
                    CB_POWERTIMEOUT.Items.Add("30 Min");
                }
                else
                {
                    CB_POWERTIMEOUT.Items.Add("NONE");
                    CB_POWERTIMEOUT.Items.Add("1 Min");
                    CB_POWERTIMEOUT.Items.Add("2 Min");
                    CB_POWERTIMEOUT.Items.Add("3 Min");
                    CB_POWERTIMEOUT.Items.Add("4 Min");
                    CB_POWERTIMEOUT.Items.Add("5 Min");
                }

                if (m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3SMARTCE || m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3ORANGEPLUS_CE || m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3UL10_CE)
                {
                    BN_BACKLIGHT_ON.Enabled = false;
                    //                BN_BACKLIGHT_OFF.Enabled = false;
                }


                PowerType = 0; // Battery
                nPowerTimeout_Cur = m_System.GetPowerTimeOut(PowerType);
                CB_POWERTIMEOUT.SelectedIndex = nPowerTimeout_Cur;

                PowerType = 1; // AC
                nACPowerTimeout_Cur = m_System.GetPowerTimeOut(PowerType);
                CB_ACPOWERTIMEOUT.SelectedIndex = nACPowerTimeout_Cur;



                StringBuilder sb = new StringBuilder();

                SystemParametersInfo(SPI_GETPLATFORMTYPE, 255, sb, false);

                if (sb.ToString().Trim() == "PocketPC" || sb.ToString().Trim() == "SmartPhone")
                {
                    MainMenu mainMenu = new MainMenu();

                    this.Menu = mainMenu;
                }
        }

        private void BN_BACKLIGHT_ON_Click(object sender, EventArgs e)
        {
            m_System.BacklightOn(true);
        }

        private void BN_BACKLIGHT_OFF_Click(object sender, EventArgs e)
        {
            m_System.BacklightOn(false);
            
        }

        private void CB_BACKLIGHTTIMEOUT_SelectedIndexChanged(object sender, EventArgs e)
        {

            int nBright;

            nBright = CB_BACKLIGHTTIMEOUT.SelectedIndex;
            PowerType = 0; // Battery
            if (nBright == 0)
                m_System.SetBackLightTimeOut(PowerType, false, nBright);
            else
                m_System.SetBackLightTimeOut(PowerType, true, nBright);
       }

        private void CB_ACBACKLIGHTTIMEOUT_SelectedIndexChanged(object sender, EventArgs e)
        {


            int nBright;

            nBright = CB_ACBACKLIGHTTIMEOUT.SelectedIndex;
            PowerType = 1; // AC
            if (nBright == 0)
                m_System.SetBackLightTimeOut(PowerType, false, nBright);
            else
                m_System.SetBackLightTimeOut(PowerType, true, nBright);
        }
        
        private void TB_BACKLIGHTLEVEL_ValueChanged(object sender, EventArgs e)
        {
        
                int nPos;
                nPos = TB_BACKLIGHTLEVEL.Value;


                if (m_DeviceInfo == SystemNet.MODEL_TYPE.DEVICE_M3T)  // M3T
                {
                    switch (nPos)
                    {
                        case 6:
                            LB_BACKLIGHTLEVEL.Text = "100%";
                            break;
                        case 5:
                            LB_BACKLIGHTLEVEL.Text = "90%";
                            break;
                        case 4:
                            LB_BACKLIGHTLEVEL.Text = "80%";
                            break;
                        case 3:
                            LB_BACKLIGHTLEVEL.Text = "60%";
                            break;
                        case 2:
                            LB_BACKLIGHTLEVEL.Text = "40%";
                            break;
                        case 1:
                            LB_BACKLIGHTLEVEL.Text = "20%";
                            break;
                        case 0:
                            LB_BACKLIGHTLEVEL.Text = "5%";
                            break;
                        default:
                            LB_BACKLIGHTLEVEL.Text = "5%";
                            break;
                    }
                }
                else
                {
                    switch (nPos)
                    {
                        case 8:
                            LB_BACKLIGHTLEVEL.Text = "100%";
                            break;
                        case 7:
                            LB_BACKLIGHTLEVEL.Text = "90%";
                            break;
                        case 6:
                            LB_BACKLIGHTLEVEL.Text = "80%";
                            break;
                        case 5:
                            LB_BACKLIGHTLEVEL.Text = "70%";
                            break;
                        case 4:
                            LB_BACKLIGHTLEVEL.Text = "60%";
                            break;
                        case 3:
                            LB_BACKLIGHTLEVEL.Text = "40%";
                            break;
                        case 2:
                            LB_BACKLIGHTLEVEL.Text = "20%";
                            break;
                        case 1:
                            LB_BACKLIGHTLEVEL.Text = "10%";
                            break;
                        case 0:
                            LB_BACKLIGHTLEVEL.Text = "5%";
                            break;
                        default:
                            LB_BACKLIGHTLEVEL.Text = "5%";
                            break;
                    }
                }

            m_System.SetBacklightlevel(nPos);
        
        }

        private void BN_SLEEP_Click(object sender, EventArgs e)
        {
            m_System.SetSleepMode();

        }

        private void CB_POWERTIMEOUT_SelectedIndexChanged(object sender, EventArgs e)
        {

            int nPower;
            PowerType = 0; // Battery

            nPower = CB_POWERTIMEOUT.SelectedIndex;
            m_System.SetPowerTimeOut(PowerType, nPower);

        }

        private void CB_ACPOWERTIMEOUT_SelectedIndexChanged(object sender, EventArgs e)
        {
            int nPower;
            PowerType = 1; // Ac

            nPower = CB_ACPOWERTIMEOUT.SelectedIndex;
            m_System.SetPowerTimeOut(PowerType, nPower);
        }

        private void BTN_LCD_Click(object sender, EventArgs e)
        {
        }

    }
}