
// The following ifdef block is the standard way of creating macros which make exporting 
// from a DLL simpler. All files within this DLL are compiled with the UTDLL_EXPORTS
// symbol defined on the command line. this symbol should not be defined on any project
// that uses this DLL. This way any other project whose source files include this file see 
// UTDLL_API functions as being imported from a DLL, wheras this DLL sees symbols
// defined with this macro as being exported.


#ifdef UNDER_CE
	#if UNDER_CE > 420
			#if _WIN32_WCE > 0x500
				#ifdef DEBUG
				  #pragma  message ("**** M3sky DEBUG compilation") 
				#else
				  #pragma  message ("**** M3sky REL compilation") 
				#endif
			#else
				#ifdef DEBUG
					#pragma  message ("**** M3PLUS DEBUG compilation") 
				#else
					#pragma  message ("**** M3PLUS REL compilation") 
				#endif
			#endif
	#else
		#ifdef ARMV4
			#ifdef DEBUG
			  #pragma  message ("**** ARMV4_PPC DEBUG compilation") 
			#else
			  #pragma  message ("**** ARMV4_PPC REL compilation") 
   			#endif
		#else
			#if _WIN32_WCE >= 0x600
				#ifdef DEBUG
				  #pragma  message ("**** MC31xx/MC91xx DEBUG compilation") 
				#else
				  #pragma  message ("**** MC31xx/MC91xx REL compilation") 
				#endif
			#else
				#ifdef DEBUG
				  #pragma  message ("**** M3 DEBUG compilation") 
				#else
				  #pragma  message ("**** M3 REL compilation") 
				#endif
			#endif
	    #endif
	#endif
#else
	#ifdef _DEBUG
		#pragma  message ("**** NT-PC DEBUG compilation") 
	#else
		#pragma  message ("**** NT-PC REL compilation") 
	#endif
#endif

#ifdef UTDLL_EXPORTS
	#define UTDLL_API __declspec(dllexport)
	#pragma  message ("**** UT DLL generation")
	#ifndef _AFXDLL
		#define _AFXDLL // prevent complaining of VS2005
	#endif
#else
  #ifndef UT_STATIC
   #define UTDLL_API __declspec(dllimport)
	#pragma  message ("**** UT DLL usage") 
  #else
   #define UTDLL_API 
	#pragma  message ("**** static UT library - link with static MFC library") 
  #endif
#endif

/////////////////////////////////////////////////////////////////////////
// This class is exported from the utdll.dll
class UTDLL_API CUtdll {
public:
	CUtdll(void);
	// TODO: add your methods here.
};

/////////////////////////////////////////////////////////////////////////

#define VC_EXTRALEAN		// Exclude rarely-used stuff from Windows headers

#if _WIN32_WCE < 0x600
	#define _CE_ALLOW_SINGLE_THREADED_OBJECTS_IN_MTA  // suppress complaining of VS
#endif

#define _CRT_SECURE_NO_DEPRECATE // suppress complaining of VS

#include <afxwin.h>         // MFC core and standard components
#include <afxext.h>         // MFC extensions

/////////////////////////////////////////////////////////////////////////////
// struct for dlgcall()

typedef struct 
{
	    int     dlgIDD;
		CDialog *dlg;
		int     dlgCancel;
		int     dlgOK;
}
DLGTAB;

/////////////////////////////////////////////////////////////////////////////
// defines & struct for parseINIFile()

#define INT_VAL    1
#define DOUBLE_VAL 2
#define STR_VAL    3
#define INT_LIST   4
#define STR_LIST   5

typedef struct {
       char * section;
       char * name;
	   char * defaultval;
	   char * variable;
	   int	vartyp;
} 
INICFG;

/////////////////////////////////////////////////////////////////////////////
// defines for chkfld(),  chkmod11(), chkean()

#define P_STAY 3  // same field without error tone
#define P_FLD 2
#define P_ERR 1
#define P_OK  0

#define M   0x01
                 /* ival with minimal number of digits */
#define FKT 0x02
				 /* call function (*chkfct)          */
#define FLD 0x04
				 /*	if okay, continue with *nxtfld   */
#define NUM 0x08
				 /* numerical input					 */
#define DEC 0x10
				/* ival with integer                              */
                /* 0x??0a  -> check for a digits after dec. point */       
                /* 0x??1a  -> check  and format to a digits after dec. point */       
				/* 0x?1??  -> do always                            */
				/* 0x?0??  -> do only when input exist             */
				/* 0xn???  -> format with n leading '0'            */

#define DAT 0x20
				 /* date TT.MM.JJJJ input		     			 */

#define TIM 0x40
				 /* time hh:mm input		     			 */

#define MAXVAL 0x80
				 /* maximum value for input field 				 */

// error Message ids

enum errmsg_ids {
		ERR_NBR_DIGITS =1,	// too short
		ERR_NUM, 			// not numeric
		ERR_LEN, 			// wrong length
		ERR_MAX_VAL, 		// greater than maximum value	
		ERR_DAT, 			// wrong date
		ERR_TIM, 			// wrong time
		ERR_DATLEN, 		// wrong length of date
		ERR_TIMLEN, 		// wrong length of time
		ERR_POINT, 			// errornous decimal point
		ERR_DEC,			// wrong decimal digits
		ERR_DIG,			// wrong number of digits after dec. point 
		ERR_USER,			// user error message
		ERR_FATAL,			// fatal error message
		ERR_HINT			// user hint message
};

typedef struct 
{
		int curfld;
		int chkbits;
		int (*chkfct) (CEdit* curfld, CEdit* &nxtfld, bool check_all);
		char * cval;
		int ival;
		int nxtfld;
}
PRFTAB;

/////////////////////////////////////////////////////////////////////////////
// defines & struct for fillSndBuf()

#define STR     0x01
#define STRN    0x02
#define LEFT0   0x04
#define LEFTB   0x08
#define RIGHT0  0x10
#define RIGHTB  0x20
#define KILLDEC 0x40

typedef struct 
{
	int sndbits;							/* kind of activity */
	int (*sndfct) (char * data, int len);	/* user function */
	char * data;							/* ptr to src data */
	int inlen;								/* input len */
	int outlen;								/* output len */
} SNDTAB;

/////////////////////////////////////////////////////////////////////////////
// function prototypes

UTDLL_API void utDlgCall(DLGTAB *tab1);

UTDLL_API int PWDkeys(HWND hWnd, unsigned char pwd[], int allkeys);

UTDLL_API void GetConfString(HANDLE pconf, char * section, char * sys, int len , char *def, char * ptab, int typ);
UTDLL_API bool parseINIFile(TCHAR * cfgfile, INICFG * inicfg); 
UTDLL_API bool writeINIFile(TCHAR * cfgfile, INICFG * inicfg);
UTDLL_API int PatchIniVars(INICFG * ncfg);
UTDLL_API bool utPatchIni(TCHAR * cfgfile, char * section, char * label, char * text);

UTDLL_API TCHAR * asc2uni(char * asc, TCHAR * uni);
UTDLL_API TCHAR * ascn2uni(char * asc, int len, TCHAR * uni);
UTDLL_API char* uni2asc(TCHAR *src,char *dest);
UTDLL_API char* uni2ascn(TCHAR *src, int len, char *dest);

UTDLL_API int proto (char * str);
UTDLL_API int proto_rpl (char * str);

UTDLL_API int chkmod11(char *szBuf);
UTDLL_API int chkmodean(char *szBuf);
UTDLL_API void warning(void);
UTDLL_API void ErrMsg(int ErrNum, char * ErrFld);

UTDLL_API long dtol(char * szDate);

UTDLL_API int fillSndBuf(char * szBuf, int len, SNDTAB * pt);

UTDLL_API char * ktrspc(char *buf);
UTDLL_API TCHAR * ktrwspc(TCHAR *buf);

UTDLL_API void lfill(char *buf, int len, char fill);

UTDLL_API void onupdfld(CEdit * pFld);

UTDLL_API void ToRight(int steps);

UTDLL_API void eye_stop(char* txt, char * title);       // display txt in Box with title, terminate program

#ifdef UNDER_CE
UTDLL_API char * __strupr(char *string);
#endif

UTDLL_API int __rename(char *old_name, char *new_name);				// return 0 if file renamed
UTDLL_API int __unlink (char * name);								// return always 0 (Error log in eyelog.txt)

UTDLL_API int EraseFile (TCHAR * name);								// return ERROR_SUCCESS if okay, else GetLastError()

UTDLL_API int search_first_file(char *search_file,char *found_file);    // return 0 if file found
UTDLL_API int search_next_file(char *found_file);                       // return 0 if file found

UTDLL_API int chkUtDLLVersion(char * vers);

#ifdef UNDER_CE
UTDLL_API int LaunchExe ( TCHAR * fname, TCHAR* par1, _SHELLEXECUTEINFO * se); // return 0 if failed
#else
UTDLL_API int LaunchExe ( TCHAR * fname, TCHAR* par1, SHELLEXECUTEINFO * se); // return 0 if failed
#endif


UTDLL_API bool GetRegStr(HKEY hKeyRoot, TCHAR* wszRegPath, TCHAR* wsaValue, TCHAR* wszRegString, int len);
UTDLL_API bool SetRegStr(HKEY hKeyRoot, TCHAR* wszRegPath, TCHAR* wszValue, TCHAR* wszData);
UTDLL_API bool GetRegDW (HKEY hKeyRoot, TCHAR* wszRegPath, TCHAR* wszValue, DWORD* &dwData);
UTDLL_API bool SetRegDW (HKEY hKeyRoot, TCHAR* wszRegPath, TCHAR* wszValue, DWORD dwData);
UTDLL_API bool SetRegMultiString(HKEY hKeyRoot, TCHAR *wszRegPath, TCHAR *wszValue, TCHAR* wszData, DWORD dwSize);
UTDLL_API bool SetRegBinary(HKEY hKeyRoot, TCHAR *wszRegPath, TCHAR *wszValue, BYTE*wszData, DWORD dwSize);


UTDLL_API TCHAR * GetCurPath(TCHAR * pathname);     // fill pathname with actual path and retrun pointer to it

UTDLL_API bool utFileExist(char* fname);            // Check if file fname exist; return true if file found
                                                    // uses SearchFirstFile() if fname with wildcards

UTDLL_API void utFakeKey(WORD vkey);                // fake key defined by virtual key code  vkey 

UTDLL_API bool utWarmBoot(void);                    // perform warm boot
UTDLL_API bool utColdBoot(void);                    // perform cold boot

UTDLL_API DWORD GetGUID(TCHAR* szwGUID);            // get unique hardware id; return 0 if ok
UTDLL_API DWORD GetGuidFormM3Plus(TCHAR* wszGUID);  // get unique hardware id for M3 plus; return 0 if ok

UTDLL_API void utGetLocalTime(SYSTEMTIME * mtime);  // get localtime with Milliseconds

UTDLL_API bool utisPPC(void);						// returns true, if running on PocketPC device (not WinCE)
UTDLL_API bool utisWinCe(void);						// returns true, if running on WinCE device (not Pocket PC)

UTDLL_API DWORD utmemfree(TCHAR * lpDirectoryName);  // free bytes on directory

UTDLL_API unsigned long utGetMagicNbr(unsigned char* szBuff, int iLenBuff, unsigned char* szUID, 
										int iLenUID, unsigned char* vers);
 // magic number of buffer with GUID and version

UTDLL_API bool utChkMagicNbr(unsigned long ulNr, unsigned char* szBuff, int iLenBuff, unsigned char* szUID, 
										int iLenUID, unsigned char* vers);
 // check ulNr against magic number of buffer with GUID and version

/////////////////////////////////////////////////////////////////////////////
// global variables

extern UTDLL_API char UTDLLVersion[];

extern UTDLL_API TCHAR rptfile[MAX_PATH];     // log file
extern UTDLL_API TCHAR beepFile[MAX_PATH];    // standard beep file _T("\\Windows\\be_be.wav");

extern UTDLL_API int nextDlg;
extern UTDLL_API int currDlg;

/////////////////////////////////////////////////////////////////////////////
