// VolumeDlg.cpp : implementation file
//

#include "stdafx.h"
#include "SystemTest.h"
#include "VolumeDlg.h"

#include "SystemTestDlg.h"


// CVolumeDlg dialog

IMPLEMENT_DYNAMIC(CVolumeDlg, CDialog)

CVolumeDlg::CVolumeDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CVolumeDlg::IDD, pParent)
{

}

CVolumeDlg::~CVolumeDlg()
{
}

void CVolumeDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_SLIDER_MAINVOLUME, m_ctlMainVolumeLevel);
	DDX_Control(pDX, IDC_SLIDER_PHONEVOLUME, m_ctlPhoneVolumeLevel);
	DDX_Control(pDX, IDC_STATIC_Phonevolume, m_staticPhoneVolumeLevel);
	DDX_Control(pDX, IDC_BTN_VIBRATEON, m_ctlVibrationOn);
	DDX_Control(pDX, IDC_BTN_VIBRATEOFF, m_ctlVibrationOff);

}


BEGIN_MESSAGE_MAP(CVolumeDlg, CDialog)
	ON_BN_CLICKED(IDC_BTN_VOLUMEMUTE, &CVolumeDlg::OnBnClickedBtnVolumemute)
	ON_BN_CLICKED(IDC_BTN_VIBRATEON, &CVolumeDlg::OnBnClickedBtnVibrateon)
	ON_BN_CLICKED(IDC_BTN_VIBRATEOFF, &CVolumeDlg::OnBnClickedBtnVibrateoff)
	ON_WM_VSCROLL()
END_MESSAGE_MAP()


// CVolumeDlg message handlers

BOOL CVolumeDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	
	DEVICE_INFO m_DeviceInfo = SYSTEM_GetDeviceInfo();
//	m_DeviceInfo = SYSTEM_GetDeviceInfo();

	if( (m_DeviceInfo == DEVICE_M3SMARTCE) || (m_DeviceInfo == DEVICE_M3ORANGEPLUS_CE) || (m_DeviceInfo == DEVICE_M3T) || (m_DeviceInfo == DEVICE_Pos) || (m_DeviceInfo == DEVICE_M3UL10_CE)  || (m_DeviceInfo == DEVICE_M3BLACK_CE) )
	{
		// Only for WinCE
		MoveWindow(0, 0, 240, 320);
	}

	DWORD dwVolumeLevel_Cur;
	DWORD dwPhoneVolumeLevel_Cur;

	if( (m_DeviceInfo == DEVICE_M3SMARTCE) || (m_DeviceInfo == DEVICE_M3ORANGEPLUS_CE) || (m_DeviceInfo == DEVICE_M3UL10_CE)  || (m_DeviceInfo == DEVICE_M3BLACK_CE) )
	{
		m_staticPhoneVolumeLevel.EnableWindow(FALSE);
		m_ctlPhoneVolumeLevel.EnableWindow(FALSE);
	}

	
	if(m_DeviceInfo == DEVICE_Pos)		//POS Vibration motor  
	{
		m_ctlVibrationOn.EnableWindow(FALSE);
		m_ctlVibrationOff.EnableWindow(FALSE);
	}

	if((m_DeviceInfo == DEVICE_M3T) || (m_DeviceInfo == DEVICE_Pos) )
	{
		m_ctlMainVolumeLevel.SetRange(0, 10);
		m_ctlMainVolumeLevel.SetTicFreq(1);
		dwVolumeLevel_Cur = SYSTEM_GetVolumeLevel();

		switch (dwVolumeLevel_Cur)
		{
		case 0:
			dwVolumeLevel_Cur = 10;
			break;
		case 1:
			dwVolumeLevel_Cur = 9;
			break;
		case 2:
			dwVolumeLevel_Cur = 8;
			break;
		case 3:
			dwVolumeLevel_Cur = 7;
			break;
		case 4:
			dwVolumeLevel_Cur = 6;
			break;
		case 5:
			dwVolumeLevel_Cur = 5;
			break;
		case 6:
			dwVolumeLevel_Cur = 4;
			break;
		case 7:
			dwVolumeLevel_Cur = 3;
			break;
		case 8:
			dwVolumeLevel_Cur = 2;
			break;
		case 9:
			dwVolumeLevel_Cur = 1;
			break;
		case 10:
			dwVolumeLevel_Cur = 0;
			break;
		default:
			dwVolumeLevel_Cur = 3;
			break;
		}

		m_ctlMainVolumeLevel.SetPos(dwVolumeLevel_Cur);
	}
	else if((m_DeviceInfo == DEVICE_M3SMARTCE) || (m_DeviceInfo == DEVICE_M3ORANGEPLUS_CE) || (m_DeviceInfo == DEVICE_M3UL10_CE)  || (m_DeviceInfo == DEVICE_M3BLACK_CE))
	{
		m_ctlMainVolumeLevel.SetRange(0, 6);
		m_ctlMainVolumeLevel.SetTicFreq(1);
		dwVolumeLevel_Cur = SYSTEM_GetVolumeLevel();

		switch (dwVolumeLevel_Cur)
		{
		case 0:
			dwVolumeLevel_Cur = 6;
			break;
		case 1:
			dwVolumeLevel_Cur = 5;
			break;
		case 2:
			dwVolumeLevel_Cur = 4;
			break;
		case 3:
			dwVolumeLevel_Cur = 3;
			break;
		case 4:
			dwVolumeLevel_Cur = 2;
			break;
		case 5:
			dwVolumeLevel_Cur = 1;
			break;
		case 6:
			dwVolumeLevel_Cur = 0;
			break;
		default:
			dwVolumeLevel_Cur = 3;
			break;
		}

		m_ctlMainVolumeLevel.SetPos(dwVolumeLevel_Cur);

	}
	else if(m_DeviceInfo == DEVICE_M3BLACK)
	{
		m_ctlMainVolumeLevel.SetRange(0, 5);
		m_ctlMainVolumeLevel.SetTicFreq(1);
		dwVolumeLevel_Cur = SYSTEM_GetVolumeLevel();

		m_ctlMainVolumeLevel.SetPos(dwVolumeLevel_Cur);
	}
	else
	{
		m_ctlMainVolumeLevel.SetRange(0, 5);
		m_ctlMainVolumeLevel.SetTicFreq(1);
		dwVolumeLevel_Cur = SYSTEM_GetVolumeLevel();

		switch (dwVolumeLevel_Cur)
		{
		case 0:
			dwVolumeLevel_Cur = 5;
			break;
		case 1:
			dwVolumeLevel_Cur = 4;
			break;
		case 2:
			dwVolumeLevel_Cur = 3;
			break;
		case 3:
			dwVolumeLevel_Cur = 2;
			break;
		case 4:
			dwVolumeLevel_Cur = 1;
			break;
		case 5:
			dwVolumeLevel_Cur = 0;
			break;
		default:
			dwVolumeLevel_Cur = 3;
			break;
		}

		m_ctlMainVolumeLevel.SetPos(dwVolumeLevel_Cur);
	}



	if( (m_DeviceInfo == DEVICE_M3T) || (m_DeviceInfo == DEVICE_Pos) || (m_DeviceInfo == DEVICE_M3ORANGEPLUS_CE) || (m_DeviceInfo == DEVICE_M3UL10_CE) || (m_DeviceInfo == DEVICE_M3BLACK_CE))
	{
		m_ctlPhoneVolumeLevel.EnableWindow(FALSE);
		m_staticPhoneVolumeLevel.EnableWindow(FALSE);
	}
	else
	{
		m_ctlPhoneVolumeLevel.SetRange(0, 5);
		m_ctlPhoneVolumeLevel.SetTicFreq(1);
		dwPhoneVolumeLevel_Cur = SYSTEM_GetPhoneVolumeLevel();
		m_ctlPhoneVolumeLevel.SetPos(dwPhoneVolumeLevel_Cur);
	} 
	
	

	UpdateData(FALSE);
	 
	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE}
}


void CVolumeDlg::OnBnClickedBtnVolumemute()
{

	DEVICE_INFO m_DeviceInfo = SYSTEM_GetDeviceInfo();

	if(m_DeviceInfo == DEVICE_M3T || m_DeviceInfo == DEVICE_Pos )
	{
		SYSTEM_SetVolumeLevel(10);
		m_ctlMainVolumeLevel.SetPos(10);
	}
	else if( (m_DeviceInfo == DEVICE_M3SMARTCE) || (m_DeviceInfo == DEVICE_M3ORANGEPLUS_CE) || (m_DeviceInfo == DEVICE_M3UL10_CE) || (m_DeviceInfo == DEVICE_M3BLACK_CE))
	{
		SYSTEM_SetVolumeLevel(6);
		m_ctlMainVolumeLevel.SetPos(6);
	}
	else if(m_DeviceInfo == DEVICE_M3BLACK)
	{
		SYSTEM_SetVolumeLevel(5);
		m_ctlMainVolumeLevel.SetPos(5);

		SYSTEM_SetPhoneVolumeLevel(5);										
		m_ctlPhoneVolumeLevel.SetPos(5);							
	}
	else
	{
		SYSTEM_SetVolumeLevel(5);
		m_ctlMainVolumeLevel.SetPos(5);

		SYSTEM_SetPhoneVolumeLevel(0);										
		m_ctlPhoneVolumeLevel.SetPos(5);							
	}

	SYSTEM_VolumeMute();
	UpdateData(FALSE);

}


void CVolumeDlg::OnBnClickedBtnVibrateon()
{
	SYSTEM_Vibrate(TRUE);

/*	
	GPRS_ENTRY entry;
	memset(&entry, 0x00, sizeof(GPRS_ENTRY));

//	wsprintf(entry.tzAPN, L"internet.telekom");
//	wsprintf(entry.tzUserName, L"t-mobile");
//	wsprintf(entry.tzPassword, L"tm");

	wsprintf(entry.tzAPN, L"web.sktelecom.com");
	wsprintf(entry.tzUserName, L"sktelecom");
//	wsprintf(entry.tzPassword, L"");

	SYSTEM_MakeGprsConnection(entry);
*/
}

void CVolumeDlg::OnBnClickedBtnVibrateoff()
{
	SYSTEM_Vibrate(FALSE);
}

void CVolumeDlg::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
	DWORD dwPos;	
	DEVICE_INFO m_DeviceInfo = SYSTEM_GetDeviceInfo();

	if(pScrollBar == (CScrollBar*)&m_ctlMainVolumeLevel)
	{
		dwPos = m_ctlMainVolumeLevel.GetPos();

		SYSTEM_SetVolumeLevel(dwPos);
	}

	else if(pScrollBar == (CScrollBar*)&m_ctlPhoneVolumeLevel)
	{
		dwPos = m_ctlPhoneVolumeLevel.GetPos();


		if(m_DeviceInfo == DEVICE_M3BLACK)
		{
			SYSTEM_SetPhoneVolumeLevel(dwPos);
		}
		else
		{
			switch (dwPos)
			{
			case 0:
				dwPos = 5;
				break;
			case 1:
				dwPos = 4;
				break;
			case 2:
				dwPos = 3;
				break;
			case 3:
				dwPos = 2;
				break;
			case 4:
				dwPos = 1;
				break;
			case 5:
				dwPos = 0;
				break;
			default:
				dwPos = 3;
				break;
			}

			SYSTEM_SetPhoneVolumeLevel(dwPos);
		}
	}

	
	UpdateData(FALSE);

	CDialog::OnVScroll(nSBCode, nPos, pScrollBar);
}
