// PowerCpuDlg.cpp : implementation file
//

#include "stdafx.h"
#include "SystemTest.h"
#include "PowerCpuDlg.h"

#include "SystemTestDlg.h"


// CPowerCpuDlg dialog

DEVICE_INFO m_DeviceInfo;

IMPLEMENT_DYNAMIC(CPowerCpuDlg, CDialog)

CPowerCpuDlg::CPowerCpuDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPowerCpuDlg::IDD, pParent)
	, m_bReboot(FALSE)
	, m_bWlanOn(FALSE)
	, m_bBluetoothOn(FALSE)
{

}

CPowerCpuDlg::~CPowerCpuDlg()
{

}

void CPowerCpuDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Radio(pDX, IDC_RADIO_REBOOT, m_bReboot);
	DDX_Radio(pDX, IDC_RADIO_WLANOFF, m_bWlanOn);
	DDX_Radio(pDX, IDC_RADIO_BLUETOOTHOFF, m_bBluetoothOn);
	DDX_Control(pDX, IDC_COMBO_CPUCLOCKSET, m_ctlCpuClock);
	DDX_Control(pDX, IDC_RADIO_BLUETOOTHON, m_ctrBTON);
	DDX_Control(pDX, IDC_RADIO_BLUETOOTHOFF, m_ctlBTOFF);
}


BEGIN_MESSAGE_MAP(CPowerCpuDlg, CDialog)
	ON_BN_CLICKED(IDC_BTN_BOOT, &CPowerCpuDlg::OnBnClickedBtnBoot)
	ON_BN_CLICKED(IDC_BTN_KEYPADLOCK, &CPowerCpuDlg::OnBnClickedBtnKeypadlock)
	ON_BN_CLICKED(IDC_BTN_KEYPADUNLOCK, &CPowerCpuDlg::OnBnClickedBtnKeypadunlock)
	ON_CBN_SELCHANGE(IDC_COMBO_CPUCLOCKSET, &CPowerCpuDlg::OnCbnSelchangeComboCpuclockset)
	ON_BN_CLICKED(IDC_RADIO_WLANON, &CPowerCpuDlg::OnBnClickedRadioWlanon)
	ON_BN_CLICKED(IDC_RADIO_WLANOFF, &CPowerCpuDlg::OnBnClickedRadioWlanoff)
	ON_BN_CLICKED(IDC_RADIO_BLUETOOTHON, &CPowerCpuDlg::OnBnClickedRadioBluetoothon)
	ON_BN_CLICKED(IDC_RADIO_BLUETOOTHOFF, &CPowerCpuDlg::OnBnClickedRadioBluetoothoff)
END_MESSAGE_MAP()


// CPowerCpuDlg message handlers

BOOL CPowerCpuDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	m_DeviceInfo = SYSTEM_GetDeviceInfo();

	if( (m_DeviceInfo == DEVICE_M3SMARTCE) || (m_DeviceInfo == DEVICE_M3ORANGEPLUS_CE) || (m_DeviceInfo == DEVICE_M3T) || (m_DeviceInfo == DEVICE_Pos) || (m_DeviceInfo == DEVICE_M3UL10_CE) || (m_DeviceInfo == DEVICE_M3BLACK_CE))
	{
		// Only for WinCE
		MoveWindow(0, 0, 240, 320);
		// IDC_RADIO_BLUETOOTHON

		m_ctrBTON.EnableWindow(FALSE);
		m_ctlBTOFF.EnableWindow(FALSE);
	
	}

	if(m_DeviceInfo == DEVICE_M3SMARTCE || m_DeviceInfo == DEVICE_M3SMARTWM || m_DeviceInfo == DEVICE_M3ORANGEPLUS_CE || m_DeviceInfo == DEVICE_M3ORANGEPLUS_WM || m_DeviceInfo == DEVICE_MM3 || m_DeviceInfo == DEVICE_M3UL10_CE )
	{
		m_ctlCpuClock.EnableWindow(FALSE);
	}

	if(m_DeviceInfo == DEVICE_M3SKYSAM)
	{
//		m_ctrlBtn_Wlan.EnableWindow(FALSE);
	}

	switch(m_DeviceInfo)
	{
	case DEVICE_MM3:			
	case DEVICE_M3ORANGEPLUS_CE:				
	case DEVICE_M3ORANGEPLUS_WM:			
	case DEVICE_M3SMARTWM:
	case DEVICE_M3SMARTCE:
	case DEVICE_M3UL10_CE:
		break;
	case DEVICE_M3ORANGE:
		M3Orange_Init();
		break;
	case DEVICE_M3SKY:
	case DEVICE_M3SKYSAM:
		M3Sky_Init();
		break;
	case DEVICE_M3T:
		M3T_Init();
		break;
	case DEVICE_Pos:
		Pos_Init();
		break;
	case DEVICE_M3BLACK:
	case DEVICE_M3BLACK_CE:
		M3Black_Init();
		break;
	}

	//Reboot
	m_bReboot		= FALSE;

	//Radio
	m_bWlanOn		= SYSTEM_GetWlan();
	m_bBluetoothOn	= SYSTEM_GetBluetooth();

	UpdateData(FALSE);
	UpdateData(TRUE);

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}


void CPowerCpuDlg::OnBnClickedBtnBoot()
{
	UpdateData(TRUE);

	SYSTEM_Cleanboot(m_bReboot);
	SYSTEM_Reboot();
}

void CPowerCpuDlg::OnBnClickedBtnKeypadlock()
{
	SYSTEM_KeypadLock(FALSE);
}

void CPowerCpuDlg::OnBnClickedBtnKeypadunlock()
{
	SYSTEM_KeypadLock(TRUE);
}


void CPowerCpuDlg::OnCbnSelchangeComboCpuclockset()
{
	DWORD	dwCurSel;
	dwCurSel = m_ctlCpuClock.GetCurSel();

	switch(m_DeviceInfo)
	{
	case DEVICE_M3ORANGEPLUS_CE:						
	case DEVICE_M3ORANGEPLUS_WM:						
	case DEVICE_M3SMARTWM:
	case DEVICE_MM3:
	case DEVICE_M3UL10_CE:
		break;
	case DEVICE_M3SKY:
	case DEVICE_M3SKYSAM:
		M3Sky_SetCpuClock(dwCurSel);
		break;
	case DEVICE_M3T:
		M3T_SetCpuClock(dwCurSel);		
		break;
	case DEVICE_Pos:
		Pos_SetCpuClock(dwCurSel);
		break;
	case DEVICE_M3ORANGE:							
		M3Orange_SetCpuClock(dwCurSel);
		break;
	case DEVICE_M3BLACK:
	case DEVICE_M3BLACK_CE:
		M3Black_SetCpuClock(dwCurSel);
		break;
	}
}

void CPowerCpuDlg::M3Black_SetCpuClock(DWORD dwCurSel)
{
	switch(dwCurSel)
	{
	case 0:
		SYSTEM_SetCpuClock(M3BLACK_300MHz); 
		break;
	case 1:
		SYSTEM_SetCpuClock(M3BLACK_600MHz); 
		break;
	case 2:
		SYSTEM_SetCpuClock(M3BLACK_800MHz); 
		break;
	case 3:
		SYSTEM_SetCpuClock(M3BLACK_1000MHz);
		break;
	default:
		SYSTEM_SetCpuClock(M3BLACK_1000MHz);
		break;
	}
}



void CPowerCpuDlg::M3Black_Init(void)
{
	m_ctlCpuClock.InsertString(0, L"300MHz");
	m_ctlCpuClock.InsertString(1, L"600MHz");
	m_ctlCpuClock.InsertString(2, L"800MHz");
	m_ctlCpuClock.InsertString(3, L"1000MHz");

	nCurClock = SYSTEM_GetCpuClock(&dwCpuClock);

	switch(nCurClock)
	{
	case 0:
		m_ctlCpuClock.SetCurSel(M3BLACK_300MHz);
		break;
	case 1:
		m_ctlCpuClock.SetCurSel(M3BLACK_600MHz);
		break;
	case 2:
		m_ctlCpuClock.SetCurSel(M3BLACK_800MHz);
		break;
	case 3:
		m_ctlCpuClock.SetCurSel(M3BLACK_1000MHz);
		break;
	default:
		m_ctlCpuClock.SetCurSel(M3BLACK_1000MHz);
		break;
	}
}

void CPowerCpuDlg::M3T_Init(void)
{
	m_ctlCpuClock.InsertString(0, L"208MHz");
	m_ctlCpuClock.InsertString(1, L"416MHz");
	m_ctlCpuClock.InsertString(2, L"624MHz");
	m_ctlCpuClock.InsertString(3, L"806MHz");

	nCurClock = SYSTEM_GetCpuClock(&dwCpuClock);

	switch(nCurClock)
	{
	case 0:
		m_ctlCpuClock.SetCurSel(M3T_208MHz);
		break;
	case 1:
		m_ctlCpuClock.SetCurSel(M3T_416MHz);
		break;
	case 2:
		m_ctlCpuClock.SetCurSel(M3T_624MHz);
		break;
	case 3:
		m_ctlCpuClock.SetCurSel(M3T_806MHz);
		break;
	default:
		m_ctlCpuClock.SetCurSel(M3T_806MHz);
		break;
	}
}

void CPowerCpuDlg::Pos_Init(void)
{
	m_ctlCpuClock.InsertString(0, L"312MHz");
	m_ctlCpuClock.InsertString(1, L"416MHz");
	m_ctlCpuClock.InsertString(2, L"624MHz");
	m_ctlCpuClock.InsertString(3, L"806MHz");

	nCurClock = SYSTEM_GetCpuClock(&dwCpuClock);

	switch(nCurClock)
	{
	case 0:
		m_ctlCpuClock.SetCurSel(POS_208MHz);
		break;
	case 1:
		m_ctlCpuClock.SetCurSel(POS_416MHz);
		break;
	case 2:
		m_ctlCpuClock.SetCurSel(POS_624MHz);
		break;
	case 3:
		m_ctlCpuClock.SetCurSel(POS_806MHz);
		break;
	default:
		m_ctlCpuClock.SetCurSel(POS_806MHz);
		break;
	}
}



void CPowerCpuDlg::M3Orange_Init(void)
{
	m_ctlCpuClock.InsertString(0, L"208MHz");
	m_ctlCpuClock.InsertString(1, L"416MHz");
	m_ctlCpuClock.InsertString(2, L"624MHz");
	m_ctlCpuClock.InsertString(3, L"806MHz");

	nCurClock = SYSTEM_GetCpuClock(&dwCpuClock);

	switch(nCurClock)
	{
	case 0:
		m_ctlCpuClock.SetCurSel(ORANGE_208MHz);
		break;
	case 1:
		m_ctlCpuClock.SetCurSel(ORANGE_416MHz);
		break;
	case 2:
		m_ctlCpuClock.SetCurSel(ORANGE_624MHz);
		break;
	case 3:
		m_ctlCpuClock.SetCurSel(ORANGE_806MHz);
		break;
	default:
		m_ctlCpuClock.SetCurSel(ORANGE_806MHz);
		break;
	}
}



void CPowerCpuDlg::M3Sky_Init(void)
{
	m_ctlCpuClock.InsertString(0, L"208MHz");
	m_ctlCpuClock.InsertString(1, L"312MHz");
	m_ctlCpuClock.InsertString(2, L"416MHz");
	m_ctlCpuClock.InsertString(3, L"520MHz");
	m_ctlCpuClock.InsertString(4, L"624MHz");
	m_ctlCpuClock.InsertString(5, L"Release");

	nCurClock = SYSTEM_GetCpuClock(&dwCpuClock);

	switch(dwCpuClock)
	{
	case 4:
		m_ctlCpuClock.SetCurSel(SKY_624MHz);
		break;
	case 3:
		m_ctlCpuClock.SetCurSel(SKY_520MHz);
		break;
	case 2:
		m_ctlCpuClock.SetCurSel(SKY_416MHz);
		break;
	case 1:
		m_ctlCpuClock.SetCurSel(SKY_312MHz);
		break;
	case 0:
		m_ctlCpuClock.SetCurSel(SKY_208MHz);
		break;
	default:
		m_ctlCpuClock.SetCurSel(SKY_624MHz);
		break;
	}
}



void CPowerCpuDlg::OnBnClickedRadioWlanon()
{
	if(SYSTEM_GetWlan() == TRUE)
	{
		::MessageBox(this->m_hWnd, L"WLAN On!", L"", NULL);
	}
	else
	{
		BeginWaitCursor();

		SYSTEM_SetWlan(TRUE);
		Sleep(2000);

		::MessageBox(this->m_hWnd, L"WLAN On!", L"", NULL);

		UpdateData(true);
		UpdateData(false);
		EndWaitCursor();
	}

}

void CPowerCpuDlg::OnBnClickedRadioWlanoff()
{
	if(SYSTEM_GetWlan() == TRUE)
	{
		BeginWaitCursor();

		SYSTEM_SetWlan(FALSE);
		Sleep(2000);
		::MessageBox(this->m_hWnd, L"WLAN Off!", L"", NULL);


		UpdateData(true);
		UpdateData(false);
		EndWaitCursor();

	}
	else
	{
			::MessageBox(this->m_hWnd, L"WLAN Off!", L"", NULL);
	}
	
}

void CPowerCpuDlg::OnBnClickedRadioBluetoothon()
{

	//Bluetooth
	if(SYSTEM_GetBluetooth() == TRUE)
	{
		::MessageBox(this->m_hWnd, L"BT On!", L"", NULL);
	}
	else
	{
		BeginWaitCursor();
		
		SYSTEM_SetBluetooth(TRUE);

		Sleep(2000);
		MessageBox(L"BT On!", NULL, NULL);

		EndWaitCursor();
	}
}

void CPowerCpuDlg::OnBnClickedRadioBluetoothoff()
{

	if(SYSTEM_GetBluetooth() == TRUE)
	{
		BeginWaitCursor();
	
		SYSTEM_SetBluetooth(FALSE);

		Sleep(2000);
		::MessageBox(this->m_hWnd, L"BT Off!", L"", NULL);	

		UpdateData(true);
		UpdateData(false);

		EndWaitCursor();
	}
	else
	{
		::MessageBox(this->m_hWnd, L"BT Off!", L"", NULL);	
	}

}


void CPowerCpuDlg::M3Orange_SetCpuClock(DWORD dwCurSel)
{
	switch(dwCurSel)
	{
	case 0:
		SYSTEM_SetCpuClock(ORANGE_208MHz);
		break;
	case 1:
		SYSTEM_SetCpuClock(ORANGE_416MHz);
		break;
	case 2:
		SYSTEM_SetCpuClock(ORANGE_624MHz);
		break;
	case 3:
		SYSTEM_SetCpuClock(ORANGE_806MHz);
		break;
	default:
		SYSTEM_SetCpuClock(ORANGE_208MHz);
		break;
	}
}

void CPowerCpuDlg::M3Sky_SetCpuClock(DWORD dwCurSel)
{
	switch(dwCurSel)
	{
	case 0:
		SYSTEM_SetCpuClock(SKY_208MHz);
		break;
	case 1:
		SYSTEM_SetCpuClock(SKY_312MHz);
		break;
	case 2:
		SYSTEM_SetCpuClock(SKY_416MHz);
		break;
	case 3:
		SYSTEM_SetCpuClock(SKY_520MHz);
		break;
	case 4:
		SYSTEM_SetCpuClock(SKY_624MHz);
		break;
	case 5:
		SYSTEM_SetCpuClock(SKY_208MHz);
		break;
	default:
		SYSTEM_SetCpuClock(SKY_208MHz);
		break;
	}
}


void CPowerCpuDlg::M3T_SetCpuClock(DWORD dwCurSel)
{
	switch(dwCurSel)
	{
	case 0:
		SYSTEM_SetCpuClock(M3T_208MHz);
		break;
	case 1:
		SYSTEM_SetCpuClock(M3T_416MHz);
		break;
	case 2:
		SYSTEM_SetCpuClock(M3T_624MHz);
		break;
	case 3:
		SYSTEM_SetCpuClock(M3T_806MHz);
		break;
	default:
		SYSTEM_SetCpuClock(M3T_208MHz);
		break;
	}
}


void CPowerCpuDlg::Pos_SetCpuClock(DWORD dwCurSel)
{
	switch(dwCurSel)
	{
	case 0:
		SYSTEM_SetCpuClock(POS_208MHz);
		break;
	case 1:
		SYSTEM_SetCpuClock(POS_416MHz);
		break;
	case 2:
		SYSTEM_SetCpuClock(POS_624MHz);
		break;
	case 3:
		SYSTEM_SetCpuClock(POS_806MHz);
		break;
	default:
		SYSTEM_SetCpuClock(POS_208MHz);
		break;
	}
}

