// Gsensor.cpp : implementation file
//

#include "stdafx.h"
#include "SystemTest.h"
#include "Gsensor.h"
#include "SystemTestDlg.h"


// CGsensor dialog

IMPLEMENT_DYNAMIC(CGsensor, CDialog)

CGsensor::CGsensor(CWnd* pParent /*=NULL*/)
	: CDialog(CGsensor::IDD, pParent)
	, m_nGsensorMode(0)
	,m_bBacklight_OFF(FALSE)
	,m_bBacklight_ON(FALSE)
	,m_bPOWER_OFF(FALSE)
	,m_bMotionSleepOnPrevent(FALSE)
	,m_bDisplay_Rotate(FALSE)

{

}

CGsensor::~CGsensor()
{
}

void CGsensor::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Radio(pDX, IDC_Gsensor_OFF, m_nGsensorMode);
	DDX_Check(pDX, IDC_BACKLIGHT_OFF, m_bBacklight_OFF);
	DDX_Check(pDX, IDC_BACKLIGHT_ON, m_bBacklight_ON);
	DDX_Check(pDX, IDC_POWER_OFF, m_bPOWER_OFF);
	DDX_Check(pDX, IDC_MotionSleepOnPrevent, m_bMotionSleepOnPrevent);
	DDX_Check(pDX, IDC_Display_Rotate, m_bDisplay_Rotate);

	

	DDX_Control(pDX, IDC_Gsensor_OFF, m_ctlBtnGsensorMode);
	DDX_Control(pDX, IDC_BACKLIGHT_OFF, m_ctlBtnBacklight_OFF);
	DDX_Control(pDX, IDC_BACKLIGHT_ON, m_ctlBtnBacklight_ON);
	DDX_Control(pDX, IDC_POWER_OFF, m_ctlBtnPOWER_OFF);
	DDX_Control(pDX, IDC_MotionSleepOnPrevent, m_ctlBtnMotionSleepOnPrevent);
	DDX_Control(pDX, IDC_Display_Rotate, m_ctlBtnDisplay_Rotate);

}


BEGIN_MESSAGE_MAP(CGsensor, CDialog)

	ON_BN_CLICKED(IDC_BACKLIGHT_OFF, &CGsensor::OnBnClickedBacklightOff)
	ON_BN_CLICKED(IDC_Gsensor_ON, &CGsensor::OnBnClickedGsensorOn)
	ON_BN_CLICKED(IDC_Gsensor_OFF, &CGsensor::OnBnClickedGsensorOff)
	ON_BN_CLICKED(IDC_BACKLIGHT_ON, &CGsensor::OnBnClickedBacklightOn)
	ON_BN_CLICKED(IDC_POWER_OFF, &CGsensor::OnBnClickedPowerOff)
	ON_BN_CLICKED(IDC_Display_Rotate, &CGsensor::OnBnClickedDisplayRotate)
	ON_BN_CLICKED(IDC_MotionSleepOnPrevent, &CGsensor::OnBnClickedMotionsleeponprevent)
END_MESSAGE_MAP()




BOOL CGsensor::OnInitDialog()
{
	CDialog::OnInitDialog();
	// TODO:  Add extra initialization here
		HKEY	hKey=NULL;
		DWORD	dwType=0, dwsize=1;
		DWORD result=0;

		PGSensor_PARAMS pgSensor = new GSensor_PARAMS();


		if( SYSTEM_GetGSensorValue(pgSensor))
		{
		
		}
		else
		{
			MessageBox(L"Gsenor Open Error", NULL, NULL);
			return false;
		}

		m_nGsensorMode = pgSensor->GsensorEnable;
		m_bBacklight_OFF = pgSensor->MotionDisplayOff;
		m_bBacklight_ON = pgSensor->MotionDisplayWakeup;
		m_bPOWER_OFF = pgSensor->MotionSleepOn;
		m_bMotionSleepOnPrevent = pgSensor->MotionSleepOnPrevent;
		m_bDisplay_Rotate = pgSensor->DisplayRotate;

		if(m_nGsensorMode == 0)
		{
			m_ctlBtnBacklight_OFF.EnableWindow(false);
			m_ctlBtnBacklight_ON.EnableWindow(false);
			m_ctlBtnPOWER_OFF.EnableWindow(false);
			m_ctlBtnMotionSleepOnPrevent.EnableWindow(false);
			m_ctlBtnDisplay_Rotate.EnableWindow(false);
		}
		else
		{
			m_ctlBtnBacklight_ON.EnableWindow(false);

			if(m_bBacklight_OFF == 1)
			{
				m_ctlBtnBacklight_ON.EnableWindow(true);
				m_ctlBtnPOWER_OFF.EnableWindow(false);
				m_ctlBtnMotionSleepOnPrevent.EnableWindow(false);
			}
			
			if(m_bPOWER_OFF == 1 )
			{
				m_ctlBtnBacklight_OFF.EnableWindow(false);
			}
			
			if(m_bMotionSleepOnPrevent == 1)
			{
				m_ctlBtnBacklight_OFF.EnableWindow(false);
			}

		}

		::RegCloseKey(hKey);

	UpdateData(FALSE);
	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CGsensor::OnBnClickedBacklightOff()
{
	// TODO: Add your control notification handler code here
		UpdateData(true);
	
		if( m_bBacklight_OFF == 0)
		{
			m_ctlBtnPOWER_OFF.EnableWindow(true);
			m_ctlBtnMotionSleepOnPrevent.EnableWindow(true);
			m_ctlBtnBacklight_ON.EnableWindow(false);
			m_bBacklight_ON =0;

		}
		else
		{
			m_ctlBtnPOWER_OFF.EnableWindow(false);
			m_ctlBtnMotionSleepOnPrevent.EnableWindow(false);
			m_ctlBtnBacklight_ON.EnableWindow(true);
		}

		Set_GsensorDate();
		UpdateData(false);

}

void CGsensor::OnBnClickedGsensorOff()
{
	// TODO: Add your control notification handler code here
	m_ctlBtnBacklight_OFF.EnableWindow(false);
	m_ctlBtnBacklight_ON.EnableWindow(false);
	m_ctlBtnPOWER_OFF.EnableWindow(false);
	m_ctlBtnMotionSleepOnPrevent.EnableWindow(false);
	m_ctlBtnDisplay_Rotate.EnableWindow(false);
	UpdateData(true);


	m_bBacklight_OFF = 0;
	m_bBacklight_ON = 0;
	m_bPOWER_OFF = 0;
	m_bMotionSleepOnPrevent = 0;
	m_bDisplay_Rotate = 0;

	Set_GsensorDate();
	UpdateData(false);
}
void CGsensor::OnBnClickedGsensorOn()
{
	// TODO: Add your control notification handler code here
	m_ctlBtnBacklight_OFF.EnableWindow(true);
	m_ctlBtnBacklight_ON.EnableWindow(false);
	m_ctlBtnPOWER_OFF.EnableWindow(true);
	m_ctlBtnMotionSleepOnPrevent.EnableWindow(true);
	m_ctlBtnDisplay_Rotate.EnableWindow(true);

	UpdateData(true);
	Set_GsensorDate();
}

void CGsensor::OnBnClickedBacklightOn()
{
	// TODO: Add your control notification handler code here
	UpdateData(true);
	Set_GsensorDate();
}



void CGsensor::OnBnClickedDisplayRotate()
{
	// TODO: Add your control notification handler code here
	UpdateData(true);
	Set_GsensorDate();
}

void CGsensor::OnBnClickedMotionsleeponprevent()
{
	// TODO: Add your control notification handler code here
	OnEnableWindows();
	Set_GsensorDate();
}


void CGsensor::OnBnClickedPowerOff()
{
	// TODO: Add your control notification handler code here
	OnEnableWindows();
	Set_GsensorDate();
}

void CGsensor::OnEnableWindows()
{
	UpdateData(true);
	m_ctlBtnBacklight_OFF.EnableWindow(false);
	m_ctlBtnBacklight_ON.EnableWindow(false);


	if( m_bMotionSleepOnPrevent ==0 && m_bPOWER_OFF == 0)
	{
		m_ctlBtnBacklight_OFF.EnableWindow(true);
	}

}

void CGsensor::Set_GsensorDate()
{
	PGSensor_PARAMS pgSensor = new GSensor_PARAMS();

	pgSensor->GsensorEnable = m_nGsensorMode;
	pgSensor->MotionDisplayOff = m_bBacklight_OFF;
	pgSensor->MotionDisplayWakeup = m_bBacklight_ON;
	pgSensor->MotionSleepOn = m_bPOWER_OFF;
	pgSensor->MotionSleepOnPrevent = m_bMotionSleepOnPrevent;
	pgSensor->DisplayRotate = m_bDisplay_Rotate;

	if( SYSTEM_SetGSensorValue(pgSensor)==FALSE)
	{
		MessageBox(L"Error : SYSTEM_SetGSensorValue()", NULL, NULL);
	}
}
