// CurrentStatus.cpp : implementation file
//

#include "stdafx.h"
#include "SystemTest.h"
#include "CurrentStatus.h"

#include "SystemTestDlg.h"

// CCurrentStatus dialog

IMPLEMENT_DYNAMIC(CCurrentStatus, CDialog)

CCurrentStatus::CCurrentStatus(CWnd* pParent /*=NULL*/)
	: CDialog(CCurrentStatus::IDD, pParent)
	, m_strSerial(_T(""))
	, m_strWlan(_T(""))
	, m_strBluetooth(_T(""))
	, m_strBatteryStatus(_T(""))
	, m_strCpuClock(_T(""))
	, m_strBatteryLife(_T(""))
	, m_strGuid(_T(""))
{

}

CCurrentStatus::~CCurrentStatus()
{
}

void CCurrentStatus::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_STATIC_SERIAL, m_strSerial);
	DDX_Text(pDX, IDC_STATIC_WLAN, m_strWlan);
	DDX_Text(pDX, IDC_STATIC_WLAN2, m_strBluetooth);
	DDX_Text(pDX, IDC_STATIC_BATTERYSTATUS, m_strBatteryStatus);
	DDX_Text(pDX, IDC_STATIC_WLAN3, m_strCpuClock);
	DDX_Text(pDX, IDC_STATIC_BATTERYLIFE, m_strBatteryLife);
	DDX_Text(pDX, IDC_STATIC_GUID, m_strGuid);
	DDX_Text(pDX, IDC_STATIC_OSVersion, m_strOSversion);
	
}


BEGIN_MESSAGE_MAP(CCurrentStatus, CDialog)
END_MESSAGE_MAP()


// CCurrentStatus message handlers

BOOL CCurrentStatus::OnInitDialog()
{
	
	DEVICE_INFO m_DeviceInfo = (DEVICE_INFO)SYSTEM_GetDeviceInfo();
	


	if((m_DeviceInfo == DEVICE_M3SMARTCE) || (m_DeviceInfo == DEVICE_M3ORANGEPLUS_CE) ||(m_DeviceInfo == DEVICE_M3T) || (m_DeviceInfo == DEVICE_Pos) || (m_DeviceInfo == DEVICE_Pos) || (m_DeviceInfo == DEVICE_M3UL10_CE)  || (m_DeviceInfo == DEVICE_M3BLACK_CE) )
	{
		// Only for WinCE
		MoveWindow(0, 0, 240, 320);
	}

	TCHAR strSerial[1024] = {0,};
	//Serial Number
	SYSTEM_GetSerialNumber(strSerial);
	m_strSerial.Format(L"Serial Number : %s", strSerial);

	//GUID
	TCHAR strGUID[1024] = {0,};
	SYSTEM_GetGUID(strGUID);
	if((m_DeviceInfo == DEVICE_M3SMARTCE) || (m_DeviceInfo == DEVICE_MM3) || (m_DeviceInfo == DEVICE_M3SKY) || (m_DeviceInfo == DEVICE_M3SKYSAM) || (m_DeviceInfo == DEVICE_M3ORANGE) ||(m_DeviceInfo == DEVICE_M3T)|| (m_DeviceInfo == DEVICE_Pos) )
	{
		m_strGuid.Format(L"GUID  : %s", strGUID);
	}
	else
	{
		m_strGuid.Format(L"UUID  : %s", strGUID);
	}
	//WLAN
	if(SYSTEM_GetWlan() == TRUE)
		m_strWlan.Format(L"WLAN : ON");
	else
		m_strWlan.Format(L"WLAN : OFF");


	if((m_DeviceInfo == DEVICE_M3SMARTCE) || (m_DeviceInfo == DEVICE_M3ORANGEPLUS_CE) ||(m_DeviceInfo == DEVICE_M3T)|| (m_DeviceInfo == DEVICE_Pos) || (m_DeviceInfo == DEVICE_M3UL10_CE) )
	{
		m_strBluetooth.Format(L"Bluetooth : N/A");
	}
	else
	{
		//Bluetooth
		if(SYSTEM_GetBluetooth() == TRUE)
			m_strBluetooth.Format(L"Bluetooth : ON");
		else
			m_strBluetooth.Format(L"Bluetooth : OFF");
	}

	//OS Version
	TCHAR strOSVersion[1024] = {0,};
	if(SYSTEM_GetOSVersionInfo(strOSVersion))
	{
		m_strOSversion.Format(L"OS Version : %s",strOSVersion);
	}
	

	//CpuClock
	m_DeviceInfo = SYSTEM_GetDeviceInfo();
	switch(m_DeviceInfo)
	{
		case DEVICE_M3UL10_CE:
		case DEVICE_M3ORANGEPLUS_CE:
		case DEVICE_M3ORANGEPLUS_WM:
		case DEVICE_MM3:
		case DEVICE_M3SMARTCE:
			m_strCpuClock.Format(L"CPU Clock : N/A");
			break;
		case DEVICE_M3SKY: 
		case DEVICE_M3SKYSAM: 
			M3Sky_GetCpu();
			break;
		case DEVICE_M3ORANGE: 
			M3Orange_GetCpu();
			break;
		case DEVICE_M3T: 
			M3T_GetCpu();
			break;
		case DEVICE_Pos:	
			Pos_GetCpu();
			break;
		case DEVICE_M3BLACK_CE: 
		case DEVICE_M3BLACK: 
			M3Black_GetCpu();
			break;
		default:
			m_strCpuClock.Format(L"CPU Clock : N/A");
			break;
	}

	//Battery Status
	if(SYSTEM_GetBatteryState() == TRUE)
		m_strBatteryStatus.Format(L"Power : AC Power");
	else
		m_strBatteryStatus.Format(L"Power : Battery Power");

	//Battery Life
 	int bBatteryLife;
 	bBatteryLife = SYSTEM_GetBatteryLifePercent();
 	m_strBatteryLife.Format(L"Battery Life : %d%%", bBatteryLife);

	UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}



void CCurrentStatus::M3Sky_GetCpu()
{
	nCurClock = SYSTEM_GetCpuClock(&dwCpuClock);

	switch (dwCpuClock)
	{
	case SKY_208MHz:
		m_strCpuClock.Format(L"CPU Clock : 208MHz");
		break;
	case SKY_312MHz:
		m_strCpuClock.Format(L"CPU Clock : 312MHz");
		break;
	case SKY_416MHz:
		m_strCpuClock.Format(L"CPU Clock : 416MHz");
		break;
	case SKY_520MHz:
		m_strCpuClock.Format(L"CPU Clock : 520MHz");
		break;
	case SKY_624MHz:
		m_strCpuClock.Format(L"CPU Clock : 624MHz");
		break;
	default:
		m_strCpuClock.Format(L"CPU Clock : 208MHz");
		break;
	}
}




void CCurrentStatus::M3Orange_GetCpu()
{
	nCurClock = SYSTEM_GetCpuClock(&dwCpuClock);

	switch (nCurClock)
	{
	case ORANGE_806MHz: 
		m_strCpuClock.Format(L"CPU Clock : 806MHz");
		break;
	case ORANGE_624MHz: 
		m_strCpuClock.Format(L"CPU Clock : 624MHz");
		break;
	case ORANGE_416MHz: 
		m_strCpuClock.Format(L"CPU Clock : 416MHz");
		break;
	case ORANGE_208MHz: 
		m_strCpuClock.Format(L"CPU Clock : 208MHz");
		break;
	default:
		m_strCpuClock.Format(L"CPU Clock : 208MHz");
		break;
	}


}
void CCurrentStatus::M3T_GetCpu()
{
	nCurClock = SYSTEM_GetCpuClock(&dwCpuClock);

	switch (nCurClock)
	{
	case M3T_208MHz: 
		m_strCpuClock.Format(L"CPU Clock : 208MHz");
		break;
	case M3T_416MHz: 
		m_strCpuClock.Format(L"CPU Clock : 416MHz");
		break;
	case M3T_624MHz: 
		m_strCpuClock.Format(L"CPU Clock : 624MHz");
		break;
	case M3T_806MHz: 
		m_strCpuClock.Format(L"CPU Clock : 806MHz");
		break;
	default:
		m_strCpuClock.Format(L"CPU Clock : 208MHz");
		break;
	}
}

void CCurrentStatus::Pos_GetCpu()
{
	nCurClock = SYSTEM_GetCpuClock(&dwCpuClock);

	switch (nCurClock)
	{
	case POS_208MHz:
		m_strCpuClock.Format(L"CPU Clock : 208MHz");
		break;
	case POS_416MHz: 
		m_strCpuClock.Format(L"CPU Clock : 416MHz");
		break;
	case POS_624MHz: 
		m_strCpuClock.Format(L"CPU Clock : 624MHz");
		break;
	case POS_806MHz:
		m_strCpuClock.Format(L"CPU Clock : 806MHz");
		break;
	default:
		m_strCpuClock.Format(L"CPU Clock : 208MHz");
		break;
	}
}
void CCurrentStatus::M3Black_GetCpu()
{
	nCurClock = SYSTEM_GetCpuClock(&dwCpuClock);
	RETAILMSG(1, (_T("status dwCpuClock : %d \r\n"), dwCpuClock));

	switch (dwCpuClock)
	{

	case M3BLACK_300MHz:
		m_strCpuClock.Format(L"CPU Clock : 300MHz");
		break;
	case M3BLACK_600MHz:
		m_strCpuClock.Format(L"CPU Clock : 600MHz");
		break;
	case M3BLACK_800MHz:
		m_strCpuClock.Format(L"CPU Clock : 800MHz");
		break;
	case M3BLACK_1000MHz:
		m_strCpuClock.Format(L"CPU Clock : 1000MHz");
		break;
	default:
		m_strCpuClock.Format(L"CPU Clock : 1000MHz");
		break;
	}
}
