// BacklightDlg.cpp : implementation file
//

#include "stdafx.h"
#include "SystemTest.h"
#include "BacklightDlg.h"

#include "SystemTestDlg.h"


// CBacklightDlg dialog

IMPLEMENT_DYNAMIC(CBacklightDlg, CDialog)

CBacklightDlg::CBacklightDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CBacklightDlg::IDD, pParent)
	, m_strBacklightLevel(_T(""))
{

}

CBacklightDlg::~CBacklightDlg()
{
}

void CBacklightDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COMBO_BACKLIGHTTIMEOUT, m_ctlBackLightTimeout);
	DDX_Control(pDX, IDC_COMBO_POWERTIMEOUT, m_ctlPowerTimeout);
	DDX_Control(pDX, IDC_COMBO_ACBACKLIGHTTIMEOUT, m_ctlACBackLightTimeout);
	DDX_Control(pDX, IDC_COMBO_ACPOWERTIMEOUT, m_ctlACPowerTimeout);
	DDX_Control(pDX, IDC_SLIDER_BACKLIGHTLEVEL, m_ctlBackLightLevel);
	DDX_Text(pDX, IDC_STATIC_BACKLIGHTLEVEL, m_strBacklightLevel);
}


BEGIN_MESSAGE_MAP(CBacklightDlg, CDialog)
	ON_BN_CLICKED(IDC_BACKLIGHT_ON, &CBacklightDlg::OnBnClickedBacklightOn)
	ON_BN_CLICKED(IDC_BACKLIGHT_OFF, &CBacklightDlg::OnBnClickedBacklightOff)
	ON_CBN_SELCHANGE(IDC_COMBO_BACKLIGHTTIMEOUT, &CBacklightDlg::OnCbnSelchangeComboBacklighttimeout)
	ON_BN_CLICKED(IDC_BTN_SLEEP, &CBacklightDlg::OnBnClickedBtnSleep)
	ON_CBN_SELCHANGE(IDC_COMBO_POWERTIMEOUT, &CBacklightDlg::OnCbnSelchangeComboPowertimeout)
	ON_CBN_SELCHANGE(IDC_COMBO_ACBACKLIGHTTIMEOUT, &CBacklightDlg::OnCbnSelchangeComboAcbacklighttimeout)
	ON_CBN_SELCHANGE(IDC_COMBO_ACPOWERTIMEOUT, &CBacklightDlg::OnCbnSelchangeComboAcpowertimeout)
	ON_WM_HSCROLL()
	ON_WM_MOUSEMOVE()
	ON_WM_DESTROY()
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_SLIDER_BACKLIGHTLEVEL, &CBacklightDlg::OnNMCustomdrawSliderBacklightlevel)
END_MESSAGE_MAP()


// CBacklightDlg message handlers

BOOL CBacklightDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	DEVICE_INFO m_DeviceInfo = (DEVICE_INFO)SYSTEM_GetDeviceInfo();

	if((m_DeviceInfo == DEVICE_M3SMARTCE) || (m_DeviceInfo == DEVICE_M3ORANGEPLUS_CE) || (m_DeviceInfo == DEVICE_M3T) || (m_DeviceInfo == DEVICE_Pos) || (m_DeviceInfo == DEVICE_M3UL10_CE)  || (m_DeviceInfo == DEVICE_M3BLACK_CE) )
	{
		// Only for WinCE
		MoveWindow(0, 0, 240, 320);
	}

	if((m_DeviceInfo == DEVICE_M3SMARTCE) || (m_DeviceInfo == DEVICE_M3ORANGEPLUS_CE) || (m_DeviceInfo == DEVICE_M3UL10_CE))
	{
		m_ctlBtnBacklight_ON.EnableWindow(FALSE);
	}

	DWORD dwBacklightTimeout_Cur;
	DWORD dwACBacklightTimeout_Cur;
	DWORD dwBacklightlevel_Cur;

	DWORD dwPowerTimeout_Cur;
	DWORD dwACPowerTimeout_Cur;

	//͸  Ʈ ŸӾƿ
	if(m_DeviceInfo == DEVICE_M3T || m_DeviceInfo == DEVICE_Pos )
	{
		m_ctlBackLightTimeout.InsertString(0, L"NONE");
		m_ctlBackLightTimeout.InsertString(1, L"15 Sec");
		m_ctlBackLightTimeout.InsertString(2, L"30 Sec");
		m_ctlBackLightTimeout.InsertString(3, L"1 Min");
		m_ctlBackLightTimeout.InsertString(4, L"2 Min");
		m_ctlBackLightTimeout.InsertString(5, L"5 Min");
	}
	else
	{
		m_ctlBackLightTimeout.InsertString(0, L"NONE");
		m_ctlBackLightTimeout.InsertString(1, L"10 Sec");
		m_ctlBackLightTimeout.InsertString(2, L"30 Sec");
		m_ctlBackLightTimeout.InsertString(3, L"1 Min");
		m_ctlBackLightTimeout.InsertString(4, L"2 Min");
		m_ctlBackLightTimeout.InsertString(5, L"3 Min");
		m_ctlBackLightTimeout.InsertString(6, L"4 Min");
		m_ctlBackLightTimeout.InsertString(7, L"5 Min");
	}

	dwBacklightTimeout_Cur = SYSTEM_GetBackLightTimeOut(BATTERY_POWER);
	m_ctlBackLightTimeout.SetCurSel(dwBacklightTimeout_Cur);


	//AC Ʈ ŸӾƿ
	if(m_DeviceInfo == DEVICE_M3T || m_DeviceInfo == DEVICE_Pos)
	{
		m_ctlACBackLightTimeout.InsertString(0, L"NONE");
		m_ctlACBackLightTimeout.InsertString(1, L"15 Sec");
		m_ctlACBackLightTimeout.InsertString(2, L"30 Sec");
		m_ctlACBackLightTimeout.InsertString(3, L"1 Min");
		m_ctlACBackLightTimeout.InsertString(4, L"2 Min");
		m_ctlACBackLightTimeout.InsertString(5, L"5 Min");
		m_ctlACBackLightTimeout.InsertString(6, L"10 Min");
		m_ctlACBackLightTimeout.InsertString(7, L"15 Min");
		m_ctlACBackLightTimeout.InsertString(8, L"30 Min");
	}
	else if(m_DeviceInfo == DEVICE_M3SMARTCE || m_DeviceInfo == DEVICE_M3ORANGEPLUS_CE || m_DeviceInfo == DEVICE_M3UL10_CE || m_DeviceInfo == DEVICE_M3BLACK_CE )
	{
		m_ctlACBackLightTimeout.InsertString(0, L"NONE");
		m_ctlACBackLightTimeout.InsertString(1, L"30 Sec");
		m_ctlACBackLightTimeout.InsertString(2, L"1 Min");
		m_ctlACBackLightTimeout.InsertString(3, L"2 Min");
		m_ctlACBackLightTimeout.InsertString(4, L"3 Min");
		m_ctlACBackLightTimeout.InsertString(5, L"4 Min");
		m_ctlACBackLightTimeout.InsertString(6, L"5 Min");
		m_ctlACBackLightTimeout.InsertString(7, L"10 Min");
	}
	else
	{
		m_ctlACBackLightTimeout.InsertString(0, L"NONE");
		m_ctlACBackLightTimeout.InsertString(1, L"1 Min");
		m_ctlACBackLightTimeout.InsertString(2, L"2 Min");
		m_ctlACBackLightTimeout.InsertString(3, L"3 Min");
		m_ctlACBackLightTimeout.InsertString(4, L"4 Min");
		m_ctlACBackLightTimeout.InsertString(5, L"5 Min");
		m_ctlACBackLightTimeout.InsertString(6, L"6 Min");
		m_ctlACBackLightTimeout.InsertString(7, L"7 Min");
		m_ctlACBackLightTimeout.InsertString(8, L"8 Min");
		m_ctlACBackLightTimeout.InsertString(9, L"9 Min");
		m_ctlACBackLightTimeout.InsertString(10, L"10 Min");
	}

	dwACBacklightTimeout_Cur = SYSTEM_GetBackLightTimeOut(EXTERNAL_POWER);
	m_ctlACBackLightTimeout.SetCurSel(dwACBacklightTimeout_Cur);


	if(m_DeviceInfo == DEVICE_M3T )
	{
		//BackLight Level
		m_ctlBackLightLevel.SetRange(0, 6);
	}
	else
	{
		m_ctlBackLightLevel.SetRange(0, 8);
	}
	//m_ctlBackLightLevel.GetNumTics();
	m_ctlBackLightLevel.SetTicFreq(1);

	dwBacklightlevel_Cur = SYSTEM_GetBacklightlevel();
	m_ctlBackLightLevel.SetPos(dwBacklightlevel_Cur);
		
///////////////////////////////////////////////////
//		DWORD dwPos;
//		dwPos = m_ctlBackLightLevel.GetPos();
///////////////////////////////////////////////////
	if(m_DeviceInfo == DEVICE_M3T )
	{
		switch(dwBacklightlevel_Cur)
		{
			case M3T_BACKLIGHT_100:
				m_strBacklightLevel.Format(L"100%%");
				break;
			case M3T_BACKLIGHT_90:
				m_strBacklightLevel.Format(L"90%%");
				break;
			case M3T_BACKLIGHT_80:
				m_strBacklightLevel.Format(L"80%%");
				break;
			case M3T_BACKLIGHT_60:
				m_strBacklightLevel.Format(L"60%%");
				break;
			case M3T_BACKLIGHT_40:
				m_strBacklightLevel.Format(L"40%%");
				break;
			case M3T_BACKLIGHT_20:
				m_strBacklightLevel.Format(L"20%%");
				break;
			case M3T_BACKLIGHT_05:
				m_strBacklightLevel.Format(L"5%%");
				break;
			default:
				m_strBacklightLevel.Format(L"60%%");
				break;
		}
	}
	else
	{
		switch(dwBacklightlevel_Cur)
		{
			case BACKLIGHT_100:
				m_strBacklightLevel.Format(L"100%%");
				break;
			case BACKLIGHT_90:
				m_strBacklightLevel.Format(L"90%%");
				break;
			case BACKLIGHT_80:
				m_strBacklightLevel.Format(L"80%%");
				break;
			case BACKLIGHT_70:
				m_strBacklightLevel.Format(L"70%%");
				break;
			case BACKLIGHT_60:
				m_strBacklightLevel.Format(L"60%%");
				break;
			case BACKLIGHT_40:
				m_strBacklightLevel.Format(L"40%%");
				break;
			case BACKLIGHT_20:
				m_strBacklightLevel.Format(L"20%%");
				break;
			case BACKLIGHT_10:
				m_strBacklightLevel.Format(L"10%%");
				break;
			case BACKLIGHT_05:
				m_strBacklightLevel.Format(L"5%%");
				break;
			default:
				m_strBacklightLevel.Format(L"60%%");
				break;
		}
	}


	//͸  Ŀ ŸӾƿ

	if(m_DeviceInfo == DEVICE_M3T || m_DeviceInfo == DEVICE_Pos || m_DeviceInfo == DEVICE_M3BLACK_CE)
	{
		m_ctlPowerTimeout.InsertString(0, L"NONE");
		m_ctlPowerTimeout.InsertString(1, L"1 Min");
		m_ctlPowerTimeout.InsertString(2, L"2 Min");
		m_ctlPowerTimeout.InsertString(3, L"3 Min");
		m_ctlPowerTimeout.InsertString(4, L"4 Min");
		m_ctlPowerTimeout.InsertString(5, L"5 Min");
		m_ctlPowerTimeout.InsertString(6, L"10 Min");
		m_ctlPowerTimeout.InsertString(7, L"30 Min");
	}
	else
	{
		m_ctlPowerTimeout.InsertString(0, L"NONE");
		m_ctlPowerTimeout.InsertString(1, L"1 Min");
		m_ctlPowerTimeout.InsertString(2, L"2 Min");
		m_ctlPowerTimeout.InsertString(3, L"3 Min");
		m_ctlPowerTimeout.InsertString(4, L"4 Min");
		m_ctlPowerTimeout.InsertString(5, L"5 Min");
	}

	dwPowerTimeout_Cur = SYSTEM_GetPowerTimeOut(BATTERY_POWER);
	m_ctlPowerTimeout.SetCurSel(dwPowerTimeout_Cur);

	//AC Ŀ ŸӾƿ
	m_ctlACPowerTimeout.InsertString(0, L"NONE");
	m_ctlACPowerTimeout.InsertString(1, L"1 Min");
	m_ctlACPowerTimeout.InsertString(2, L"2 Min");
	m_ctlACPowerTimeout.InsertString(3, L"5 Min");
	m_ctlACPowerTimeout.InsertString(4, L"10 Min");
	m_ctlACPowerTimeout.InsertString(5, L"15 Min");
	m_ctlACPowerTimeout.InsertString(6, L"30 Min");

	dwACPowerTimeout_Cur = SYSTEM_GetPowerTimeOut(EXTERNAL_POWER);
	m_ctlACPowerTimeout.SetCurSel(dwACPowerTimeout_Cur);


	UpdateData(FALSE);	

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CBacklightDlg::OnBnClickedBacklightOn()
{
	SYSTEM_BacklightOn(TRUE);
	
}

void CBacklightDlg::OnBnClickedBacklightOff()
{
	SYSTEM_BacklightOn(FALSE);
}

void CBacklightDlg::OnCbnSelchangeComboBacklighttimeout()
{
	DWORD	dwBright;

	dwBright = m_ctlBackLightTimeout.GetCurSel();
	if(dwBright == 0)
		SYSTEM_SetBackLightTimeOut(BATTERY_POWER, FALSE, dwBright);
	else
		SYSTEM_SetBackLightTimeOut(BATTERY_POWER, TRUE, dwBright);
}

void CBacklightDlg::OnCbnSelchangeComboAcbacklighttimeout()
{
	DWORD	dwACBright;

	dwACBright = m_ctlACBackLightTimeout.GetCurSel();
	if(dwACBright == 0)
		SYSTEM_SetBackLightTimeOut(EXTERNAL_POWER, FALSE, dwACBright);
	else
		SYSTEM_SetBackLightTimeOut(EXTERNAL_POWER, TRUE, dwACBright);
}


void CBacklightDlg::OnBnClickedBtnSleep()
{
	SYSTEM_SetSleepMode();	
}

void CBacklightDlg::OnCbnSelchangeComboPowertimeout()
{
	DWORD	dwPower;

	dwPower = m_ctlPowerTimeout.GetCurSel();
	SYSTEM_SetPowerTimeOut(BATTERY_POWER, dwPower);	
}


void CBacklightDlg::OnCbnSelchangeComboAcpowertimeout()
{
	DWORD	dwACPower;

	dwACPower = m_ctlACPowerTimeout.GetCurSel();
	SYSTEM_SetPowerTimeOut(EXTERNAL_POWER, dwACPower);
}

// void CBacklightDlg::OnNMReleasedcaptureSliderBacklightlevel(NMHDR *pNMHDR, LRESULT *pResult)
// {
// 	DWORD dwPos;
// 	dwPos = m_ctlBackLightLevel.GetPos();
// 	
// 	SYSTEM_SetBacklightlevel(dwPos);
// 
// 	*pResult = 0;
// }

void CBacklightDlg::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
	if(pScrollBar == (CScrollBar*)&m_ctlBackLightLevel)
	{
		DWORD dwPos;
		dwPos = m_ctlBackLightLevel.GetPos();

		DEVICE_INFO m_DeviceInfo = (DEVICE_INFO)SYSTEM_GetDeviceInfo();
		
		if(m_DeviceInfo == DEVICE_M3T )
		{
			switch(dwPos)
			{
			case M3T_BACKLIGHT_05:
				m_strBacklightLevel.Format(L"5%%");
				break;
			case M3T_BACKLIGHT_20:
				m_strBacklightLevel.Format(L"20%%");
				break;
			case M3T_BACKLIGHT_40:
				m_strBacklightLevel.Format(L"40%%");
				break; 
			case M3T_BACKLIGHT_60:
				m_strBacklightLevel.Format(L"60%%");
				break;
			case M3T_BACKLIGHT_80:
				m_strBacklightLevel.Format(L"80%%");
				break;
			case M3T_BACKLIGHT_90:
				m_strBacklightLevel.Format(L"90%%");
				break;
			case M3T_BACKLIGHT_100:
				m_strBacklightLevel.Format(L"100%%");
				break;
			}
		}
		else
		{
			switch(dwPos)
			{
			case BACKLIGHT_05:
				m_strBacklightLevel.Format(L"5%%");
				break;
			case BACKLIGHT_10:
				m_strBacklightLevel.Format(L"10%%");
				break;
			case BACKLIGHT_20:
				m_strBacklightLevel.Format(L"20%%");
				break; 
			case BACKLIGHT_40:
				m_strBacklightLevel.Format(L"40%%");
				break;
			case BACKLIGHT_60:
				m_strBacklightLevel.Format(L"60%%");
				break;
			case BACKLIGHT_70:
				m_strBacklightLevel.Format(L"70%%");
				break;
			case BACKLIGHT_80:
				m_strBacklightLevel.Format(L"80%%");
				break;
			case BACKLIGHT_90:
				m_strBacklightLevel.Format(L"90%%");
				break;
			case BACKLIGHT_100:
				m_strBacklightLevel.Format(L"100%%");
				break;
			}
		}
		SYSTEM_SetBacklightlevel(dwPos);
	}

	UpdateData(FALSE);

	CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}


void CBacklightDlg::OnDestroy()
{
	CDialog::OnDestroy();

	OnOK();
}


void CBacklightDlg::OnNMCustomdrawSliderBacklightlevel(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMCUSTOMDRAW pNMCD = reinterpret_cast<LPNMCUSTOMDRAW>(pNMHDR);
	// TODO: Add your control notification handler code here
	*pResult = 0;
}
