
#ifdef SYSTEM_EXPORTS
#define SYSTEM_API __declspec(dllexport)
#else
#define SYSTEM_API __declspec(dllimport)
#endif



typedef enum {
	DEVICE_M3SKY = 0,
	DEVICE_M3SKYSAM,
	DEVICE_M3ORANGE,
	DEVICE_M3SMARTCE,
	DEVICE_M3SMARTWM,
	DEVICE_M3T,
	DEVICE_M3ORANGEPLUS_WM,
	DEVICE_Pos,
	DEVICE_MM3,
	DEVICE_M3ORANGEPLUS_CE,
	DEVICE_M3BLACK,
	DEVICE_M3UL10_CE,
	DEVICE_M3BLACK_CE
} DEVICE_INFO;

typedef enum{
	BATTERY_POWER,
	EXTERNAL_POWER
}POWERTYPE;

struct GPRS_ENTRY
{
	TCHAR tzIP[16];
	TCHAR tzAPN[64];
	TCHAR tzUserName[64];
	TCHAR tzPassword[64];
	TCHAR tzPrimaryDNS[64];
	TCHAR tzSecondDNS[64];
};

typedef enum {
	M3BLACK_300MHz = 0,
	M3BLACK_600MHz = 1,
	M3BLACK_800MHz = 2,
	M3BLACK_1000MHz = 3
} M3BLACK_CPUTYPE;

typedef enum {
	ORANGE_208MHz = 0,
	ORANGE_416MHz = 1,
	ORANGE_624MHz = 2,
	ORANGE_806MHz = 3
} ORANGE_CPUTYPE;

typedef enum {
	M3T_208MHz = 0,
	M3T_416MHz = 1,
	M3T_624MHz = 2,
	M3T_806MHz = 3
} M3T_CPUTYPE;


typedef enum {
	POS_208MHz = 0,
	POS_416MHz = 1,
	POS_624MHz = 2,
	POS_806MHz = 3
} M3POS_CPU;

typedef enum {
	SKY_208MHz = 4,
	SKY_312MHz = 3,
	SKY_416MHz = 2,
	SKY_520MHz = 1,
	SKY_624MHz = 0
} SKY_CPU;

typedef enum {
	M3T_BACKLIGHT_100 = 6,
	M3T_BACKLIGHT_90 = 5,
	M3T_BACKLIGHT_80 = 4,
	M3T_BACKLIGHT_60 = 3,
	M3T_BACKLIGHT_40 = 2,
	M3T_BACKLIGHT_20 = 1,
	M3T_BACKLIGHT_05 = 0
} M3T_BACKLIGHTLEVEL;

typedef enum {
	BACKLIGHT_100 = 8,
	BACKLIGHT_90 = 7,
	BACKLIGHT_80 = 6,
	BACKLIGHT_70 = 5,
	BACKLIGHT_60 = 4,
	BACKLIGHT_40 = 3,
	BACKLIGHT_20 = 2,
	BACKLIGHT_10 = 1,
	BACKLIGHT_05 = 0
} BACKLIGHTLEVEL;



typedef struct _GSensor_PARAMS
{
	int       GsensorEnable;					
	bool       DisplayRotate;				
	bool       MotionDisplayOff;		        
	bool       MotionDisplayWakeup;            
	bool       MotionSleepOn;					
	bool       MotionSleepWakeup;		        
	bool       MotionSleepOnPrevent;           
	bool       MotionStateCheck;				
	bool       DisPlayMenuCheck;				
	bool       SuspendMenuCheck;
}GSensor_PARAMS, *PGSensor_PARAMS;


typedef struct _BOOT_OS_INFO{
	DWORD	BootVer;
	TCHAR	szOSName[15];
} BOOT_OS_INFO, *PBOOT_OS_INFO;

#define IOCTL_HAL_GET_BOOT_OS_INFO     CTL_CODE(FILE_DEVICE_HAL, 2083, METHOD_BUFFERED, FILE_ANY_ACCESS)


#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

	SYSTEM_API BOOL		SYSTEM_Init();
	SYSTEM_API BOOL		SYSTEM_Deinit();

	SYSTEM_API BOOL		SYSTEM_BacklightOn(BOOL bOn);
	SYSTEM_API BOOL		SYSTEM_KeypadLock(BOOL bOn);
	SYSTEM_API void		SYSTEM_SetSleepMode();
	SYSTEM_API BOOL		SYSTEM_Vibrate(BOOL bOn);
	SYSTEM_API void		SYSTEM_Reboot();
	SYSTEM_API BOOL		SYSTEM_Cleanboot(BOOL bOn);
	SYSTEM_API void		SYSTEM_VolumeMute();

	SYSTEM_API void		SYSTEM_SetVolumeLevel(DWORD m_nVolume);
	SYSTEM_API DWORD	SYSTEM_GetVolumeLevel();
	SYSTEM_API void		SYSTEM_SetPhoneVolumeLevel(DWORD m_nVolume);
	SYSTEM_API DWORD	SYSTEM_GetPhoneVolumeLevel();
	SYSTEM_API void		SYSTEM_SetBacklightlevel(DWORD m_dwBright);
	SYSTEM_API DWORD	SYSTEM_GetBacklightlevel();
	SYSTEM_API BOOL		SYSTEM_SetPowerTimeOut(POWERTYPE type, int nTimeOut);
	SYSTEM_API DWORD	SYSTEM_GetPowerTimeOut(POWERTYPE type);
	SYSTEM_API BOOL		SYSTEM_SetBackLightTimeOut(POWERTYPE type, BOOL bCheck, int nTimeOut);
	SYSTEM_API DWORD	SYSTEM_GetBackLightTimeOut(POWERTYPE type);
	SYSTEM_API BOOL		SYSTEM_SetCpuClock(int cpu);
	SYSTEM_API int		SYSTEM_GetCpuClock(DWORD* getclock);
	SYSTEM_API BOOL		SYSTEM_SetWlan(BOOL bOn);
	SYSTEM_API BOOL		SYSTEM_GetWlan();
	SYSTEM_API BOOL		SYSTEM_SetBluetooth(BOOL bOn);
	SYSTEM_API BOOL		SYSTEM_GetBluetooth();
	SYSTEM_API BOOL		SYSTEM_GetBatteryState();
	SYSTEM_API int		SYSTEM_GetBatteryLifePercent();
	SYSTEM_API BOOL		SYSTEM_GetSerialNumber(TCHAR* szSerial);
	SYSTEM_API BOOL		SYSTEM_GetGUID(TCHAR* szGUID);

	SYSTEM_API BOOL		SYSTEM_GetVersionInfo(TCHAR* pszVersion);
	SYSTEM_API DEVICE_INFO		SYSTEM_GetDeviceInfo();
	SYSTEM_API BOOL		SYSTEM_GetGSensorValue(PGSensor_PARAMS GSensor_Params);
	SYSTEM_API BOOL 	SYSTEM_SetGSensorValue(PGSensor_PARAMS GSensor_Params);
	SYSTEM_API BOOL		SYSTEM_GetOSVersionInfo(TCHAR* strVersionInfo);

#if _WIN32_WCE == 0x502

	SYSTEM_API BOOL		SYSTEM_SetGprsStatus(BOOL bEnable);
	SYSTEM_API BOOL		SYSTEM_IsGprsEnable();
	SYSTEM_API BOOL		SYSTEM_MakeGprsConnection(GPRS_ENTRY entry);
#else if _WIN32_WCE == 0x500
#endif

#ifdef __cplusplus
}
#endif // __cplusplus


