'********************************************************************
'created	:	2011/10/18
'file base	: 	ScanTestVB.exe

'file ext	:	vb
'author		:	Dong-Hyun Eum & Eun-Taek Lee

'purpose	:	Scanner VB Demo Program
'Report		:	2012. 01. 13 [01/13/2011 vision7901] v1.0.0 - Release Version
'*********************************************************************/
Imports System
Imports System.Collections.Generic
Imports System.ComponentModel
Imports System.Data
Imports System.Drawing
Imports System.Text
Imports System.Windows.Forms
Imports System.Runtime.InteropServices
Imports Microsoft.Win32
Imports System.Threading
Imports System.Reflection
Imports System.IO
Imports ScannerNet



Public Class ScanTestVB

    Private m_Scanner As ScannerNet.Scanner
    Private m_DecoderParams As ScannerNet.DECODER_PARAMS

    Public m_bResult As Boolean = False
    Public m_bSyncMode As Boolean = False
    Public m_bWinCE As Boolean = False

    Public m_strVerInfo As String

    Public Const VK_F22 As Long = &H85 'F22(WinCE) 
    Public Const VK_F14 As Long = &H7D 'F14(WM)
    Private m_nHotKeyCE As UInt32
    Private m_nHotKeyWM As UInt32

    Private m_EngineType As SCAN_ENGINE_TYPE
    Private m_DeviceType As SCAN_DEVICE_TYPE


    Private Sub ScanTestVB_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        m_Scanner = New Scanner()
        AddHandler m_Scanner.ScannerDataEvent, AddressOf Me.OnScanRead

        REM Get Device Type
        m_DeviceType = m_Scanner.GetDeviceType()

        REM OS Type
        If m_DeviceType = ScannerNet.SCAN_DEVICE_TYPE.DEVICE_M3SMART_CE Or m_DeviceType = ScannerNet.SCAN_DEVICE_TYPE.DEVICE_M3GREEN Or m_DeviceType = ScannerNet.SCAN_DEVICE_TYPE.DEVICE_M3T Or m_DeviceType = ScannerNet.SCAN_DEVICE_TYPE.DEVICE_M3POS Or m_DeviceType = ScannerNet.SCAN_DEVICE_TYPE.DEVICE_M3ORANGEPLUS_CE Then
            m_bWinCE = True
        End If

        REM Scanner Open
        m_Scanner.Open()

        m_nHotKeyCE = UInt32.Parse(VK_F22)
        m_nHotKeyWM = UInt32.Parse(VK_F14)

        If m_bWinCE = True Then
            m_Scanner.RegHotKey(1, m_nHotKeyCE, m_bSyncMode)
        Else
            m_Scanner.RegHotKey(1, m_nHotKeyWM, m_bSyncMode)
        End If

        REM Get Engine Type
        m_EngineType = m_Scanner.GetEngineType()
    End Sub

    Private Sub ScanTestVB_Closing(ByVal sender As System.Object, ByVal e As System.ComponentModel.CancelEventArgs) Handles MyBase.Closing
        Dim i As Integer
        Dim bResult As Boolean

        m_Scanner.UnRegHotKey(1)

        For i = 0 To 3
            bResult = m_Scanner.Close()
            Thread.Sleep(300)
            If bResult = True Then
                Exit For
            End If

            i = i + 1
        Next

    End Sub


    Private Sub OnScanRead(ByVal sender As System.Object, ByVal e As ScannerDataArgs)
        If e.ScanData <> "" Then
            LB_TYPE.Text = e.ScanType
            TB_DATA.Text = e.ScanData
        End If
    End Sub


    Private Sub BN_SCAN_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BN_SCAN.Click
        m_Scanner.Read()
    End Sub


    Private Sub BN_SCANCANCEL_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BN_SCANCANCEL.Click
        m_Scanner.ReadCancel()
    End Sub

    Private Sub BN_INFO_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BN_INFO.Click

        Dim AboutDlg As New FABOUT()

        AboutDlg.m_strVersion = m_Scanner.GetVersionInfo()

        REM Disable Scan Key
        m_Scanner.ReadCancel()
        m_Scanner.UnRegHotKey(1)

        AboutDlg.ShowDialog()

        REM Enable Scan Key
        If m_bWinCE = True Then
            m_Scanner.RegHotKey(1, m_nHotKeyCE, m_bSyncMode)
        Else
            m_Scanner.RegHotKey(1, m_nHotKeyWM, m_bSyncMode)
        End If

    End Sub

    Private Sub BN_NEW_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BN_NEW.Click

        Dim NewForm As New FTEST()

        m_Scanner.ReadCancel()

        RemoveHandler m_Scanner.ScannerDataEvent, AddressOf Me.OnScanRead

        If NewForm.ShowDialog() = Windows.Forms.DialogResult.OK Then
            AddHandler m_Scanner.ScannerDataEvent, AddressOf Me.OnScanRead
        End If

    End Sub

    Private Sub BN_SYM_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BN_SYM.Click

        Dim Symbology As New FSYMBOLOGY()

        REM Disable Scan Key

        m_Scanner.ReadCancel()
        m_Scanner.UnRegHotKey(1)

        Symbology.ShowDialog()

        REM Scan Key

        If m_bWinCE = True Then
            m_Scanner.RegHotKey(1, m_nHotKeyCE, m_bSyncMode)
        Else
            m_Scanner.RegHotKey(1, m_nHotKeyWM, m_bSyncMode)
        End If

    End Sub

    Private Sub BN_SYMOPTION_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BN_SYMOPTION.Click

        Dim SymOption As New FSYMOPTION()

        REM Disable Scan Key

        m_Scanner.ReadCancel()
        m_Scanner.UnRegHotKey(1)

        SymOption.ShowDialog()

        REM Enable Scan Key
        If m_bWinCE = True Then
            m_Scanner.RegHotKey(1, m_nHotKeyCE, m_bSyncMode)
        Else
            m_Scanner.RegHotKey(1, m_nHotKeyWM, m_bSyncMode)
        End If
    End Sub

    Private Sub BN_SCANOPTION_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BN_SCANOPTION.Click

        Dim ScanOption As New FSCANOPTION()

        ScanOption.m_bSyncMode = m_bSyncMode

        m_Scanner.UnRegHotKey(1)

        If ScanOption.ShowDialog() = Windows.Forms.DialogResult.OK Then
            m_bSyncMode = ScanOption.m_bSyncMode
        End If

        If m_bWinCE = True Then
            m_Scanner.RegHotKey(1, m_nHotKeyCE, m_bSyncMode)
        Else
            m_Scanner.RegHotKey(1, m_nHotKeyWM, m_bSyncMode)
        End If


    End Sub

    Private Sub BN_CLOSE_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BN_CLOSE.Click
        Close()

        Application.Exit()
    End Sub
End Class
