﻿Imports System
Imports System.Collections.Generic
Imports System.ComponentModel
Imports System.Data
Imports System.Drawing
Imports System.Text
Imports System.Windows.Forms
Imports ScannerNet

Public Class FSYMBOLOGY
    Private m_Scanner As Scanner
    Private m_DECODER As ScannerNet.DECODER

    Private m_EngineType As SCAN_ENGINE_TYPE

    Private Sub FSYMBOLOGY_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        m_Scanner = New Scanner()
        m_DECODER = New ScannerNet.DECODER()

        m_EngineType = m_Scanner.GetEngineType()

        If m_EngineType = SCAN_ENGINE_TYPE.SYMBOL_HW Then
            ' Not Supported SYMBOL H/W Decoder Scanner
            CB_KOREAPOST.Enabled = False
            CB_TELEPEN.Enabled = False
        End If

        m_Scanner.GetSymbology(m_DECODER)

        SetCheckBox()

    End Sub


    Private Sub BN_ALL_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BN_ALL.Click
        m_Scanner.SetSymbologyAll()

        m_Scanner.GetSymbology(m_DECODER)

        SetCheckBox()

    End Sub

    Private Sub BN_DEFAULT_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BN_DEFAULT.Click
        m_Scanner.SetSymbologyDefault()

        m_Scanner.GetSymbology(m_DECODER)

        SetCheckBox()

    End Sub

    Private Sub BN_OK_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BN_OK.Click
        m_DECODER.bUPCA = CB_UPCA.Checked
        m_DECODER.bUPCE = CB_UPCE.Checked
        m_DECODER.bEAN13 = CB_EAN13.Checked
        m_DECODER.bEAN8 = CB_EAN8.Checked
        m_DECODER.bCODE39 = CB_CODE39.Checked
        m_DECODER.bCODE128 = CB_CODE128.Checked
        m_DECODER.bCODE93 = CB_CODE93.Checked
        m_DECODER.bCODE11 = CB_CODE11.Checked
        m_DECODER.bCODE25 = CB_CODE25.Checked
        m_DECODER.bCODABAR = CB_CODABAR.Checked
        m_DECODER.bKOREAPOST = CB_KOREAPOST.Checked
        m_DECODER.bMSI = CB_MSI.Checked
        m_DECODER.bGS1 = CB_GS1.Checked
        m_DECODER.bTELEPEN = CB_TELEPEN.Checked

        m_Scanner.SetSymbology(m_DECODER)

        Me.DialogResult = Windows.Forms.DialogResult.OK

    End Sub

    Private Sub BN_CLOSE_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BN_CLOSE.Click
        Me.DialogResult = Windows.Forms.DialogResult.Cancel

    End Sub


    Public Sub SetCheckBox()
        CB_UPCA.Checked = m_DECODER.bUPCA
        CB_UPCE.Checked = m_DECODER.bUPCE
        CB_EAN13.Checked = m_DECODER.bEAN13
        CB_EAN8.Checked = m_DECODER.bEAN8
        CB_CODE39.Checked = m_DECODER.bCODE39
        CB_CODE128.Checked = m_DECODER.bCODE128
        CB_CODE93.Checked = m_DECODER.bCODE93
        CB_CODE11.Checked = m_DECODER.bCODE11
        CB_CODE25.Checked = m_DECODER.bCODE25
        CB_CODABAR.Checked = m_DECODER.bCODABAR
        CB_KOREAPOST.Checked = m_DECODER.bKOREAPOST
        CB_MSI.Checked = m_DECODER.bMSI
        CB_GS1.Checked = m_DECODER.bGS1
        CB_TELEPEN.Checked = m_DECODER.bTELEPEN
    End Sub

End Class