﻿Imports System
Imports System.Collections.Generic
Imports System.ComponentModel
Imports System.Data
Imports System.Drawing
Imports System.Text
Imports System.Windows.Forms
Imports ScannerNet



Public Class FSCANOPTION

    Private m_Scanner As Scanner
    Private m_DecoderParams As DECODER_PARAMS

    Private m_EngineType As SCAN_ENGINE_TYPE
    Private m_DeviceType As SCAN_DEVICE_TYPE

    Public m_bSyncMode As Boolean

    Private Sub FSCANOPTION_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        m_Scanner = New Scanner()
        m_DecoderParams = New DECODER_PARAMS()

        m_DeviceType = m_Scanner.GetDeviceType()
        m_EngineType = m_Scanner.GetEngineType()

        If m_EngineType = SCAN_ENGINE_TYPE.CINO Then
            ' Not Supported CINO Scanner
            CB_WIDESCAN.Enabled = False
            CB_HIGHFILTER.Enabled = False
        ElseIf m_EngineType = SCAN_ENGINE_TYPE.SYMBOL_HW Then
            ' Not Supported SYMBOL HW Decoder Scanner                
            CB_WIDESCAN.Enabled = False
            CB_HIGHFILTER.Enabled = False
        ElseIf m_EngineType = SCAN_ENGINE_TYPE.SYMBOL Or m_EngineType = SCAN_ENGINE_TYPE.INTERMEC Then
            ' Not Supported SYMBOL/INTERMEC SW Decoder Scanner
            CB_WIDESCAN.Enabled = False
            CB_HIGHFILTER.Enabled = False
        ElseIf m_EngineType = SCAN_ENGINE_TYPE.ZEBRA_HW_SE965 Then
            ' Not Supported SE965 HW Decoder Scanner                
            CB_WIDESCAN.Enabled = False
            CB_HIGHFILTER.Enabled = False
            CB_ADAPTIVESCAN.Enabled = True

            CB_ADAPTIVESCAN.Checked = m_Scanner.GetAdaptiveScanning()
        End If

        m_Scanner.GetOption(m_DecoderParams)

        If m_bSyncMode = True Then
            RD_SYNC.Checked = True
        Else
            RD_ASYNC.Checked = True
        End If

        CB_VIBRATE.Checked = m_DecoderParams.bVibrate

        If m_DecoderParams.nSound = 1 Then
            RD_BEEP.Checked = True
        ElseIf m_DecoderParams.nSound = 2 Then
            RD_NONE.Checked = True
        Else
            RD_DEFAULT.Checked = True
        End If

        CB_TIMEOUT.SelectedIndex = m_DecoderParams.nTimeOut - 1
        CB_SECURITYLEVEL.SelectedIndex = m_DecoderParams.nSecurityLevel - 1
        CB_AIMID.Checked = m_DecoderParams.bXmitAimID
        CB_CONTINUEMODE.Checked = m_DecoderParams.bContinueMode
        CB_WIDESCAN.Checked = m_DecoderParams.bWindeScan
        CB_HIGHFILTER.Checked = m_DecoderParams.bHighFilter

    End Sub

    Private Sub BTN_OK_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BTN_OK.Click

        If RD_ASYNC.Checked = True Then
            m_bSyncMode = False
        ElseIf RD_SYNC.Checked = True Then
            m_bSyncMode = True
        End If

        If m_EngineType = SCAN_ENGINE_TYPE.ZEBRA_HW_SE965 Then
            m_Scanner.SetAdaptiveScanning(CB_ADAPTIVESCAN.Checked)
        End If

        m_DecoderParams.nTimeOut = CB_TIMEOUT.SelectedIndex + 1
        m_DecoderParams.nSecurityLevel = CB_SECURITYLEVEL.SelectedIndex + 1

        If RD_BEEP.Checked = True Then
            m_DecoderParams.nSound = 1  ' BEEP SOUND
        ElseIf RD_NONE.Checked = True Then
            m_DecoderParams.nSound = 2  ' NO SOUND
        Else
            m_DecoderParams.nSound = 0  ' DEFAULT SOUND
        End If

        m_DecoderParams.bVibrate = CB_VIBRATE.Checked
        m_DecoderParams.bXmitAimID = CB_AIMID.Checked
        m_DecoderParams.bContinueMode = CB_CONTINUEMODE.Checked
        m_Scanner.m_bContinueMode = CB_CONTINUEMODE.Checked
        m_DecoderParams.bWindeScan = CB_WIDESCAN.Checked
        m_DecoderParams.bHighFilter = CB_HIGHFILTER.Checked

        m_Scanner.SetOption(m_DecoderParams)

        Me.DialogResult = Windows.Forms.DialogResult.OK

    End Sub

    Private Sub BTN_CANCEL_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BTN_CANCEL.Click

        Me.DialogResult = Windows.Forms.DialogResult.Cancel
    End Sub


End Class