﻿Imports System
Imports System.Collections.Generic
Imports System.ComponentModel
Imports System.Data
Imports System.Drawing
Imports System.Text
Imports System.Windows.Forms
Imports ScannerNet

Public Class FMSI
    Private m_Scanner As Scanner
    Private m_Msi As MSI_PARAMS

    Private m_EngineType As SCAN_ENGINE_TYPE

    Private Sub FMSI_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        m_Scanner = New Scanner()
        m_Msi = New MSI_PARAMS()

        m_EngineType = m_Scanner.GetEngineType()

        If m_EngineType = SCAN_ENGINE_TYPE.SYMBOL_HW Then
            ' Not Supported SYMBOL HW Decoder Scanner
            LB_MIN.Enabled = False
            TB_MINLEN.Enabled = False
            LB_MAX.Enabled = False
            TB_MAXLEN.Enabled = False
        End If

        m_Scanner.GetMSI(m_Msi)

        CB_ENABLE.Checked = m_Msi.bEnable
        CB_XCD.Checked = m_Msi.bXCD


        If m_Msi.nCDV = 1 Then
            RD_MOD1010.Checked = True
        ElseIf m_Msi.nCDV = 2 Then
            RD_MOD1011.Checked = True
        Else
            RD_MOD10.Checked = True
        End If


        TB_MINLEN.Text = m_Msi.nMinLen.ToString()
        TB_MAXLEN.Text = m_Msi.nMaxLen.ToString()

    End Sub

    Private Sub BTN_OK_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BTN_OK.Click
        m_Msi.bEnable = CB_ENABLE.Checked
        m_Msi.bXCD = CB_XCD.Checked

        If RD_MOD1010.Checked = True Then
            m_Msi.nCDV = 1
        ElseIf RD_MOD1011.Checked = True Then
            m_Msi.nCDV = 2
        Else
            m_Msi.nCDV = 0
        End If

        m_Msi.nMinLen = Int32.Parse(TB_MINLEN.Text)
        m_Msi.nMaxLen = Int32.Parse(TB_MAXLEN.Text)

        m_Scanner.SetMSI(m_Msi)

        Me.DialogResult = Windows.Forms.DialogResult.OK

    End Sub

    Private Sub BTN_CANCEL_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BTN_CANCEL.Click
        Me.DialogResult = Windows.Forms.DialogResult.Cancel
    End Sub
End Class