﻿Imports System
Imports System.Collections.Generic
Imports System.ComponentModel
Imports System.Data
Imports System.Drawing
Imports System.Text
Imports System.Windows.Forms
Imports ScannerNet



Public Class FCODE93

    Private m_Scanner As Scanner
    Private m_Code93 As CODE93_PARAMS

    Private m_EngineType As SCAN_ENGINE_TYPE


    Private Sub FCODE93_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        m_Scanner = New Scanner()
        m_Code93 = New CODE93_PARAMS()

        m_EngineType = m_Scanner.GetEngineType()

        If m_EngineType = SCAN_ENGINE_TYPE.SYMBOL_HW Then
            ' Not Supported SYMBOL HW Decoder Scanner
            LB_MIN.Enabled = False
            TB_MINLEN.Enabled = False
            LB_MAX.Enabled = False
            TB_MAXLEN.Enabled = False
        End If

        m_Scanner.GetCODE93(m_Code93)

        CB_ENABLE.Checked = m_Code93.bEnable

        TB_MINLEN.Text = m_Code93.nMinLen.ToString()
        TB_MAXLEN.Text = m_Code93.nMaxLen.ToString()

    End Sub

    Private Sub BTN_OK_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BTN_OK.Click

        m_Code93.bEnable = CB_ENABLE.Checked

        m_Code93.nMinLen = Int32.Parse(TB_MINLEN.Text)
        m_Code93.nMaxLen = Int32.Parse(TB_MAXLEN.Text)

        m_Scanner.SetCODE93(m_Code93)

        Me.DialogResult = Windows.Forms.DialogResult.OK

    End Sub

    Private Sub BTN_CANCEL_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BTN_CANCEL.Click
        Me.DialogResult = Windows.Forms.DialogResult.Cancel
    End Sub

End Class