﻿Imports System
Imports System.Collections.Generic
Imports System.ComponentModel
Imports System.Data
Imports System.Drawing
Imports System.Text
Imports System.Windows.Forms
Imports ScannerNet

Public Class FCODE39

    Private m_Scanner As Scanner
    Private m_Code39 As CODE39_PARAMS

    Private m_EngineType As SCAN_ENGINE_TYPE


    Private Sub FCODE39_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        m_Scanner = New Scanner()
        m_Code39 = New CODE39_PARAMS()

        m_EngineType = m_Scanner.GetEngineType()

        If m_EngineType = SCAN_ENGINE_TYPE.CINO Or m_EngineType = SCAN_ENGINE_TYPE.SYMBOL_HW Then
            ' Not Supported CINO / SYMBOL HW Decoder Scanner
            RD_PZN.Enabled = False

            If m_EngineType = SCAN_ENGINE_TYPE.SYMBOL_HW Then
                ' Not Supported SYMBOL HW Decoder Scanner
                LB_MIN.Enabled = False
                TB_MINLEN.Enabled = False
                LB_MAX.Enabled = False
                TB_MAXLEN.Enabled = False
            End If

        End If

        m_Scanner.GetCODE39(m_Code39)

        CB_ENABLE.Checked = m_Code39.bEnable
        CB_CDV.Checked = m_Code39.bCDV
        CB_XCD.Checked = m_Code39.bXCD

        Select Case m_Code39.nFormat
            Case Is > 0 : RD_STANDARD.Checked = True
            Case Is > 1 : RD_CODE32.Checked = True
            Case Is > 2 : RD_PZN.Checked = True
            Case Is > 3 : RD_TRIOPTIC.Checked = True
            Case Is > 4 : RD_FULLASCII.Checked = True
        End Select

        TB_MINLEN.Text = m_Code39.nMinLen.ToString()
        TB_MAXLEN.Text = m_Code39.nMaxLen.ToString()

    End Sub

    Private Sub BTN_OK_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BTN_OK.Click

        m_Code39.bEnable = CB_ENABLE.Checked
        m_Code39.bCDV = CB_CDV.Checked
        m_Code39.bXCD = CB_XCD.Checked

        If RD_CODE32.Checked = True Then
            m_Code39.nFormat = 1
        ElseIf RD_PZN.Checked = True Then
            m_Code39.nFormat = 2
        ElseIf RD_TRIOPTIC.Checked = True Then
            m_Code39.nFormat = 3
        ElseIf RD_FULLASCII.Checked = True Then
            m_Code39.nFormat = 4
        Else
            m_Code39.nFormat = 0
        End If

        m_Code39.nMinLen = Int32.Parse(TB_MINLEN.Text)
        m_Code39.nMaxLen = Int32.Parse(TB_MAXLEN.Text)

        m_Scanner.SetCODE39(m_Code39)

        Me.DialogResult = Windows.Forms.DialogResult.OK

    End Sub

    Private Sub BTN_CANCEL_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BTN_CANCEL.Click
        Me.DialogResult = Windows.Forms.DialogResult.Cancel

    End Sub
End Class

