﻿Imports System
Imports System.Collections.Generic
Imports System.ComponentModel
Imports System.Data
Imports System.Drawing
Imports System.Text
Imports System.Windows.Forms
Imports ScannerNet

Public Class FCODE25

    Private m_Scanner As Scanner
    Private m_Code25 As CODE25_PARAMS

    Private m_EngineType As SCAN_ENGINE_TYPE

    Private Sub FCODE25_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        m_Scanner = New Scanner()
        m_Code25 = New CODE25_PARAMS()

        m_EngineType = m_Scanner.GetEngineType()

        If m_EngineType = SCAN_ENGINE_TYPE.CINO Then
            ' Not Supported CINO Scanner
            CB_CODE25_INDUSTRY.Enabled = False
        ElseIf m_EngineType = SCAN_ENGINE_TYPE.SYMBOL_HW Then
            ' Not Supported SYMBOL HW Decoder Scanner
            CB_STANDARD_2OF5.Enabled = False
            CB_MATRIX_2OF5.Enabled = False

            LB_MIN.Enabled = False
            TB_MINLEN.Enabled = False
            LB_MAX.Enabled = False
            TB_MAXLEN.Enabled = False
        Else
            CB_STANDARD_2OF5.Visible = False
        End If

        m_Scanner.GetCODE25(m_Code25)

        CB_ENABLE.Checked = m_Code25.bI2OF5
        CB_STANDARD_2OF5.Checked = m_Code25.bS2OF5
        CB_ITF14.Checked = m_Code25.bITF14
        CB_MATRIX_2OF5.Checked = m_Code25.bMATRIX2OF5
        CB_CHINAPOST.Checked = m_Code25.bCHINAPOST
        CB_CODE25_INDUSTRY.Checked = m_Code25.bINDUSTRY
        CB_CODE25_IATA.Checked = m_Code25.bIATA
        CB_CDV.Checked = m_Code25.bCDV
        CB_XCD.Checked = m_Code25.bXCD

        TB_MINLEN.Text = m_Code25.nMinLen.ToString()
        TB_MAXLEN.Text = m_Code25.nMaxLen.ToString()

    End Sub


    Private Sub BTN_OK_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BTN_OK.Click

        m_Code25.bI2OF5 = CB_ENABLE.Checked
        m_Code25.bS2OF5 = CB_STANDARD_2OF5.Checked
        m_Code25.bITF14 = CB_ITF14.Checked
        m_Code25.bMATRIX2OF5 = CB_MATRIX_2OF5.Checked
        m_Code25.bCHINAPOST = CB_CHINAPOST.Checked
        m_Code25.bINDUSTRY = CB_CODE25_INDUSTRY.Checked
        m_Code25.bIATA = CB_CODE25_IATA.Checked
        m_Code25.bCDV = CB_CDV.Checked
        m_Code25.bXCD = CB_XCD.Checked

        m_Code25.nMinLen = Int32.Parse(TB_MINLEN.Text)
        m_Code25.nMaxLen = Int32.Parse(TB_MAXLEN.Text)

        m_Scanner.SetCODE25(m_Code25)

        Me.DialogResult = Windows.Forms.DialogResult.OK
    End Sub

    Private Sub BTN_CANCEL_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BTN_CANCEL.Click
        Me.DialogResult = Windows.Forms.DialogResult.Cancel
    End Sub


End Class

 



