﻿Imports System
Imports System.Collections.Generic
Imports System.ComponentModel
Imports System.Data
Imports System.Drawing
Imports System.Text
Imports System.Windows.Forms
Imports ScannerNet



Public Class FCODE128

    Private m_Scanner As Scanner
    Private m_Code128 As CODE128_PARAMS

    Private m_EngineType As SCAN_ENGINE_TYPE


    Private Sub FCODE128_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        m_Scanner = New Scanner()
        m_Code128 = New CODE128_PARAMS()

        m_EngineType = m_Scanner.GetEngineType()

        If m_EngineType = SCAN_ENGINE_TYPE.CINO Then
            ' Not Supported CINO Scanner
            LB_FNCASCII.Enabled = False
            TB_ASCII.Enabled = False

        ElseIf m_EngineType = SCAN_ENGINE_TYPE.SYMBOL_HW Then
            ' Not Supported SYMBOL HW Decoder Scanner
            LB_FNCASCII.Enabled = False
            TB_ASCII.Enabled = False

            LB_MIN.Enabled = False
            TB_MINLEN.Enabled = False
            LB_MAX.Enabled = False
            TB_MAXLEN.Enabled = False
        End If

        m_Scanner.GetCODE128(m_Code128)

        CB_ENABLE.Checked = m_Code128.bEnable
        CB_UCCEAN128.Checked = m_Code128.bUCCEAN128
        TB_ASCII.Text = m_Code128.strFNC1_ASCII

        TB_MINLEN.Text = m_Code128.nMinLen.ToString()
        TB_MAXLEN.Text = m_Code128.nMaxLen.ToString()

    End Sub


    Private Sub BTN_OK_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BTN_OK.Click
        m_Code128.bEnable = CB_ENABLE.Checked
        m_Code128.bUCCEAN128 = CB_UCCEAN128.Checked
        m_Code128.strFNC1_ASCII = TB_ASCII.Text

        m_Code128.nMinLen = Int32.Parse(TB_MINLEN.Text)
        m_Code128.nMaxLen = Int32.Parse(TB_MAXLEN.Text)

        m_Scanner.SetCODE128(m_Code128)

        Me.DialogResult = Windows.Forms.DialogResult.OK

    End Sub

    Private Sub BTN_CANCEL_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BTN_CANCEL.Click
        Me.DialogResult = Windows.Forms.DialogResult.Cancel
    End Sub
End Class

